/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.io.Serializable;

public class OffsetFilter
extends ImageFilter
implements Serializable {
    static final long serialVersionUID = 8123120922961090736L;
    private int width;
    private int height;
    private int xOffset;
    private int yOffset;
    private boolean wrap;

    public OffsetFilter() {
        this(0, 0, true);
    }

    public OffsetFilter(int xOffset, int yOffset, boolean wrap) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.wrap = wrap;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public boolean getWrap() {
        return this.wrap;
    }

    @Override
    public void setHints(int hintflags) {
        this.consumer.setHints(hintflags &= 0xFFFFFFFD);
    }

    @Override
    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        while (this.xOffset < 0) {
            this.xOffset += width;
        }
        while (this.yOffset < 0) {
            this.yOffset += height;
        }
        this.xOffset %= width;
        this.yOffset %= height;
        this.consumer.setDimensions(width, height);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        this.consumer.setPixels(x + this.xOffset, y + this.yOffset, this.width - this.xOffset, this.height - this.yOffset, model, pixels, 0, scansize);
        if (this.wrap) {
            if (x + w + this.xOffset > this.width) {
                this.consumer.setPixels(0, y + this.yOffset, this.xOffset - (this.width - x - w), this.height - this.yOffset, model, pixels, w - this.xOffset, scansize);
                if (y + h + this.yOffset > this.height) {
                    this.consumer.setPixels(0, 0, this.xOffset - (this.width - x - w), this.yOffset - (this.height - y - h), model, pixels, w - this.xOffset + (h - this.yOffset) * scansize, scansize);
                }
            }
            if (y + h + this.yOffset > this.height) {
                this.consumer.setPixels(x + this.xOffset, 0, this.width - this.xOffset, this.yOffset - (this.height - y - h), model, pixels, (h - this.yOffset) * scansize, scansize);
            }
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        this.consumer.setPixels(x + this.xOffset, y + this.yOffset, this.width - this.xOffset, this.height - this.yOffset, model, pixels, 0, scansize);
        if (this.wrap) {
            if (x + w + this.xOffset > this.width) {
                this.consumer.setPixels(0, y + this.yOffset, this.xOffset - (this.width - x - w), this.height - this.yOffset, model, pixels, w - this.xOffset, scansize);
                if (y + h + this.yOffset > this.height) {
                    this.consumer.setPixels(0, 0, this.xOffset - (this.width - x - w), this.yOffset - (this.height - y - h), model, pixels, w - this.xOffset + (h - this.yOffset) * scansize, scansize);
                }
            }
            if (y + h + this.yOffset > this.height) {
                this.consumer.setPixels(x + this.xOffset, 0, this.width - this.xOffset, this.yOffset - (this.height - y - h), model, pixels, (h - this.yOffset) * scansize, scansize);
            }
        }
    }

    public String toString() {
        return "Distort/Offset...";
    }
}

