/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.BinaryFilter;

public class DilateFilter
extends BinaryFilter {
    public int threshold = 2;

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int width = this.originalSpace.width;
        int height = this.originalSpace.height;
        int[] outPixels = new int[width * height];
        for (int i = 0; i < this.iterations; ++i) {
            int index = 0;
            if (i > 0) {
                int[] t = this.inPixels;
                this.inPixels = outPixels;
                outPixels = t;
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = this.inPixels[y * width + x];
                    if (!this.blackFunction.isBlack(pixel)) {
                        int neighbours = 0;
                        for (int dy = -1; dy <= 1; ++dy) {
                            int iy = y + dy;
                            if (0 > iy || iy >= height) continue;
                            int ioffset = iy * width;
                            for (int dx = -1; dx <= 1; ++dx) {
                                int rgb;
                                int ix = x + dx;
                                if (dy == 0 && dx == 0 || 0 > ix || ix >= width || !this.blackFunction.isBlack(rgb = this.inPixels[ioffset + ix])) continue;
                                ++neighbours;
                            }
                        }
                        if (neighbours >= this.threshold) {
                            pixel = this.colormap != null ? this.colormap.getColor((float)i / (float)this.iterations) : this.newColor;
                        }
                    }
                    outPixels[index++] = pixel;
                }
            }
        }
        this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, outPixels, 0, width);
        this.consumer.imageComplete(status);
        this.inPixels = null;
    }

    public String toString() {
        return "Binary/Dilate...";
    }
}

