/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import java.io.PrintStream;

public class WildcardStringParser {
    public static final char[] ALPHABET = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e6', '\u00f8', '\u00e5', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'N', 'M', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c6', '\u00d8', '\u00c5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', '_', '-'};
    public static final char FREE_RANGE_CHARACTER = '*';
    public static final char FREE_PASS_CHARACTER = '?';
    boolean initialized;
    String stringMask;
    WildcardStringParserState initialState;
    int totalNumberOfStringsParsed;
    boolean debugging;
    PrintStream out;

    public WildcardStringParser(String pStringMask) {
        this(pStringMask, false);
    }

    public WildcardStringParser(String pStringMask, boolean pDebugging) {
        this(pStringMask, pDebugging, System.out);
    }

    public WildcardStringParser(String pStringMask, boolean pDebugging, PrintStream pDebuggingPrintStream) {
        this.stringMask = pStringMask;
        this.debugging = pDebugging;
        this.out = pDebuggingPrintStream;
        this.initialized = this.buildAutomaton();
    }

    private boolean checkIfStateInWildcardRange(WildcardStringParserState pState) {
        WildcardStringParserState runnerState = pState;
        while (runnerState.previousState != null) {
            runnerState = runnerState.previousState;
            if (WildcardStringParser.isFreeRangeCharacter(runnerState.character)) {
                return true;
            }
            if (WildcardStringParser.isFreePassCharacter(runnerState.character)) continue;
            return false;
        }
        return false;
    }

    private boolean checkIfLastFreeRangeState(WildcardStringParserState pState) {
        if (WildcardStringParser.isFreeRangeCharacter(pState.character)) {
            return true;
        }
        return WildcardStringParser.isFreePassCharacter(pState.character) && this.checkIfStateInWildcardRange(pState);
    }

    private boolean isTrivialAutomaton() {
        for (int i = 0; i < this.stringMask.length(); ++i) {
            if (WildcardStringParser.isFreeRangeCharacter(this.stringMask.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean buildAutomaton() {
        WildcardStringParserState runnerState = null;
        WildcardStringParserState newState = null;
        WildcardStringParserState lastFreeRangeState = null;
        if (this.stringMask != null && this.stringMask.length() > 0) {
            newState = new WildcardStringParserState(this.stringMask.charAt(0));
            newState.automatonStateNumber = 0;
            newState.previousState = null;
            if (this.checkIfLastFreeRangeState(newState)) {
                lastFreeRangeState = newState;
            }
        } else {
            System.err.println("string mask provided are null or empty - aborting!");
            return false;
        }
        this.initialState = runnerState = newState;
        this.initialState.automatonStateNumber = 0;
        for (int i = 1; i < this.stringMask.length(); ++i) {
            char activeChar = this.stringMask.charAt(i);
            if (!WildcardStringParser.isInAlphabet(activeChar) && !WildcardStringParser.isWildcardCharacter(activeChar)) {
                System.err.println("one or more characters in string mask are not legal characters - aborting!");
                return false;
            }
            runnerState.lastFreeRangeState = lastFreeRangeState;
            newState = new WildcardStringParserState(activeChar);
            newState.automatonStateNumber = i;
            newState.previousState = runnerState;
            if (this.checkIfLastFreeRangeState(newState)) {
                lastFreeRangeState = newState;
            }
            runnerState.nextState = newState;
            runnerState = newState;
            if (runnerState.automatonStateNumber != this.stringMask.length() - 1) continue;
            runnerState.lastFreeRangeState = lastFreeRangeState;
        }
        this.totalNumberOfStringsParsed = 0;
        return true;
    }

    public static boolean isInAlphabet(char pCharToCheck) {
        for (int i = 0; i < ALPHABET.length; ++i) {
            if (pCharToCheck != ALPHABET[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isFreeRangeCharacter(char pCharToCheck) {
        return pCharToCheck == '*';
    }

    public static boolean isFreePassCharacter(char pCharToCheck) {
        return pCharToCheck == '?';
    }

    public static boolean isWildcardCharacter(char pCharToCheck) {
        return WildcardStringParser.isFreeRangeCharacter(pCharToCheck) || WildcardStringParser.isFreePassCharacter(pCharToCheck);
    }

    public String getStringMask() {
        return this.stringMask;
    }

    public boolean parseString(String pStringToParse) {
        if (this.debugging) {
            this.out.println("parsing \"" + pStringToParse + "\"...");
        }
        ++this.totalNumberOfStringsParsed;
        if (pStringToParse == null) {
            if (this.debugging) {
                this.out.println("string to be parsed is null - rejection!");
            }
            return false;
        }
        ParsableString parsableString = new ParsableString(pStringToParse);
        if (!parsableString.checkString()) {
            if (this.debugging) {
                this.out.println("one or more characters in string to be parsed are not legal characters - rejection!");
            }
            return false;
        }
        if (!this.initialized) {
            System.err.println("automaton is not initialized - rejection!");
            return false;
        }
        if (this.isTrivialAutomaton()) {
            if (this.debugging) {
                this.out.println("automaton represents a trivial string mask (accepts all strings) - acceptance!");
            }
            return true;
        }
        if (parsableString.isEmpty()) {
            if (this.debugging) {
                this.out.println("string to be parsed is empty and not trivial automaton - rejection!");
            }
            return false;
        }
        boolean hasPerformedFreeRangeMovement = false;
        int numberOfFreePassCharactersRead_SinceLastFreePassState = 0;
        int numberOfParsedCharactersRead_SinceLastFreePassState = 0;
        WildcardStringParserState runnerState = null;
        if (parsableString.charArray[0] != this.initialState.character && !WildcardStringParser.isWildcardCharacter(this.initialState.character)) {
            if (this.debugging) {
                this.out.println("cannot enter first automaton state - rejection!");
            }
            return false;
        }
        runnerState = this.initialState;
        parsableString.index = 0;
        if (WildcardStringParser.isFreePassCharacter(runnerState.character)) {
            ++numberOfFreePassCharactersRead_SinceLastFreePassState;
        }
        for (int i = 0; i < parsableString.length(); ++i) {
            if (this.debugging) {
                this.out.println();
            }
            if (this.debugging) {
                this.out.println("parsing - index number " + i + ", active char: '" + parsableString.getActiveChar() + "' char string index: " + parsableString.index + " number of chars since last free-range state: " + numberOfParsedCharactersRead_SinceLastFreePassState);
            }
            if (this.debugging) {
                this.out.println("parsing - state: " + runnerState.automatonStateNumber + " '" + runnerState.character + "' - no of free-pass chars read: " + numberOfFreePassCharactersRead_SinceLastFreePassState);
            }
            if (this.debugging) {
                this.out.println("parsing - hasPerformedFreeRangeMovement: " + hasPerformedFreeRangeMovement);
            }
            if (runnerState.nextState == null) {
                if (this.debugging) {
                    this.out.println("parsing - runnerState.nextState == null");
                }
                if (WildcardStringParser.isFreeRangeCharacter(runnerState.character)) {
                    if (hasPerformedFreeRangeMovement) {
                        if (parsableString.reachedEndOfString()) {
                            if (numberOfFreePassCharactersRead_SinceLastFreePassState > numberOfParsedCharactersRead_SinceLastFreePassState) {
                                if (this.debugging) {
                                    this.out.println("no subsequent state (final state) and the state represents '*' - end of parsing string, but not enough characters read - rejection!");
                                }
                                return false;
                            }
                            if (this.debugging) {
                                this.out.println("no subsequent state (final state) and the state represents '*' - end of parsing string and enough characters read - acceptance!");
                            }
                            return true;
                        }
                        if (numberOfFreePassCharactersRead_SinceLastFreePassState > numberOfParsedCharactersRead_SinceLastFreePassState) {
                            if (this.debugging) {
                                this.out.println("no subsequent state (final state) and the state represents '*' - not the end of parsing string and not enough characters read - read next character");
                            }
                            ++parsableString.index;
                            ++numberOfParsedCharactersRead_SinceLastFreePassState;
                            continue;
                        }
                        if (this.debugging) {
                            this.out.println("no subsequent state (final state) and the state represents '*' - not the end of parsing string, but enough characters read - acceptance!");
                        }
                        return true;
                    }
                    if (this.debugging) {
                        this.out.println("no subsequent state (final state) and the state represents '*' - no skipping performed - acceptance!");
                    }
                    return true;
                }
                if (parsableString.reachedEndOfString()) {
                    if (hasPerformedFreeRangeMovement && numberOfFreePassCharactersRead_SinceLastFreePassState > numberOfParsedCharactersRead_SinceLastFreePassState) {
                        if (this.debugging) {
                            this.out.println("no subsequent state (final state) and skipping has been performed and end of parsing string, but not enough characters read - rejection!");
                        }
                        return false;
                    }
                    if (this.debugging) {
                        this.out.println("no subsequent state (final state) and the end of the string to test is reached - acceptance!");
                    }
                    return true;
                }
                if (!this.debugging) continue;
                this.out.println("parsing - escaping process...");
                continue;
            }
            if (this.debugging) {
                this.out.println("parsing - runnerState.nextState != null");
            }
            if (WildcardStringParser.isFreeRangeCharacter(runnerState.character)) {
                numberOfFreePassCharactersRead_SinceLastFreePassState = 0;
                numberOfParsedCharactersRead_SinceLastFreePassState = 0;
                WildcardStringParserState freeRangeRunnerState = runnerState.nextState;
                while (freeRangeRunnerState != null && WildcardStringParser.isFreePassCharacter(freeRangeRunnerState.character)) {
                    runnerState = freeRangeRunnerState;
                    hasPerformedFreeRangeMovement = true;
                    ++numberOfFreePassCharactersRead_SinceLastFreePassState;
                    freeRangeRunnerState = freeRangeRunnerState.nextState;
                }
                if (runnerState.nextState == null) {
                    if (this.debugging) {
                        this.out.println();
                    }
                    if (this.debugging) {
                        this.out.println("parsing - index number " + i + ", active char: '" + parsableString.getActiveChar() + "' char string index: " + parsableString.index + " number of chars since last free-range state: " + numberOfParsedCharactersRead_SinceLastFreePassState);
                    }
                    if (this.debugging) {
                        this.out.println("parsing - state: " + runnerState.automatonStateNumber + " '" + runnerState.character + "' - no of free-pass chars read: " + numberOfFreePassCharactersRead_SinceLastFreePassState);
                    }
                    if (this.debugging) {
                        this.out.println("parsing - hasPerformedFreeRangeMovement: " + hasPerformedFreeRangeMovement);
                    }
                    return hasPerformedFreeRangeMovement && numberOfFreePassCharactersRead_SinceLastFreePassState >= numberOfParsedCharactersRead_SinceLastFreePassState;
                }
            }
            if (WildcardStringParser.isFreeRangeCharacter(runnerState.nextState.character)) {
                runnerState = runnerState.nextState;
                ++parsableString.index;
                ++numberOfParsedCharactersRead_SinceLastFreePassState;
                continue;
            }
            if (WildcardStringParser.isFreePassCharacter(runnerState.nextState.character)) {
                runnerState = runnerState.nextState;
                ++parsableString.index;
                ++numberOfFreePassCharactersRead_SinceLastFreePassState;
                ++numberOfParsedCharactersRead_SinceLastFreePassState;
                continue;
            }
            if (!parsableString.reachedEndOfString() && runnerState.nextState.character == parsableString.getSubsequentChar()) {
                runnerState = runnerState.nextState;
                ++parsableString.index;
                ++numberOfParsedCharactersRead_SinceLastFreePassState;
                continue;
            }
            if (runnerState.lastFreeRangeState != null) {
                runnerState = runnerState.lastFreeRangeState;
                ++parsableString.index;
                ++numberOfParsedCharactersRead_SinceLastFreePassState;
                continue;
            }
            if (this.debugging) {
                this.out.println("the next state does not represent the same character as the next character in the string to test, and there are no last-free-range-state - rejection!");
            }
            return false;
        }
        if (this.debugging) {
            this.out.println("finished reading parsing string and not at any final state - rejection!");
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (!this.initialized) {
            buffer.append(this.getClass().getName());
            buffer.append(":  Not initialized properly!");
            buffer.append("\n");
            buffer.append("\n");
        } else {
            WildcardStringParserState runnerState = this.initialState;
            buffer.append(this.getClass().getName());
            buffer.append(":  String mask ");
            buffer.append(this.stringMask);
            buffer.append("\n");
            buffer.append("\n");
            buffer.append("      Automaton: ");
            while (runnerState != null) {
                buffer.append(runnerState.automatonStateNumber);
                buffer.append(": ");
                buffer.append(runnerState.character);
                buffer.append(" (");
                if (runnerState.lastFreeRangeState != null) {
                    buffer.append(runnerState.lastFreeRangeState.automatonStateNumber);
                } else {
                    buffer.append("-");
                }
                buffer.append(")");
                if (runnerState.nextState != null) {
                    buffer.append("   -->   ");
                }
                runnerState = runnerState.nextState;
            }
            buffer.append("\n");
            buffer.append("      Format: <state index>: <character> (<last free state>)");
            buffer.append("\n");
            buffer.append("      Number of strings parsed: " + this.totalNumberOfStringsParsed);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public boolean equals(Object pObject) {
        if (pObject instanceof WildcardStringParser) {
            WildcardStringParser externalParser = (WildcardStringParser)pObject;
            return externalParser.initialized == this.initialized && externalParser.stringMask == this.stringMask;
        }
        return super.equals(pObject);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected Object clone() throws CloneNotSupportedException {
        if (this.initialized) {
            return new WildcardStringParser(this.stringMask);
        }
        return null;
    }

    protected void finalize() throws Throwable {
    }

    class ParsableString {
        char[] charArray;
        int index;

        ParsableString(String pStringToParse) {
            if (pStringToParse != null) {
                this.charArray = pStringToParse.toCharArray();
            }
            this.index = -1;
        }

        boolean reachedEndOfString() {
            return this.index == this.charArray.length - 1;
        }

        int length() {
            return this.charArray.length;
        }

        char getActiveChar() {
            if (this.index > -1 && this.index < this.charArray.length) {
                return this.charArray[this.index];
            }
            System.err.println(this.getClass().getName() + ": trying to access character outside character array!");
            return ' ';
        }

        char getSubsequentChar() {
            if (this.index > -1 && this.index + 1 < this.charArray.length) {
                return this.charArray[this.index + 1];
            }
            System.err.println(this.getClass().getName() + ": trying to access character outside character array!");
            return ' ';
        }

        boolean checkString() {
            if (!this.isEmpty()) {
                for (int i = 0; i < this.charArray.length; ++i) {
                    if (WildcardStringParser.isInAlphabet(this.charArray[i])) continue;
                    return false;
                }
            }
            return true;
        }

        boolean isEmpty() {
            return this.charArray == null || this.charArray.length == 0;
        }

        public String toString() {
            return new String(this.charArray);
        }
    }

    class WildcardStringParserState {
        int automatonStateNumber;
        char character;
        WildcardStringParserState previousState;
        WildcardStringParserState nextState;
        WildcardStringParserState lastFreeRangeState;

        public WildcardStringParserState(char pChar) {
            this.character = pChar;
        }
    }
}

