/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public final class Validate {
    private static final String UNSPECIFIED_PARAM_NAME = "method parameter";

    private Validate() {
    }

    public static <T> T notNull(T pParameter) {
        return Validate.notNull(pParameter, null);
    }

    public static <T> T notNull(T pParameter, String pParamName) {
        if (pParameter == null) {
            throw new IllegalArgumentException(String.format("%s may not be null", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }

    public static <T extends CharSequence> T notEmpty(T pParameter) {
        return Validate.notEmpty(pParameter, null);
    }

    public static <T extends CharSequence> T notEmpty(T pParameter, String pParamName) {
        if (pParameter == null || pParameter.length() == 0 || Validate.isOnlyWhiteSpace(pParameter)) {
            throw new IllegalArgumentException(String.format("%s may not be blank", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }

    private static <T extends CharSequence> boolean isOnlyWhiteSpace(T pParameter) {
        for (int i = 0; i < pParameter.length(); ++i) {
            if (Character.isWhitespace(pParameter.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] notEmpty(T[] pParameter) {
        return Validate.notEmpty(pParameter, null);
    }

    public static <T> T[] notEmpty(T[] pParameter, String pParamName) {
        if (pParameter == null || pParameter.length == 0) {
            throw new IllegalArgumentException(String.format("%s may not be empty", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }

    public static <T> Collection<T> notEmpty(Collection<T> pParameter) {
        return Validate.notEmpty(pParameter, null);
    }

    public static <T> Collection<T> notEmpty(Collection<T> pParameter, String pParamName) {
        if (pParameter == null || pParameter.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s may not be empty", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> pParameter) {
        return Validate.notEmpty(pParameter, null);
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> pParameter, String pParamName) {
        if (pParameter == null || pParameter.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s may not be empty", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }

    public static <T> T[] noNullElements(T[] pParameter) {
        return Validate.noNullElements(pParameter, null);
    }

    public static <T> T[] noNullElements(T[] pParameter, String pParamName) {
        Validate.noNullElements(pParameter == null ? null : Arrays.asList(pParameter), pParamName);
        return pParameter;
    }

    public static <T> Collection<T> noNullElements(Collection<T> pParameter) {
        return Validate.noNullElements(pParameter, null);
    }

    public static <T> Collection<T> noNullElements(Collection<T> pParameter, String pParamName) {
        Validate.notNull(pParameter, pParamName);
        for (T element : pParameter) {
            if (element != null) continue;
            throw new IllegalArgumentException(String.format("%s may not contain null elements", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }

    public static <K, V> Map<K, V> noNullValues(Map<K, V> pParameter) {
        return Validate.noNullValues(pParameter, null);
    }

    public static <K, V> Map<K, V> noNullValues(Map<K, V> pParameter, String pParamName) {
        Validate.notNull(pParameter, pParamName);
        for (V value : pParameter.values()) {
            if (value != null) continue;
            throw new IllegalArgumentException(String.format("%s may not contain null values", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }

    public static <K, V> Map<K, V> noNullKeys(Map<K, V> pParameter) {
        return Validate.noNullKeys(pParameter, null);
    }

    public static <K, V> Map<K, V> noNullKeys(Map<K, V> pParameter, String pParamName) {
        Validate.notNull(pParameter, pParamName);
        for (K key : pParameter.keySet()) {
            if (key != null) continue;
            throw new IllegalArgumentException(String.format("%s may not contain null keys", pParamName == null ? UNSPECIFIED_PARAM_NAME : pParamName));
        }
        return pParameter;
    }

    public static boolean isTrue(boolean pExpression, String pMessage) {
        return Validate.isTrue(pExpression, pExpression, pMessage);
    }

    public static <T> T isTrue(boolean condition, T value, String message) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message == null ? "expression may not be %s" : message, value));
        }
        return value;
    }
}

