/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.ThumbnailReadProgressListener;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

abstract class ThumbnailReader {
    private final ThumbnailReadProgressListener progressListener;
    protected final int imageIndex;
    protected final int thumbnailIndex;

    protected ThumbnailReader(ThumbnailReadProgressListener progressListener, int imageIndex, int thumbnailIndex) {
        this.progressListener = progressListener != null ? progressListener : new NullProgressListener();
        this.imageIndex = imageIndex;
        this.thumbnailIndex = thumbnailIndex;
    }

    protected final void processThumbnailStarted() {
        this.progressListener.processThumbnailStarted(this.imageIndex, this.thumbnailIndex);
    }

    protected final void processThumbnailProgress(float percentageDone) {
        this.progressListener.processThumbnailProgress(percentageDone);
    }

    protected final void processThumbnailComplete() {
        this.progressListener.processThumbnailComplete();
    }

    protected static BufferedImage readJPEGThumbnail(ImageReader reader, ImageInputStream stream) throws IOException {
        reader.setInput(stream);
        return reader.read(0);
    }

    protected static BufferedImage readRawThumbnail(byte[] thumbnail, int size, int offset, int w, int h) {
        DataBufferByte buffer = new DataBufferByte(thumbnail, size, offset);
        WritableRaster raster = Raster.createInterleavedRaster(buffer, w, h, w * 3, 3, new int[]{0, 1, 2}, null);
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
        return new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
    }

    public abstract BufferedImage read() throws IOException;

    public abstract int getWidth() throws IOException;

    public abstract int getHeight() throws IOException;

    private static class NullProgressListener
    implements ThumbnailReadProgressListener {
        private NullProgressListener() {
        }

        @Override
        public void processThumbnailStarted(int imageIndex, int thumbnailIndex) {
        }

        @Override
        public void processThumbnailProgress(float percentageDone) {
        }

        @Override
        public void processThumbnailComplete() {
        }
    }
}

