/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.Validate;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class LittleEndianDataInputStream
extends FilterInputStream
implements DataInput {
    public LittleEndianDataInputStream(InputStream pStream) {
        super(Validate.notNull(pStream, "stream"));
    }

    @Override
    public boolean readBoolean() throws IOException {
        int b = this.in.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int b = this.in.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    @Override
    public char readChar() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 < 0) {
            throw new EOFException();
        }
        return (char)(byte2 << 24 >>> 16 | byte1 << 24 >>> 24);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final void readFully(byte[] pBytes) throws IOException {
        this.readFully(pBytes, 0, pBytes.length);
    }

    @Override
    public final void readFully(byte[] pBytes, int pOffset, int pLength) throws IOException {
        int read;
        if (pLength < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int count = 0; count < pLength; count += read) {
            read = this.in.read(pBytes, pOffset + count, pLength - count);
            if (read >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public int readInt() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        int byte3 = this.in.read();
        int byte4 = this.in.read();
        if (byte4 < 0) {
            throw new EOFException();
        }
        return byte4 << 24 | byte3 << 24 >>> 8 | byte2 << 24 >>> 16 | byte1 << 24 >>> 24;
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        DataInputStream ds = new DataInputStream(this.in);
        return ds.readLine();
    }

    @Override
    public long readLong() throws IOException {
        long byte1 = this.in.read();
        long byte2 = this.in.read();
        long byte3 = this.in.read();
        long byte4 = this.in.read();
        long byte5 = this.in.read();
        long byte6 = this.in.read();
        long byte7 = this.in.read();
        long byte8 = this.in.read();
        if (byte8 < 0L) {
            throw new EOFException();
        }
        return byte8 << 56 | byte7 << 56 >>> 8 | byte6 << 56 >>> 16 | byte5 << 56 >>> 24 | byte4 << 56 >>> 32 | byte3 << 56 >>> 40 | byte2 << 56 >>> 48 | byte1 << 56 >>> 56;
    }

    @Override
    public short readShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 < 0) {
            throw new EOFException();
        }
        return (short)(byte2 << 24 >>> 16 | byte1 << 24 >>> 24);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int b = this.in.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 < 0) {
            throw new EOFException();
        }
        return (byte2 << 8) + byte1;
    }

    @Override
    public String readUTF() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 < 0) {
            throw new EOFException();
        }
        int numbytes = (byte1 << 8) + byte2;
        char[] result = new char[numbytes];
        int numread = 0;
        int numchars = 0;
        while (numread < numbytes) {
            int c2;
            int c1 = this.readUnsignedByte();
            int test = c1 >> 4;
            if (test < 8) {
                ++numread;
                result[numchars++] = (char)c1;
                continue;
            }
            if (test == 12 || test == 13) {
                if ((numread += 2) > numbytes) {
                    throw new UTFDataFormatException();
                }
                c2 = this.readUnsignedByte();
                if ((c2 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                result[numchars++] = (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                continue;
            }
            if (test == 14) {
                if ((numread += 3) > numbytes) {
                    throw new UTFDataFormatException();
                }
                c2 = this.readUnsignedByte();
                int c3 = this.readUnsignedByte();
                if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                result[numchars++] = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException();
        }
        return new String(result, 0, numchars);
    }

    @Override
    public final int skipBytes(int pLength) throws IOException {
        int total;
        int skipped;
        for (total = 0; total < pLength && (skipped = (int)this.in.skip(pLength - total)) > 0; total += skipped) {
        }
        return total;
    }
}

