/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilterIterator<E>
implements Iterator<E> {
    protected final Filter<E> filter;
    protected final Iterator<E> iterator;
    private E next = null;
    private E current = null;

    public FilterIterator(Iterator<E> pIterator, Filter<E> pFilter) {
        if (pIterator == null) {
            throw new IllegalArgumentException("iterator == null");
        }
        if (pFilter == null) {
            throw new IllegalArgumentException("filter == null");
        }
        this.iterator = pIterator;
        this.filter = pFilter;
    }

    @Override
    public boolean hasNext() {
        while (this.next == null && this.iterator.hasNext()) {
            E element = this.iterator.next();
            if (!this.filter.accept(element)) continue;
            this.next = element;
            break;
        }
        return this.next != null;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            this.current = this.next;
            this.next = null;
            return this.current;
        }
        throw new NoSuchElementException("Iteration has no more elements.");
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException("Iteration has no current element.");
        }
        this.iterator.remove();
    }

    public static interface Filter<E> {
        public boolean accept(E var1);
    }
}

