/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.Validate;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class BufferedImageIcon
implements Icon {
    private final BufferedImage image;
    private int width;
    private int height;
    private final boolean fast;

    public BufferedImageIcon(BufferedImage pImage) {
        this(pImage, pImage != null ? pImage.getWidth() : 0, pImage != null ? pImage.getHeight() : 0);
    }

    public BufferedImageIcon(BufferedImage pImage, int pWidth, int pHeight) {
        this(pImage, pWidth, pHeight, pImage.getWidth() == pWidth && pImage.getHeight() == pHeight);
    }

    public BufferedImageIcon(BufferedImage pImage, int pWidth, int pHeight, boolean useFastRendering) {
        this.image = Validate.notNull(pImage, "image");
        this.width = Validate.isTrue(pWidth > 0, pWidth, "width must be positive: %d");
        this.height = Validate.isTrue(pHeight > 0, pHeight, "height must be positive: %d");
        this.fast = useFastRendering;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.fast || !(g instanceof Graphics2D)) {
            g.drawImage(this.image, x, y, this.width, this.height, null);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
            xform.scale((double)this.width / (double)this.image.getWidth(), (double)this.height / (double)this.image.getHeight());
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(this.image, xform, null);
        }
    }
}

