/*
 * Copyright (C) Jerry Huxtable 1998
 */
package com.alkacon.simapi.filter;

import java.awt.*;
import java.awt.image.*;

public class RescaleFilter extends TransferFilter {

	static final long serialVersionUID = -2724874183243154495L;
	
	private float scale = 1.0f;
	
	protected int transferFunction(int v) {
		return PixelUtils.clamp((int)(v * scale));
	}

	public void setScale(float scale) {
		this.scale = scale;
		initialized = false;
	}
	
	public float getScale() {
		return scale;
	}

	public String toString() {
		return "Colors/Rescale...";
	}

}

