/*
 * Copyright (C) Jerry Huxtable 1998
 */
package com.alkacon.simapi.filter;

import java.awt.*;
import java.awt.image.*;

public abstract class TransferFilter extends RGBImageFilter implements java.io.Serializable {

	protected int[] rTable, gTable, bTable;
	protected boolean initialized = false;
	
	public TransferFilter() {
		canFilterIndexColorModel = true;
	}

	public int filterRGB(int x, int y, int rgb) {
		if (!initialized) {
			initialize();
			initialized = true;
		}
		int a = rgb & 0xff000000;
		int r = (rgb >> 16) & 0xff;
		int g = (rgb >> 8) & 0xff;
		int b = rgb & 0xff;
		r = rTable[r];
		g = gTable[g];
		b = bTable[b];
		return a | (r << 16) | (g << 8) | b;
	}

	public void setDimensions(int width, int height) {
		initialized = false;
		super.setDimensions(width, height);
	}

	protected void initialize() {
		rTable = gTable = bTable = makeTable();
	}

	protected int[] makeTable() {
		int[] table = new int[256];
		for (int i = 0; i < 256; i++)
			table[i] = transferFunction(i);
		return table;
	}

	protected int transferFunction(int v) {
		return 0;
	}

}

