/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter.buffered;

import com.alkacon.simapi.filter.buffered.ConvolveFilter;
import java.awt.image.BufferedImage;
import java.awt.image.Kernel;

public class GaussianFilter
extends ConvolveFilter {
    static final long serialVersionUID = 5377089073023183684L;
    protected float radius;
    protected Kernel[] kernels;

    public GaussianFilter() {
        this(2.0f);
    }

    public GaussianFilter(float radius) {
        this.setRadius(radius);
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.kernels = GaussianFilter.separatedKernels(radius);
    }

    public float getRadius() {
        return this.radius;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        src.getRGB(0, 0, width, height, inPixels, 0, width);
        GaussianFilter.convolveH(this.kernels[0], inPixels, outPixels, width, height, this.alpha, CLAMP_EDGES);
        GaussianFilter.convolveV(this.kernels[1], outPixels, inPixels, width, height, this.alpha, CLAMP_EDGES);
        dst.setRGB(0, 0, width, height, inPixels, 0, width);
        return dst;
    }

    public static Kernel makeKernel(float radius) {
        int rows;
        int r = (int)Math.ceil(radius);
        int cols = rows = r * 2 + 1;
        float[] matrix = new float[rows * cols];
        float sigma = radius / 3.0f;
        float sigma22 = 2.0f * sigma * sigma;
        float sigmaPi2 = (float)Math.PI * 2 * sigma;
        float radius2 = radius * radius;
        float total = 0.0f;
        int index = 0;
        for (int row = -r; row <= r; ++row) {
            for (int col = -r; col <= r; ++col) {
                float distance = row * row + col * col;
                matrix[index] = distance > radius2 ? 0.0f : (float)Math.exp(-distance / sigma22) / sigmaPi2;
                total += matrix[index];
                ++index;
            }
        }
        int i = 0;
        while (i < rows * cols) {
            int n = i++;
            matrix[n] = matrix[n] / total;
        }
        Kernel kernel = new Kernel(cols, rows, matrix);
        return kernel;
    }

    public static Kernel[] separatedKernels(float radius) {
        int r = (int)Math.ceil(radius);
        int rows = r * 2 + 1;
        float[] matrix = new float[rows];
        float sigma = radius / 3.0f;
        float sigma22 = 2.0f * sigma * sigma;
        float sigmaPi2 = (float)Math.PI * 2 * sigma;
        float sqrtSigmaPi2 = (float)Math.sqrt(sigmaPi2);
        float radius2 = radius * radius;
        float total = 0.0f;
        int index = 0;
        for (int row = -r; row <= r; ++row) {
            float distance = row * row;
            matrix[index] = distance > radius2 ? 0.0f : (float)Math.exp(-distance / sigma22) / sqrtSigmaPi2;
            total += matrix[index];
            ++index;
        }
        int i = 0;
        while (i < rows) {
            int n = i++;
            matrix[n] = matrix[n] / total;
        }
        return new Kernel[]{new Kernel(rows, 1, matrix), new Kernel(1, rows, matrix)};
    }

    public String toString() {
        return "Blur/Gaussian Blur...";
    }
}

