/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.PixelUtils;
import com.alkacon.simapi.filter.WholeImageFilter;

public class MotionBlurFilter
extends WholeImageFilter {
    public static final int LINEAR = 0;
    public static final int RADIAL = 1;
    public static final int ZOOM = 2;
    private float angle = 0.0f;
    private float falloff = 1.0f;
    private float distance = 1.0f;
    private int repetitions = 4;
    private int type = 0;

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setRepetitions(int repetitions) {
        this.repetitions = repetitions;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int width = this.originalSpace.width;
        int height = this.originalSpace.height;
        int index = 0;
        int[] outPixels = new int[width * height];
        float sinAngle = (float)Math.sin(this.angle);
        float cosAngle = (float)Math.cos(this.angle);
        int cx = width / 2;
        int cy = height / 2;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int a = 0;
                int r = 0;
                int g = 0;
                int b = 0;
                int count = 0;
                for (int i = 0; i < this.repetitions; ++i) {
                    int newX = x;
                    int newY = y;
                    if (i != 0) {
                        switch (this.type) {
                            default: {
                                newX = (int)((float)x + (float)i * this.distance * sinAngle);
                                newY = (int)((float)y + (float)i * this.distance * cosAngle);
                                break;
                            }
                            case 1: {
                                float dx = x - cx;
                                float dy = y - cy;
                                float d = (float)Math.sqrt(dx * dx + dy * dy);
                                float an = (float)Math.atan2(dy, dx);
                                an = (float)((double)an + (double)(this.distance * (float)(i - this.repetitions / 2) / (float)Math.PI) / 10.0);
                                newX = (int)((double)cx + (double)d * Math.cos(an));
                                newY = (int)((double)cy + (double)d * Math.sin(an));
                                break;
                            }
                            case 2: {
                                float dx = x - cx;
                                float dy = y - cy;
                                newX = (int)((double)cx + (1.0 - (double)((float)i * this.distance) / 100.0) * (double)dx);
                                newY = (int)((double)cy + (1.0 - (double)((float)i * this.distance) / 100.0) * (double)dy);
                            }
                        }
                        if (newX < 0 || newX >= width || newY < 0 || newY >= height) break;
                    }
                    ++count;
                    int rgb = this.inPixels[newY * width + newX];
                    a += rgb >> 24 & 0xFF;
                    r += rgb >> 16 & 0xFF;
                    g += rgb >> 8 & 0xFF;
                    b += rgb & 0xFF;
                }
                if (count == 0) {
                    outPixels[index] = this.inPixels[index];
                } else {
                    a = PixelUtils.clamp(a / count);
                    r = PixelUtils.clamp(r / count);
                    g = PixelUtils.clamp(g / count);
                    b = PixelUtils.clamp(b / count);
                    outPixels[index] = a << 24 | r << 16 | g << 8 | b;
                }
                ++index;
            }
        }
        this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, outPixels, 0, width);
        this.consumer.imageComplete(status);
        this.inPixels = null;
    }

    public String toString() {
        return "Blur/Motion Blur...";
    }
}

