/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.ImageMath;
import com.alkacon.simapi.filter.WholeImageFilter;
import com.alkacon.simapi.filter.math.Function2D;
import com.alkacon.simapi.filter.math.ImageFunction2D;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.Serializable;
import java.util.Vector;

public class LightFilter
extends WholeImageFilter
implements Serializable {
    public static final int COLORS_FROM_IMAGE = 0;
    public static final int COLORS_CONSTANT = 1;
    public static final int COLORS_FROM_ENVIRONMENT = 2;
    public static final int BUMPS_FROM_IMAGE = 0;
    public static final int BUMPS_FROM_MAP = 1;
    public static final int BUMPS_FROM_BEVEL = 2;
    private float bumpHeight;
    private float viewDistance = 10000.0f;
    Material material;
    private Vector lights;
    int diffuseColor;
    int specularColor;
    private int colorSource = 0;
    private int bumpSource = 0;
    private Function2D bumpFunction;
    private Image environmentMap;
    private int[] envPixels;
    private int envWidth = 1;
    private int envHeight = 1;
    private Vector3D l;
    private Vector3D v;
    private Vector3D n;
    private ARGB shadedColor;
    private ARGB diffuse_color;
    private ARGB specular_color;
    private Vector3D tmpv;
    private Vector3D tmpv2;
    public NormalEvaluator normalEvaluator = new NormalEvaluator();
    private int[] rgb = new int[4];
    public static final int AMBIENT = 0;
    public static final int DISTANT = 1;
    public static final int POINT = 2;
    public static final int SPOT = 3;

    public LightFilter() {
        this.lights = new Vector();
        this.addLight(new DistantLight());
        this.bumpHeight = 1.0f;
        this.material = new Material();
        this.diffuseColor = -1;
        this.specularColor = -1;
        this.l = new Vector3D();
        this.v = new Vector3D();
        this.n = new Vector3D();
        this.shadedColor = new ARGB();
        this.diffuse_color = new ARGB();
        this.specular_color = new ARGB();
        this.tmpv = new Vector3D();
        this.tmpv2 = new Vector3D();
    }

    public void setBumpFunction(Function2D bumpFunction) {
        this.bumpFunction = bumpFunction;
    }

    public Function2D getBumpFunction() {
        return this.bumpFunction;
    }

    public void setBumpHeight(float bumpHeight) {
        this.bumpHeight = bumpHeight;
    }

    public float getBumpHeight() {
        return this.bumpHeight;
    }

    public void setViewDistance(float viewDistance) {
        this.viewDistance = viewDistance;
    }

    public float getViewDistance() {
        return this.viewDistance;
    }

    public void setDiffuseColor(int diffuseColor) {
        this.diffuseColor = diffuseColor;
    }

    public int getDiffuseColor() {
        return this.diffuseColor;
    }

    public void setEnvironmentMap(Image environmentMap) {
        this.environmentMap = environmentMap;
        if (environmentMap != null) {
            PixelGrabber pg = new PixelGrabber(environmentMap, 0, 0, -1, -1, null, 0, -1);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("interrupted waiting for pixels!");
            }
            if ((pg.status() & 0x80) != 0) {
                throw new RuntimeException("image fetch aborted");
            }
            this.envPixels = (int[])pg.getPixels();
            this.envWidth = pg.getWidth();
            this.envHeight = pg.getHeight();
        } else {
            this.envHeight = 1;
            this.envWidth = 1;
            this.envPixels = null;
        }
    }

    public Image getEnvironmentMap() {
        return this.environmentMap;
    }

    public void setColorSource(int colorSource) {
        this.colorSource = colorSource;
    }

    public int getColorSource() {
        return this.colorSource;
    }

    public void setBumpSource(int bumpSource) {
        this.bumpSource = bumpSource;
    }

    public int getBumpSource() {
        return this.bumpSource;
    }

    public void addLight(Light light) {
        this.lights.addElement(light);
    }

    public void removeLight(Light light) {
        this.lights.removeElement(light);
    }

    public Vector getLights() {
        return this.lights;
    }

    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int width = this.transformedSpace.width;
        int height = this.transformedSpace.height;
        int index = 0;
        int[] outPixels = new int[width * height];
        float width45 = Math.abs(6.0f * this.bumpHeight);
        boolean invertBumps = this.bumpHeight < 0.0f;
        float Nz = 1530.0f / width45;
        Vector3D position = new Vector3D(0.0f, 0.0f, 0.0f);
        Vector3D viewpoint = new Vector3D((float)width / 2.0f, (float)height / 2.0f, this.viewDistance);
        Vector3D normal = new Vector3D(0.0f, 0.0f, Nz);
        ARGB diffuseColor = new ARGB(this.diffuseColor);
        ARGB specularColor = new ARGB(this.specularColor);
        Function2D bump = this.bumpFunction;
        if (this.bumpSource == 0 || bump == null) {
            bump = new ImageFunction2D(this.inPixels, width, height, 1);
        }
        Vector3D v1 = new Vector3D();
        Vector3D v2 = new Vector3D();
        Vector3D n = new Vector3D();
        Object[] lightsArray = new Light[this.lights.size()];
        this.lights.copyInto(lightsArray);
        for (int i = 0; i < lightsArray.length; ++i) {
            ((Light)lightsArray[i]).prepare(width, height);
        }
        for (int y = 0; y < height; ++y) {
            float ny = y;
            position.y = y;
            for (int x = 0; x < width; ++x) {
                float nx = x;
                if (this.bumpSource != 2) {
                    float m4;
                    int count = 0;
                    normal.z = 0.0f;
                    normal.y = 0.0f;
                    normal.x = 0.0f;
                    float m0 = width45 * bump.evaluate(nx, ny);
                    float m1 = x > 0 ? width45 * bump.evaluate(nx - 1.0f, ny) - m0 : -2.0f;
                    float m2 = y > 0 ? width45 * bump.evaluate(nx, ny - 1.0f) - m0 : -2.0f;
                    float m3 = x < width - 1 ? width45 * bump.evaluate(nx + 1.0f, ny) - m0 : -2.0f;
                    float f = m4 = y < height - 1 ? width45 * bump.evaluate(nx, ny + 1.0f) - m0 : -2.0f;
                    if (m1 != -2.0f && m4 != -2.0f) {
                        v1.x = -1.0f;
                        v1.y = 0.0f;
                        v1.z = m1;
                        v2.x = 0.0f;
                        v2.y = 1.0f;
                        v2.z = m4;
                        v1.crossProduct(v2, n);
                        n.normalize();
                        if ((double)n.z < 0.0) {
                            n.z = -n.z;
                        }
                        normal.add(n);
                        ++count;
                    }
                    if (m1 != -2.0f && m2 != -2.0f) {
                        v1.x = -1.0f;
                        v1.y = 0.0f;
                        v1.z = m1;
                        v2.x = 0.0f;
                        v2.y = -1.0f;
                        v2.z = m2;
                        v1.crossProduct(v2, n);
                        n.normalize();
                        if ((double)n.z < 0.0) {
                            n.z = -n.z;
                        }
                        normal.add(n);
                        ++count;
                    }
                    if (m2 != -2.0f && m3 != -2.0f) {
                        v1.x = 0.0f;
                        v1.y = -1.0f;
                        v1.z = m2;
                        v2.x = 1.0f;
                        v2.y = 0.0f;
                        v2.z = m3;
                        v1.crossProduct(v2, n);
                        n.normalize();
                        if ((double)n.z < 0.0) {
                            n.z = -n.z;
                        }
                        normal.add(n);
                        ++count;
                    }
                    if (m3 != -2.0f && m4 != -2.0f) {
                        v1.x = 1.0f;
                        v1.y = 0.0f;
                        v1.z = m3;
                        v2.x = 0.0f;
                        v2.y = 1.0f;
                        v2.z = m4;
                        v1.crossProduct(v2, n);
                        n.normalize();
                        if ((double)n.z < 0.0) {
                            n.z = -n.z;
                        }
                        normal.add(n);
                        ++count;
                    }
                    normal.x /= (float)count;
                    normal.y /= (float)count;
                    normal.z /= (float)count;
                } else if (this.normalEvaluator != null) {
                    this.normalEvaluator.getNormalAt(x, y, width, height, normal);
                }
                if (invertBumps) {
                    normal.x = -normal.x;
                    normal.y = -normal.y;
                }
                position.x = x;
                if (normal.z >= 0.0f) {
                    if (this.colorSource == 0) {
                        diffuseColor.setColor(this.inPixels[index]);
                    } else if (this.colorSource == 2 && this.environmentMap != null) {
                        this.tmpv2.set(viewpoint);
                        this.tmpv2.z = 100.0f;
                        this.tmpv2.subtract(position);
                        this.tmpv2.normalize();
                        this.tmpv.set(normal);
                        this.tmpv.normalize();
                        this.tmpv.reflect(this.tmpv2);
                        this.tmpv.normalize();
                        diffuseColor.setColor(this.getEnvironmentMap(this.tmpv, this.inPixels, width, height));
                    }
                    ARGB c = this.phongShade(position, viewpoint, normal, diffuseColor, specularColor, this.material, (Light[])lightsArray);
                    int alpha = this.inPixels[index] & 0xFF000000;
                    int rgb = c.argbValue() & 0xFFFFFF;
                    outPixels[index++] = alpha | rgb;
                    continue;
                }
                outPixels[index++] = 0;
            }
        }
        this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, outPixels, 0, width);
        this.consumer.imageComplete(status);
        this.inPixels = null;
    }

    public ARGB phongShade(Vector3D position, Vector3D viewpoint, Vector3D normal, ARGB diffuseColor, ARGB specularColor, Material material, Light[] lightsArray) {
        this.shadedColor.setColor(diffuseColor);
        this.shadedColor.multiply(material.ambientIntensity);
        for (int i = 0; i < lightsArray.length; ++i) {
            Light light = lightsArray[i];
            this.n.set(normal);
            this.n.normalize();
            this.l.set(light.position);
            if (light.type != 1) {
                this.l.subtract(position);
            }
            this.l.normalize();
            float nDotL = this.n.innerProduct(this.l);
            if (!((double)nDotL >= 0.0)) continue;
            float dDotL = 0.0f;
            this.v.set(viewpoint);
            this.v.subtract(position);
            this.v.normalize();
            if (light.type == 3 && (dDotL = light.direction.innerProduct(this.l)) < light.cosConeAngle) continue;
            this.n.multiply(2.0f * nDotL);
            this.n.subtract(this.l);
            float rDotV = this.n.innerProduct(this.v);
            float rv = (double)rDotV < 0.0 ? 0.0f : (float)Math.pow(rDotV, material.highlight);
            if (light.type == 3) {
                float e = dDotL = light.cosConeAngle / dDotL;
                e *= e;
                e *= e;
                e *= e;
                e = (float)Math.pow(dDotL, light.focus * 10.0f) * (1.0f - e);
                rv *= e;
                nDotL *= e;
            }
            this.diffuse_color.setColor(diffuseColor);
            this.diffuse_color.multiply(material.diffuseReflectivity);
            this.diffuse_color.multiply(light.realColor);
            this.diffuse_color.multiply(nDotL);
            this.specular_color.setColor(specularColor);
            this.specular_color.multiply(material.specularReflectivity);
            this.specular_color.multiply(light.realColor);
            this.specular_color.multiply(rv);
            this.diffuse_color.add(this.specular_color);
            this.diffuse_color.clamp();
            this.shadedColor.add(this.diffuse_color);
        }
        this.shadedColor.clamp();
        return this.shadedColor;
    }

    private int getEnvironmentMap(Vector3D normal, int[] inPixels, int width, int height) {
        if (this.environmentMap != null) {
            float x;
            float angle = (float)Math.acos(-normal.y);
            float y = angle / (float)Math.PI;
            if (y == 0.0f || y == 1.0f) {
                x = 0.0f;
            } else {
                float f = normal.x / (float)Math.sin(angle);
                if (f > 1.0f) {
                    f = 1.0f;
                } else if (f < -1.0f) {
                    f = -1.0f;
                }
                x = (float)Math.acos(f) / (float)Math.PI;
            }
            x = (x - 0.5f) * 1.2f + 0.5f;
            y = (y - 0.5f) * 1.2f + 0.5f;
            x = ImageMath.clamp(x * (float)this.envWidth, 0.0f, (float)(this.envWidth - 1));
            y = ImageMath.clamp(y * (float)this.envHeight, 0.0f, (float)(this.envHeight - 1));
            int ix = (int)x;
            int iy = (int)y;
            float xWeight = x - (float)ix;
            float yWeight = y - (float)iy;
            int i = this.envWidth * iy + ix;
            int dx = ix == this.envWidth - 1 ? 0 : 1;
            int dy = iy == this.envHeight - 1 ? 0 : this.envWidth;
            this.rgb[0] = this.envPixels[i];
            this.rgb[1] = this.envPixels[i + dx];
            this.rgb[2] = this.envPixels[i + dy];
            this.rgb[3] = this.envPixels[i + dx + dy];
            return ImageMath.bilinearInterpolate(xWeight, yWeight, this.rgb);
        }
        return 0;
    }

    public String toString() {
        return "Stylize/Light Effects...";
    }

    public class SpotLight
    extends Light {
        public SpotLight() {
            this.type = 3;
        }

        public String toString() {
            return "Spotlight";
        }
    }

    public class DistantLight
    extends Light {
        public DistantLight() {
            this.type = 1;
        }

        public String toString() {
            return "Distant Light";
        }
    }

    public class PointLight
    extends Light {
        public PointLight() {
            this.type = 2;
        }

        public String toString() {
            return "Point Light";
        }
    }

    public class AmbientLight
    extends Light {
        public String toString() {
            return "Ambient Light";
        }
    }

    public static class Light
    implements Cloneable {
        int type = 0;
        Vector3D position;
        Vector3D direction;
        ARGB realColor;
        int color = -1;
        float intensity;
        float azimuth;
        float elevation;
        float focus = 0.5f;
        float centreX = 0.5f;
        float centreY = 0.5f;
        float coneAngle = 0.5235988f;
        float cosConeAngle;
        float distance = 100.0f;

        public Light() {
            this(2.3561945f, 0.5235988f, 1.0f);
        }

        public Light(float azimuth, float elevation, float intensity) {
            this.azimuth = azimuth;
            this.elevation = elevation;
            this.intensity = intensity;
        }

        public void setAzimuth(float azimuth) {
            this.azimuth = azimuth;
        }

        public float getAzimuth() {
            return this.azimuth;
        }

        public void setElevation(float elevation) {
            this.elevation = elevation;
        }

        public float getElevation() {
            return this.elevation;
        }

        public void setDistance(float distance) {
            this.distance = distance;
        }

        public float getDistance() {
            return this.distance;
        }

        public void setIntensity(float intensity) {
            this.intensity = intensity;
        }

        public float getIntensity() {
            return this.intensity;
        }

        public void setConeAngle(float coneAngle) {
            this.coneAngle = coneAngle;
        }

        public float getConeAngle() {
            return this.coneAngle;
        }

        public void setFocus(float focus) {
            this.focus = focus;
        }

        public float getFocus() {
            return this.focus;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }

        public void setCentreX(float x) {
            this.centreX = x;
        }

        public float getCentreX() {
            return this.centreX;
        }

        public void setCentreY(float y) {
            this.centreY = y;
        }

        public float getCentreY() {
            return this.centreY;
        }

        public void prepare(int width, int height) {
            float lx = (float)(Math.cos(this.azimuth) * Math.cos(this.elevation));
            float ly = (float)(Math.sin(this.azimuth) * Math.cos(this.elevation));
            float lz = (float)Math.sin(this.elevation);
            this.direction = new Vector3D(lx, ly, lz);
            this.direction.normalize();
            if (this.type != 1) {
                lx *= this.distance;
                ly *= this.distance;
                lz *= this.distance;
                lx += (float)width * this.centreX;
                ly += (float)height * (1.0f - this.centreY);
            }
            this.position = new Vector3D(lx, ly, lz);
            this.realColor = new ARGB(this.color);
            this.realColor.multiply(this.intensity);
            this.cosConeAngle = (float)Math.cos(this.coneAngle);
        }

        public Object clone() {
            try {
                Light copy = (Light)super.clone();
                return copy;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public String toString() {
            return "Light";
        }
    }

    public static class Material {
        float ambientIntensity = 0.5f;
        float diffuseReflectivity = 0.8f;
        float specularReflectivity = 0.9f;
        float highlight = 3.0f;
        float reflectivity = 0.0f;
    }

    static class Vector3D {
        public float x;
        public float y;
        public float z;

        public Vector3D() {
        }

        public Vector3D(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vector3D(Vector3D v) {
            this.x = v.x;
            this.y = v.y;
            this.z = v.z;
        }

        public void set(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void set(Vector3D v) {
            this.x = v.x;
            this.y = v.y;
            this.z = v.z;
        }

        public float length() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        public void normalize() {
            float l = this.length();
            if (l != 0.0f) {
                this.multiply(1.0f / l);
            }
        }

        public void multiply(float f) {
            this.x *= f;
            this.y *= f;
            this.z *= f;
        }

        public void add(Vector3D v) {
            this.x += v.x;
            this.y += v.y;
            this.z += v.z;
        }

        public void subtract(Vector3D v) {
            this.x -= v.x;
            this.y -= v.y;
            this.z -= v.z;
        }

        public void multiply(Vector3D v) {
            this.x *= v.x;
            this.y *= v.y;
            this.z *= v.z;
        }

        public float innerProduct(Vector3D v) {
            return this.x * v.x + this.y * v.y + this.z * v.z;
        }

        public void crossProduct(Vector3D v, Vector3D result) {
            result.x = this.y * v.z - this.z * v.y;
            result.y = this.z * v.x - this.x * v.z;
            result.z = this.x * v.y - this.y * v.x;
        }

        public void reflect(Vector3D v) {
            float n = 2.0f * this.innerProduct(v);
            this.multiply(n);
            this.subtract(v);
        }

        public String toString() {
            return "(" + this.x + " " + this.y + " " + this.z + ")";
        }
    }

    static class ARGB {
        public float a;
        public float r;
        public float g;
        public float b;

        public ARGB() {
            this(0, 0, 0, 0);
        }

        public ARGB(int a, int r, int g, int b) {
            this.a = (float)a / 255.0f;
            this.r = (float)r / 255.0f;
            this.g = (float)g / 255.0f;
            this.b = (float)b / 255.0f;
        }

        public ARGB(float a, float r, float g, float b) {
            this.a = a;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public ARGB(ARGB v) {
            this.a = v.a;
            this.r = v.r;
            this.g = v.g;
            this.b = v.b;
        }

        public ARGB(int v) {
            this(v >> 24 & 0xFF, v >> 16 & 0xFF, v >> 8 & 0xFF, v & 0xFF);
        }

        public ARGB(Color c) {
            this(c.getRGB());
        }

        public void setColor(int a, int r, int g, int b) {
            this.a = (float)a / 255.0f;
            this.r = (float)r / 255.0f;
            this.g = (float)g / 255.0f;
            this.b = (float)b / 255.0f;
        }

        public void setColor(float a, float r, float g, float b) {
            this.a = a;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public void setColor(ARGB v) {
            this.a = v.a;
            this.r = v.r;
            this.g = v.g;
            this.b = v.b;
        }

        public void setColor(int v) {
            this.setColor(v >> 24 & 0xFF, v >> 16 & 0xFF, v >> 8 & 0xFF, v & 0xFF);
        }

        public int argbValue() {
            this.a = 1.0f;
            int ia = (int)(255.0 * (double)this.a);
            int ir = (int)(255.0 * (double)this.r);
            int ig = (int)(255.0 * (double)this.g);
            int ib = (int)(255.0 * (double)this.b);
            return ia << 24 | ir << 16 | ig << 8 | ib;
        }

        public float length() {
            return (float)Math.sqrt(this.r * this.r + this.g * this.g + this.b * this.b);
        }

        public void normalize() {
            float l = this.length();
            if ((double)l != 0.0) {
                this.multiply(1.0f / l);
            }
        }

        public void clamp() {
            if (this.a < 0.0f) {
                this.a = 0.0f;
            } else if (this.a > 1.0f) {
                this.a = 1.0f;
            }
            if (this.r < 0.0f) {
                this.r = 0.0f;
            } else if (this.r > 1.0f) {
                this.r = 1.0f;
            }
            if ((double)this.g < 0.0) {
                this.g = 0.0f;
            } else if ((double)this.g > 1.0) {
                this.g = 1.0f;
            }
            if (this.b < 0.0f) {
                this.b = 0.0f;
            } else if (this.b > 1.0f) {
                this.b = 1.0f;
            }
        }

        public void multiply(float f) {
            this.r *= f;
            this.g *= f;
            this.b *= f;
        }

        public void add(ARGB v) {
            this.r += v.r;
            this.g += v.g;
            this.b += v.b;
        }

        public void subtract(ARGB v) {
            this.r -= v.r;
            this.g -= v.g;
            this.b -= v.b;
        }

        public void multiply(ARGB v) {
            this.r *= v.r;
            this.g *= v.g;
            this.b *= v.b;
        }

        public String toString() {
            return this.a + " " + this.r + " " + this.g + " " + this.b + ")";
        }
    }

    public class NormalEvaluator {
        public static final int RECTANGLE = 0;
        public static final int ROUNDRECT = 1;
        public static final int ELLIPSE = 2;
        public static final int LINEAR = 0;
        public static final int SIN = 1;
        public static final int CIRCLE_UP = 2;
        public static final int CIRCLE_DOWN = 3;
        public static final int SMOOTH = 4;
        public static final int PULSE = 5;
        public static final int SMOOTH_PULSE = 6;
        public static final int THING = 7;
        private int margin = 10;
        private int shape = 0;
        private int bevel = 0;
        private int cornerRadius = 15;

        public void setMargin(int margin) {
            this.margin = margin;
        }

        public int getMargin() {
            return this.margin;
        }

        public void setCornerRadius(int cornerRadius) {
            this.cornerRadius = cornerRadius;
        }

        public int getCornerRadius() {
            return this.cornerRadius;
        }

        public void setShape(int shape) {
            this.shape = shape;
        }

        public int getShape() {
            return this.shape;
        }

        public void setBevel(int bevel) {
            this.bevel = bevel;
        }

        public int getBevel() {
            return this.bevel;
        }

        public void getNormalAt(int x, int y, int width, int height, Vector3D normal) {
            float distance = 0.0f;
            normal.y = 0.0f;
            normal.x = 0.0f;
            normal.z = 0.707f;
            switch (this.shape) {
                case 0: {
                    if (x < this.margin) {
                        if (x < y && x < height - y) {
                            normal.x = -1.0f;
                        }
                    } else if (width - x <= this.margin && width - x - 1 < y && width - x <= height - y) {
                        normal.x = 1.0f;
                    }
                    if (normal.x == 0.0f) {
                        if (y < this.margin) {
                            normal.y = -1.0f;
                        } else if (height - y <= this.margin) {
                            normal.y = 1.0f;
                        }
                    }
                    distance = Math.min(Math.min(x, y), Math.min(width - x - 1, height - y - 1));
                    break;
                }
                case 2: {
                    float a = width / 2;
                    float b = height / 2;
                    float a2 = a * a;
                    float b2 = b * b;
                    float dx = (float)x - a;
                    float dy = (float)y - b;
                    float x2 = dx * dx;
                    float y2 = dy * dy;
                    distance = b2 - b2 * x2 / a2 - y2;
                    float radius = (float)Math.sqrt(x2 + y2);
                    distance = 0.5f * distance / ((a + b) / 2.0f);
                    if (radius == 0.0f) break;
                    normal.x = dx / radius;
                    normal.y = dy / radius;
                    break;
                }
                case 1: {
                    distance = Math.min(Math.min(x, y), Math.min(width - x - 1, height - y - 1));
                    float c = Math.min(this.cornerRadius, Math.min(width / 2, height / 2));
                    if (((float)x < c || (float)(width - x) <= c) && ((float)y < c || (float)(height - y) <= c)) {
                        if ((float)(width - x) <= c) {
                            x = (int)((float)x - ((float)width - c - c - 1.0f));
                        }
                        if ((float)(height - y) <= c) {
                            y = (int)((float)y - ((float)height - c - c - 1.0f));
                        }
                        float dx = (float)x - c;
                        float dy = (float)y - c;
                        float x2 = dx * dx;
                        float y2 = dy * dy;
                        float radius = (float)Math.sqrt(x2 + y2);
                        distance = c - radius;
                        normal.x = dx / radius;
                        normal.y = dy / radius;
                        break;
                    }
                    if (x < this.margin) {
                        normal.x = -1.0f;
                        break;
                    }
                    if (width - x <= this.margin) {
                        normal.x = 1.0f;
                        break;
                    }
                    if (y < this.margin) {
                        normal.y = -1.0f;
                        break;
                    }
                    if (height - y > this.margin) break;
                    normal.y = 1.0f;
                }
            }
            distance /= (float)this.margin;
            if (distance < 0.0f) {
                normal.z = -1.0f;
                normal.normalize();
                return;
            }
            float dx = 1.0f / (float)this.margin;
            float z1 = this.bevelFunction(distance);
            float z2 = this.bevelFunction(distance + dx);
            float dz = z2 - z1;
            normal.z = dx;
            normal.x *= dz;
            normal.y *= dz;
            normal.normalize();
        }

        private float bevelFunction(float x) {
            x = ImageMath.clamp(x, 0.0f, 1.0f);
            switch (this.bevel) {
                case 0: {
                    return ImageMath.clamp(x, 0.0f, 1.0f);
                }
                case 1: {
                    return (float)Math.sin((double)x * Math.PI / 2.0);
                }
                case 2: {
                    return ImageMath.circleUp(x);
                }
                case 3: {
                    return ImageMath.circleDown(x);
                }
                case 4: {
                    return ImageMath.smoothStep(0.1f, 0.9f, x);
                }
                case 5: {
                    return ImageMath.pulse(0.0f, 1.0f, x);
                }
                case 6: {
                    return ImageMath.smoothPulse(0.0f, 0.1f, 0.5f, 1.0f, x);
                }
                case 7: {
                    return (float)((double)x < 0.2 ? Math.sin((double)x / 0.2 * Math.PI / 2.0) : 0.5 + 0.5 * Math.sin(1.0 + (double)x / 0.6 * Math.PI / 2.0));
                }
            }
            return x;
        }
    }
}

