/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.Colormap;
import com.alkacon.simapi.filter.Gradient;
import com.alkacon.simapi.filter.ImageMath;
import com.alkacon.simapi.filter.MutatableFilter;
import com.alkacon.simapi.filter.PixelUtils;
import com.alkacon.simapi.filter.math.CellularFunction2D;
import com.alkacon.simapi.filter.math.FBM;
import com.alkacon.simapi.filter.math.Function2D;
import com.alkacon.simapi.filter.math.Noise;
import com.alkacon.simapi.filter.math.RidgedFBM;
import com.alkacon.simapi.filter.math.SCNoise;
import com.alkacon.simapi.filter.math.VLNoise;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;
import java.util.Random;

public class FBMFilter
extends RGBImageFilter
implements MutatableFilter,
Cloneable,
Serializable {
    public static final int NOISE = 0;
    public static final int RIDGED = 1;
    public static final int VLNOISE = 2;
    public static final int SCNOISE = 3;
    public static final int CELLULAR = 4;
    private float scale = 32.0f;
    private float stretch = 1.0f;
    private float angle = 0.0f;
    private float amount = 1.0f;
    private float H = 1.0f;
    private float octaves = 4.0f;
    private float lacunarity = 2.5f;
    private float gain = 0.5f;
    private float bias = 0.5f;
    private int operation;
    private float m00 = 1.0f;
    private float m01 = 0.0f;
    private float m10 = 0.0f;
    private float m11 = 1.0f;
    private float min;
    private float max;
    private Colormap colormap = new Gradient();
    private boolean ridged;
    private FBM fBm;
    protected Random random = new Random();
    private int basisType = 0;
    private Function2D basis;

    public FBMFilter() {
        this.setBasisType(0);
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public void setStretch(float stretch) {
        this.stretch = stretch;
    }

    public float getStretch() {
        return this.stretch;
    }

    public void setAngle(float angle) {
        this.angle = angle;
        float cos = (float)Math.cos(this.angle);
        float sin = (float)Math.sin(this.angle);
        this.m00 = cos;
        this.m01 = sin;
        this.m10 = -sin;
        this.m11 = cos;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setOctaves(float octaves) {
        this.octaves = octaves;
        this.fBm = this.makeFBM(this.H, octaves, this.lacunarity);
    }

    public float getOctaves() {
        return this.octaves;
    }

    public void setH(float H) {
        this.H = H;
        this.fBm = this.makeFBM(H, this.octaves, this.lacunarity);
    }

    public float getH() {
        return this.H;
    }

    public void setLacunarity(float lacunarity) {
        this.lacunarity = lacunarity;
        this.fBm = this.makeFBM(this.H, this.octaves, lacunarity);
    }

    public float getLacunarity() {
        return this.lacunarity;
    }

    public void setGain(float gain) {
        this.gain = gain;
    }

    public float getGain() {
        return this.gain;
    }

    public void setBias(float bias) {
        this.bias = bias;
    }

    public float getBias() {
        return this.bias;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setDimensions(int width, int height) {
        super.setDimensions(width, height);
        this.fBm = this.makeFBM(this.H, this.octaves, this.lacunarity);
    }

    public void setBasisType(int basisType) {
        this.basisType = basisType;
        switch (basisType) {
            default: {
                this.basis = new Noise();
                break;
            }
            case 1: {
                this.basis = new RidgedFBM();
                break;
            }
            case 2: {
                this.basis = new VLNoise();
                break;
            }
            case 3: {
                this.basis = new SCNoise();
                break;
            }
            case 4: {
                this.basis = new CellularFunction2D();
            }
        }
    }

    public int getBasisType() {
        return this.basisType;
    }

    public void setBasis(Function2D basis) {
        this.basis = basis;
    }

    public Function2D getBasis() {
        return this.basis;
    }

    protected FBM makeFBM(float H, float lacunarity, float octaves) {
        FBM fbm = new FBM(H, lacunarity, octaves, this.basis);
        float[] minmax = Noise.findRange(fbm, null);
        this.min = minmax[0];
        this.max = minmax[1];
        return fbm;
    }

    public int filterRGB(int x, int y, int rgb) {
        int v;
        float nx = this.m00 * (float)x + this.m01 * (float)y;
        float ny = this.m10 * (float)x + this.m11 * (float)y;
        float f = this.fBm.evaluate(nx /= this.scale, ny /= this.scale * this.stretch);
        f = (f - this.min) / (this.max - this.min);
        f = ImageMath.gain(f, this.gain);
        f = ImageMath.bias(f, this.bias);
        f *= this.amount;
        int a = rgb & 0xFF000000;
        if (this.colormap != null) {
            v = this.colormap.getColor(f);
        } else {
            v = PixelUtils.clamp((int)(f * 255.0f));
            int r = v << 16;
            int g = v << 8;
            int b = v;
            v = a | r | g | b;
        }
        if (this.operation != 0) {
            v = PixelUtils.combinePixels(rgb, v, this.operation);
        }
        return v;
    }

    public void mutate(int amount, ImageFilter d, boolean keepShape, boolean keepColors) {
        FBMFilter dst = (FBMFilter)d;
        if (keepShape || amount == 0) {
            dst.setScale(this.getScale());
            dst.setAngle(this.getAngle());
            dst.setStretch(this.getStretch());
            dst.setAmount(this.getAmount());
            dst.setLacunarity(this.getLacunarity());
            dst.setOctaves(this.getOctaves());
            dst.setH(this.getH());
            dst.setGain(this.getGain());
            dst.setBias(this.getBias());
            dst.setColormap(this.getColormap());
        } else {
            dst.scale = this.mutate(this.scale, 0.6f, 4.0f, 3.0f, 64.0f);
            dst.setAngle(this.mutate(this.angle, 0.6f, 1.5707964f));
            dst.stretch = this.mutate(this.stretch, 0.6f, 5.0f, 1.0f, 10.0f);
            dst.amount = this.mutate(amount, 0.6f, 0.2f, 0.0f, 1.0f);
            dst.lacunarity = this.mutate(this.lacunarity, 0.5f, 0.5f, 0.0f, 3.0f);
            dst.octaves = this.mutate(this.octaves, 0.9f, 0.2f, 0.0f, 12.0f);
            dst.H = this.mutate(this.H, 0.7f, 0.2f, 0.0f, 1.0f);
            dst.gain = this.mutate(this.gain, 0.2f, 0.2f, 0.0f, 1.0f);
            dst.bias = this.mutate(this.bias, 0.2f, 0.2f, 0.0f, 1.0f);
        }
        if (keepColors || amount == 0) {
            dst.setColormap(this.getColormap());
        } else {
            dst.setColormap(Gradient.randomGradient());
        }
    }

    private float mutate(float n, float probability, float amount, float lower, float upper) {
        if (this.random.nextFloat() >= probability) {
            return n;
        }
        return ImageMath.clamp(n + amount * (float)this.random.nextGaussian(), lower, upper);
    }

    private float mutate(float n, float probability, float amount) {
        if (this.random.nextFloat() >= probability) {
            return n;
        }
        return n + amount * (float)this.random.nextGaussian();
    }

    public Object clone() {
        FBMFilter f = (FBMFilter)super.clone();
        f.fBm = this.makeFBM(f.H, f.octaves, f.lacunarity);
        return f;
    }

    public String toString() {
        return "Texture/Fractal Brownian Motion...";
    }
}

