/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.tunnel.pipeline;

import com.alicloud.openservices.tablestore.tunnel.pipeline.PipelineContext;
import com.alicloud.openservices.tablestore.tunnel.pipeline.Stage;
import com.alicloud.openservices.tablestore.tunnel.pipeline.StageException;

public abstract class AbstractStage<INPUT, OUTPUT>
implements Stage<INPUT, OUTPUT> {
    private volatile Stage<OUTPUT, ?> nextStage;
    private volatile PipelineContext context;

    @Override
    public void setNextStage(Stage<?, ?> stage) {
        this.nextStage = stage;
    }

    @Override
    public void init(PipelineContext context) {
        this.context = context;
    }

    public abstract OUTPUT doProcess(INPUT var1) throws StageException;

    @Override
    public void process(INPUT input) {
        try {
            OUTPUT output = this.doProcess(input);
            if (this.nextStage != null && output != null) {
                this.nextStage.process(output);
            }
        }
        catch (StageException se) {
            this.context.handleError(se);
        }
        catch (Exception e) {
            this.context.handleError(new StageException(this, input, "", e));
        }
    }

    @Override
    public void shutdown() {
    }
}

