/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model.query;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.model.filter.Filter;
import com.alicloud.openservices.tablestore.timestream.model.PointIterator;
import com.alicloud.openservices.tablestore.timestream.model.TimeRange;
import com.alicloud.openservices.tablestore.timestream.model.TimestreamIdentifier;
import com.alicloud.openservices.tablestore.timestream.model.query.DataQuery;
import java.util.concurrent.TimeUnit;

public class DataGetter
extends DataQuery {
    private TimestreamIdentifier identifier;

    public DataGetter(AsyncClient asyncClient, String tableName, TimestreamIdentifier identifier) {
        super(asyncClient, tableName);
        this.identifier = identifier;
    }

    public DataGetter filter(Filter filter) {
        this.setFilter(filter);
        return this;
    }

    public DataGetter select(String ... fields) {
        this.setColumnToGet(fields);
        return this;
    }

    public DataGetter timeRange(TimeRange timeRange) {
        this.setTimeRange(timeRange);
        return this;
    }

    public DataGetter timestamp(long timestamp, TimeUnit unit) {
        this.setTimestamp(timestamp, unit);
        return this;
    }

    public DataGetter descTimestamp() {
        this.setOrderByTimestampDesc();
        return this;
    }

    public DataGetter limit(int limit) {
        this.setLimit(limit);
        return this;
    }

    public PointIterator fetchAll() {
        return this.getTimestream();
    }

    private PointIterator getTimestream() {
        return this.getTimestream(this.identifier);
    }
}

