/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.search.SearchRequest;
import com.alicloud.openservices.tablestore.model.search.SearchResponse;
import com.alicloud.openservices.tablestore.timestream.model.TimestreamMeta;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestreamMetaIterator
implements Iterator<TimestreamMeta> {
    private static Logger logger = LoggerFactory.getLogger(TimestreamMetaIterator.class);
    private AsyncClient asyncClient;
    private SearchRequest request;
    private SearchResponse response;
    private Iterator<Row> rowIterator;

    public TimestreamMetaIterator(AsyncClient asyncClient, SearchRequest request) {
        this.asyncClient = asyncClient;
        this.request = request;
        this.fetchData(request);
    }

    private void fetchData(SearchRequest request) {
        try {
            this.response = this.asyncClient.search(request, null).get();
            logger.debug("fetchData response -> TraceId: " + this.response.getTraceId() + ", RequestId: " + this.response.getRequestId());
        }
        catch (InterruptedException e) {
            throw new ClientException(String.format("The thread was interrupted: %s", e.getMessage()));
        }
        catch (ExecutionException e) {
            throw new ClientException("The thread was aborted", e);
        }
        this.rowIterator = this.response.getRows().iterator();
    }

    private boolean isBufferHasData() {
        return this.rowIterator.hasNext();
    }

    @Override
    public boolean hasNext() {
        if (this.isBufferHasData()) {
            return true;
        }
        byte[] token = this.response.getNextToken();
        while (token != null) {
            this.request.getSearchQuery().setToken(this.response.getNextToken());
            this.request.getSearchQuery().setOffset(0);
            this.fetchData(this.request);
            if (this.isBufferHasData()) {
                return true;
            }
            token = this.response.getNextToken();
        }
        return false;
    }

    @Override
    public TimestreamMeta next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return TimestreamMeta.newInstance(this.rowIterator.next());
    }

    @Override
    public void remove() {
        throw new RuntimeException("TimestreamMetaIterator do not support remove().");
    }

    public long getTotalCount() {
        return this.response.getTotalCount();
    }

    protected SearchResponse getResponse() {
        return this.response;
    }
}

