/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeserieswriter.config;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.timeserieswriter.enums.TSDispatchMode;
import com.alicloud.openservices.tablestore.timeserieswriter.enums.TSWriteMode;
import com.alicloud.openservices.tablestore.writer.enums.WriterRetryStrategy;

public class TimeseriesWriterConfig {
    private int maxBatchRowsCount = 200;
    private int maxBatchSize = 0x400000;
    private int concurrency = 64;
    private int bufferSize = 1024;
    private int flushInterval = 10000;
    private int logInterval = 10000;
    private TSDispatchMode dispatchMode = TSDispatchMode.HASH_PRIMARY_KEY;
    private TSWriteMode writeMode = TSWriteMode.PARALLEL;
    private int bucketCount = 4;
    private int callbackThreadCount = Runtime.getRuntime().availableProcessors() + 1;
    private int callbackThreadPoolQueueSize = 1024;
    private WriterRetryStrategy writerRetryStrategy = WriterRetryStrategy.CERTAIN_ERROR_CODE_NOT_RETRY;
    private int clientMaxConnections = 300;
    private boolean allowDuplicatedRowInBatchRequest = true;

    public int getMaxBatchRowsCount() {
        return this.maxBatchRowsCount;
    }

    public void setMaxBatchRowsCount(int maxBatchRowsCount) {
        Preconditions.checkArgument(maxBatchRowsCount > 0, "The max BatchRowsCount should be greater than 0.");
        this.maxBatchRowsCount = maxBatchRowsCount;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        Preconditions.checkArgument(maxBatchSize > 0, "The max BatchSize should be greater than 0.");
        this.maxBatchSize = maxBatchSize;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        Preconditions.checkArgument(concurrency > 0, "The concurrency should be greater than 0.");
        this.concurrency = concurrency;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        Preconditions.checkArgument(bufferSize > 0, "The buffer size should be greater than 0.");
        this.bufferSize = bufferSize;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public void setFlushInterval(int flushInterval) {
        Preconditions.checkArgument(flushInterval > 0, "The flush interval should be greater than 0.");
        this.flushInterval = flushInterval;
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public void setBucketCount(int bucketCount) {
        Preconditions.checkArgument(bucketCount > 0, "The bulk count should be greater than 0.");
        this.bucketCount = bucketCount;
    }

    public TSDispatchMode getDispatchMode() {
        return this.dispatchMode;
    }

    public void setDispatchMode(TSDispatchMode dispatchMode) {
        Preconditions.checkArgument(dispatchMode != null, "The dispatch mode should be null");
        this.dispatchMode = dispatchMode;
    }

    public TSWriteMode getWriteMode() {
        return this.writeMode;
    }

    public void setWriteMode(TSWriteMode writeMode) {
        Preconditions.checkArgument(writeMode != null, "The write mode should be null");
        this.writeMode = writeMode;
    }

    public int getLogInterval() {
        return this.logInterval;
    }

    public void setLogInterval(int logInterval) {
        Preconditions.checkArgument(logInterval > 0, "The LogInterval should be greater than 0.");
        this.logInterval = logInterval;
    }

    public int getCallbackThreadCount() {
        return this.callbackThreadCount;
    }

    public void setCallbackThreadCount(int callbackThreadCount) {
        Preconditions.checkArgument(callbackThreadCount > 0, "The CallbackThreadCount should be greater than 0.");
        this.callbackThreadCount = callbackThreadCount;
    }

    public int getCallbackThreadPoolQueueSize() {
        return this.callbackThreadPoolQueueSize;
    }

    public void setCallbackThreadPoolQueueSize(int callbackThreadPoolQueueSize) {
        Preconditions.checkArgument(callbackThreadPoolQueueSize > 0, "The CallbackThreadPoolQueueSize should be greater than 0.");
        this.callbackThreadPoolQueueSize = callbackThreadPoolQueueSize;
    }

    public WriterRetryStrategy getWriterRetryStrategy() {
        return this.writerRetryStrategy;
    }

    public void setWriterRetryStrategy(WriterRetryStrategy writerRetryStrategy) {
        Preconditions.checkArgument(writerRetryStrategy != null, "The WriterRetryStrategy should not be null.");
        this.writerRetryStrategy = writerRetryStrategy;
    }

    public int getClientMaxConnections() {
        return this.clientMaxConnections;
    }

    public void setClientMaxConnections(int clientMaxConnections) {
        Preconditions.checkArgument(clientMaxConnections > 0, "The ClientMaxConnect should be greater than 0.");
        this.clientMaxConnections = clientMaxConnections;
    }

    public boolean isAllowDuplicatedRowInBatchRequest() {
        return this.allowDuplicatedRowInBatchRequest;
    }

    public void setAllowDuplicatedRowInBatchRequest(boolean allowDuplicatedRowInBatchRequest) {
        this.allowDuplicatedRowInBatchRequest = allowDuplicatedRowInBatchRequest;
    }
}

