/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.query;

import com.alicloud.openservices.tablestore.core.protocol.SearchQueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.QueryType;
import com.alicloud.openservices.tablestore.model.search.query.ScoreFunction;
import com.aliyun.ots.thirdparty.com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;

public class FunctionsScoreQuery
implements Query {
    private final QueryType queryType = QueryType.QueryType_FunctionsScoreQuery;
    private Query query;
    private List<ScoreFunction> functions;
    private ScoreMode scoreMode;
    private CombineMode combineMode;
    private Float minScore;
    private Float maxScore;

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public List<ScoreFunction> getFunctions() {
        return this.functions;
    }

    public void setFunctions(List<ScoreFunction> functions) {
        this.functions = functions;
    }

    public void addFunction(ScoreFunction function) {
        if (this.functions == null) {
            this.functions = new ArrayList<ScoreFunction>();
        }
        this.functions.add(function);
    }

    public ScoreMode getScoreMode() {
        return this.scoreMode;
    }

    public void setScoreMode(ScoreMode scoreMode) {
        this.scoreMode = scoreMode;
    }

    public CombineMode getCombineMode() {
        return this.combineMode;
    }

    public void setCombineMode(CombineMode combineMode) {
        this.combineMode = combineMode;
    }

    public Float getMinScore() {
        return this.minScore;
    }

    public void setMinScore(Float minScore) {
        this.minScore = minScore;
    }

    public Float getMaxScore() {
        return this.maxScore;
    }

    public void setMaxScore(Float maxScore) {
        this.maxScore = maxScore;
    }

    @Override
    public QueryType getQueryType() {
        return this.queryType;
    }

    @Override
    public ByteString serialize() {
        return SearchQueryBuilder.buildFunctionsScoreQuery(this).toByteString();
    }

    protected static Builder newBuilder() {
        return new Builder();
    }

    public static enum CombineMode {
        UNKNOWN,
        MULTIPLY,
        AVG,
        MAX,
        SUM,
        MIN,
        REPLACE;

    }

    public static enum ScoreMode {
        UNKNOWN,
        AVG,
        MAX,
        SUM,
        MIN,
        MULTIPLY,
        FIRST;

    }

    public static final class Builder
    implements QueryBuilder {
        private Query query;
        private List<ScoreFunction> functions;
        private ScoreMode scoreMode;
        private CombineMode combineMode;
        private Float minScore;
        private Float maxScore;

        private Builder() {
        }

        public Builder query(QueryBuilder queryBuilder) {
            this.query = queryBuilder.build();
            return this;
        }

        public Builder functions(List<ScoreFunction> functions) {
            this.functions = functions;
            return this;
        }

        public Builder addFunction(ScoreFunction function) {
            if (this.functions == null) {
                this.functions = new ArrayList<ScoreFunction>();
            }
            this.functions.add(function);
            return this;
        }

        public Builder query(Query query) {
            this.query = query;
            return this;
        }

        public Builder scoreMode(ScoreMode scoreMode) {
            this.scoreMode = scoreMode;
            return this;
        }

        public Builder combineMode(CombineMode combineMode) {
            this.combineMode = combineMode;
            return this;
        }

        public Builder minScore(Float minScore) {
            this.minScore = minScore;
            return this;
        }

        public Builder maxScore(Float maxScore) {
            this.maxScore = maxScore;
            return this;
        }

        @Override
        public FunctionsScoreQuery build() {
            FunctionsScoreQuery functionsScoreQuery = new FunctionsScoreQuery();
            functionsScoreQuery.setQuery(this.query);
            functionsScoreQuery.setFunctions(this.functions);
            functionsScoreQuery.setScoreMode(this.scoreMode);
            functionsScoreQuery.setCombineMode(this.combineMode);
            functionsScoreQuery.setMinScore(this.minScore);
            functionsScoreQuery.setMaxScore(this.maxScore);
            return functionsScoreQuery;
        }
    }
}

