/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search;

import com.alicloud.openservices.tablestore.model.search.Collapse;
import com.alicloud.openservices.tablestore.model.search.agg.Aggregation;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationBuilder;
import com.alicloud.openservices.tablestore.model.search.filter.SearchFilter;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupBy;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByBuilder;
import com.alicloud.openservices.tablestore.model.search.highlight.Highlight;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilder;
import com.alicloud.openservices.tablestore.model.search.sort.Sort;
import java.util.ArrayList;
import java.util.List;

public class SearchQuery {
    public static final int TRACK_TOTAL_COUNT = Integer.MAX_VALUE;
    public static final int TRACK_TOTAL_COUNT_DISABLED = -1;
    private Integer offset;
    private Integer limit;
    private Query query;
    private Highlight highlight;
    private Collapse collapse;
    private Sort sort;
    private int trackTotalCount = -1;
    private SearchFilter filter;
    private List<Aggregation> aggregationList;
    private List<GroupBy> groupByList;
    private byte[] token;

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<Aggregation> getAggregationList() {
        return this.aggregationList;
    }

    public void setAggregationList(List<Aggregation> aggregationList) {
        this.aggregationList = aggregationList;
    }

    public List<GroupBy> getGroupByList() {
        return this.groupByList;
    }

    public void setGroupByList(List<GroupBy> groupByList) {
        this.groupByList = groupByList;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public SearchQuery setOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SearchQuery setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    public SearchQuery setQuery(Query query) {
        this.query = query;
        return this;
    }

    public Highlight getHighlight() {
        return this.highlight;
    }

    public SearchQuery setHighlight(Highlight highlight) {
        this.highlight = highlight;
        return this;
    }

    public Collapse getCollapse() {
        return this.collapse;
    }

    public SearchQuery setCollapse(Collapse collapse) {
        this.collapse = collapse;
        return this;
    }

    public Sort getSort() {
        return this.sort;
    }

    public SearchQuery setSort(Sort sort) {
        this.sort = sort;
        return this;
    }

    @Deprecated
    public boolean isGetTotalCount() {
        return this.trackTotalCount == Integer.MAX_VALUE;
    }

    @Deprecated
    public void setGetTotalCount(boolean getTotalCount) {
        this.trackTotalCount = getTotalCount ? Integer.MAX_VALUE : -1;
    }

    public int getTrackTotalCount() {
        return this.trackTotalCount;
    }

    public void setTrackTotalCount(int trackTotalCount) {
        this.trackTotalCount = trackTotalCount;
    }

    public byte[] getToken() {
        return this.token;
    }

    public void setToken(byte[] token) {
        this.token = token;
        if (null != token) {
            this.sort = null;
        }
    }

    public SearchFilter getFilter() {
        return this.filter;
    }

    public SearchQuery setFilter(SearchFilter filter) {
        this.filter = filter;
        return this;
    }

    public SearchQuery() {
    }

    public SearchQuery toCopy() {
        SearchQuery copy = new SearchQuery();
        copy.setAggregationList(this.getAggregationList());
        copy.setCollapse(this.getCollapse());
        copy.setTrackTotalCount(this.getTrackTotalCount());
        copy.setGroupByList(this.getGroupByList());
        copy.setLimit(this.getLimit());
        copy.setOffset(this.getOffset());
        copy.setQuery(this.getQuery());
        copy.setHighlight(this.getHighlight());
        copy.setSort(this.getSort());
        copy.setToken(this.getToken());
        copy.setFilter(this.getFilter());
        return copy;
    }

    private SearchQuery(Builder builder) {
        this.setOffset(builder.offset);
        this.setLimit(builder.limit);
        this.setQuery(builder.query);
        this.setHighlight(builder.highlight);
        this.setCollapse(builder.collapse);
        this.setSort(builder.sort);
        this.setTrackTotalCount(builder.trackTotalCount);
        this.setAggregationList(builder.aggregationList);
        this.setGroupByList(builder.groupByList);
        this.setToken(builder.token);
        this.setFilter(builder.filter);
    }

    public static final class Builder {
        private Integer offset;
        private Integer limit;
        private Query query;
        private Highlight highlight;
        private Collapse collapse;
        private Sort sort;
        private int trackTotalCount = -1;
        private List<Aggregation> aggregationList;
        private List<GroupBy> groupByList;
        private byte[] token;
        private SearchFilter filter;

        private Builder() {
        }

        public Builder offset(int val) {
            this.offset = val;
            return this;
        }

        public Builder limit(int val) {
            this.limit = val;
            return this;
        }

        public Builder query(QueryBuilder queryBuilder) {
            this.query = queryBuilder.build();
            return this;
        }

        public Builder query(Query query) {
            this.query = query;
            return this;
        }

        public Builder highlight(Highlight highlight) {
            this.highlight = highlight;
            return this;
        }

        public Builder highlight(Highlight.Builder highlightBuilder) {
            this.highlight = highlightBuilder.build();
            return this;
        }

        public Builder collapse(String fieldName) {
            this.collapse = new Collapse(fieldName);
            return this;
        }

        public Builder sort(Sort val) {
            this.sort = val;
            return this;
        }

        public Builder getTotalCount(boolean val) {
            this.trackTotalCount = val ? Integer.MAX_VALUE : -1;
            return this;
        }

        public Builder trackTotalCount(int val) {
            this.trackTotalCount = val;
            return this;
        }

        public Builder addAggregation(AggregationBuilder aggregationBuilder) {
            if (this.aggregationList == null) {
                this.aggregationList = new ArrayList<Aggregation>();
            }
            this.aggregationList.add(aggregationBuilder.build());
            return this;
        }

        public Builder addAggregation(Aggregation aggregation) {
            if (this.aggregationList == null) {
                this.aggregationList = new ArrayList<Aggregation>();
            }
            this.aggregationList.add(aggregation);
            return this;
        }

        public Builder addGroupBy(GroupByBuilder groupByBuilder) {
            if (this.groupByList == null) {
                this.groupByList = new ArrayList<GroupBy>();
            }
            this.groupByList.add(groupByBuilder.build());
            return this;
        }

        public Builder addGroupBy(GroupBy groupBy) {
            if (this.groupByList == null) {
                this.groupByList = new ArrayList<GroupBy>();
            }
            this.groupByList.add(groupBy);
            return this;
        }

        public Builder token(byte[] val) {
            this.token = val;
            return this;
        }

        public Builder filter(SearchFilter filter) {
            this.filter = filter;
            return this;
        }

        public SearchQuery build() {
            return new SearchQuery(this);
        }
    }
}

