/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.iterator;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.model.BulkExportRequest;
import com.alicloud.openservices.tablestore.model.BulkExportResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RangeIteratorParameter;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.SimpleRowMatrixBlockParser;
import com.alicloud.openservices.tablestore.model.iterator.RowIterator;
import com.alicloud.openservices.tablestore.model.tunnel.BulkExportQueryCriteria;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BulkExportIterator
implements RowIterator {
    private SyncClientInterface client;
    private RangeIteratorParameter parameter;
    private BulkExportResponse result;
    private Iterator<Row> rowsIter;
    private int totalCount;
    private int bufferSize;
    private int rowsRead;

    public BulkExportIterator(SyncClientInterface client, RangeIteratorParameter parameter) {
        this.client = client;
        this.parameter = parameter;
        this.rowsRead = 0;
        this.totalCount = parameter.getMaxCount();
        this.bufferSize = parameter.getBufferSize();
        if (this.bufferSize == -1) {
            this.bufferSize = this.totalCount;
        } else if (this.totalCount != -1 && this.bufferSize > this.totalCount) {
            this.bufferSize = this.totalCount;
        }
        this.fetchData(this.buildRequest());
    }

    private BulkExportRequest buildRequest() {
        BulkExportQueryCriteria criteria = new BulkExportQueryCriteria(this.parameter.getTableName());
        criteria.addColumnsToGet(this.parameter.getColumnsToGet());
        if (this.parameter.hasSetFilter()) {
            criteria.setFilter(this.parameter.getFilter());
        }
        if (this.result == null) {
            criteria.setInclusiveStartPrimaryKey(this.parameter.getInclusiveStartPrimaryKey());
        } else {
            criteria.setInclusiveStartPrimaryKey(this.result.getNextStartPrimaryKey());
        }
        criteria.setExclusiveEndPrimaryKey(this.parameter.getExclusiveEndPrimaryKey());
        if (this.bufferSize <= 0 || this.totalCount == -1 || this.totalCount - this.rowsRead < this.bufferSize) {
            // empty if block
        }
        return new BulkExportRequest(criteria);
    }

    private void fetchData(BulkExportRequest request) {
        BulkExportResponse result;
        this.result = result = this.client.bulkExport(request);
        SimpleRowMatrixBlockParser parser = new SimpleRowMatrixBlockParser(result.getRows());
        this.rowsIter = parser.getRows().iterator();
        this.rowsRead += parser.getRows().size();
    }

    private boolean isBufferHasMoreData() {
        return this.rowsIter.hasNext();
    }

    private Row getNextFromBuffer() {
        return this.rowsIter.next();
    }

    @Override
    public boolean hasNext() {
        if (this.isBufferHasMoreData()) {
            return true;
        }
        PrimaryKey nextToken = this.result.getNextStartPrimaryKey();
        while (nextToken != null && !nextToken.isEmpty() && this.totalCount != this.rowsRead) {
            this.fetchData(this.buildRequest());
            if (this.isBufferHasMoreData()) {
                return true;
            }
            nextToken = this.result.getNextStartPrimaryKey();
        }
        return false;
    }

    @Override
    public Row next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.getNextFromBuffer();
    }

    @Override
    public void remove() {
        throw new ClientException("RowIterator do not support remove().");
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }
}

