/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Direction;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RowQueryCriteria;

public class RangeRowQueryCriteria
extends RowQueryCriteria {
    private Direction direction = Direction.FORWARD;
    private int limit = -1;
    private PrimaryKey inclusiveStartPrimaryKey;
    private PrimaryKey exclusiveEndPrimaryKey;
    private OptionalValue<byte[]> token = new OptionalValue("Token");

    public RangeRowQueryCriteria(String tableName) {
        super(tableName);
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        Preconditions.checkArgument(limit > 0, "The limit must be greater than 0.");
        this.limit = limit;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        Preconditions.checkNotNull(direction, "The direction should not be null.");
        this.direction = direction;
    }

    public PrimaryKey getInclusiveStartPrimaryKey() {
        return this.inclusiveStartPrimaryKey;
    }

    public void setInclusiveStartPrimaryKey(PrimaryKey inclusiveStartPrimaryKey) {
        Preconditions.checkArgument(inclusiveStartPrimaryKey != null && !inclusiveStartPrimaryKey.isEmpty(), "The inclusive start primary key should not be null.");
        this.inclusiveStartPrimaryKey = inclusiveStartPrimaryKey;
    }

    public PrimaryKey getExclusiveEndPrimaryKey() {
        return this.exclusiveEndPrimaryKey;
    }

    public void setExclusiveEndPrimaryKey(PrimaryKey exclusiveEndPrimaryKey) {
        Preconditions.checkArgument(exclusiveEndPrimaryKey != null && !exclusiveEndPrimaryKey.isEmpty(), "The exclusive end primary key should not be null.");
        this.exclusiveEndPrimaryKey = exclusiveEndPrimaryKey;
    }

    public byte[] getToken() {
        if (!this.token.isValueSet()) {
            throw new IllegalStateException("The value of token is not set.");
        }
        return this.token.getValue();
    }

    public void setToken(byte[] token) {
        if (token != null) {
            this.token.setValue(token);
        }
    }

    public boolean hasSetToken() {
        return this.token.isValueSet();
    }
}

