/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.IndexMeta;
import com.alicloud.openservices.tablestore.model.Request;

public class CreateIndexRequest
implements Request {
    private String mainTableName;
    private IndexMeta indexMeta;
    private boolean includeBaseData;

    public CreateIndexRequest(String mainTableName, IndexMeta indexMeta, boolean includeBaseData) {
        this.setMainTableName(mainTableName);
        this.setIndexMeta(indexMeta);
        this.setIncludeBaseData(includeBaseData);
    }

    public void setMainTableName(String mainTableName) {
        Preconditions.checkArgument(mainTableName != null && !mainTableName.isEmpty(), "The main table name should not be null or empty");
        this.mainTableName = mainTableName;
    }

    public void setIndexMeta(IndexMeta indexMeta) {
        Preconditions.checkArgument(indexMeta != null, "The index meta should not be null");
        this.indexMeta = indexMeta;
    }

    public void setIncludeBaseData(boolean includeBaseData) {
        this.includeBaseData = includeBaseData;
    }

    public String getMainTableName() {
        return this.mainTableName;
    }

    public IndexMeta getIndexMeta() {
        return this.indexMeta;
    }

    public boolean getIncludeBaseData() {
        return this.includeBaseData;
    }

    @Override
    public String getOperationName() {
        return "CreateIndex";
    }
}

