/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.IRow;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;

public class Row
implements IRow {
    private PrimaryKey primaryKey;
    private Column[] columns;
    private NavigableMap<String, NavigableMap<Long, ColumnValue>> columnsMap;

    public Row(PrimaryKey primaryKey, List<Column> columns) {
        this(primaryKey, columns.toArray(new Column[columns.size()]));
    }

    public Row(PrimaryKey primaryKey, Column[] columns) {
        Preconditions.checkArgument(primaryKey != null && !primaryKey.isEmpty(), "The primary key of row should not be null or empty.");
        Preconditions.checkNotNull(columns, "The columns of row should not be null.");
        this.primaryKey = primaryKey;
        this.columns = columns;
        this.sortColumns();
    }

    private void sortColumns() {
        boolean sorted = true;
        for (int i = 0; i < this.columns.length - 1; ++i) {
            int ret = Column.NAME_TIMESTAMP_COMPARATOR.compare(this.columns[i], this.columns[i + 1]);
            if (ret <= 0) continue;
            sorted = false;
            break;
        }
        if (!sorted) {
            Arrays.sort(this.columns, Column.NAME_TIMESTAMP_COMPARATOR);
        }
    }

    private int binarySearch(String name) {
        Column searchTerm = new Column(name, ColumnValue.INTERNAL_NULL_VALUE, Long.MAX_VALUE);
        int pos = Arrays.binarySearch(this.columns, searchTerm, Column.NAME_TIMESTAMP_COMPARATOR);
        if (pos < 0) {
            pos = (pos + 1) * -1;
        }
        if (pos == this.columns.length) {
            return -1;
        }
        return pos;
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public List<Column> getColumn(String name) {
        Column col;
        ArrayList<Column> result = new ArrayList<Column>();
        if (this.columns == null || this.columns.length == 0) {
            return result;
        }
        int pos = this.binarySearch(name);
        if (pos == -1) {
            return result;
        }
        for (int i = pos; i < this.columns.length && (col = this.columns[i]).getName().equals(name); ++i) {
            result.add(col);
        }
        return result;
    }

    public Column getLatestColumn(String name) {
        if (this.columns == null || this.columns.length == 0) {
            return null;
        }
        int pos = this.binarySearch(name);
        if (pos == -1) {
            return null;
        }
        Column col = this.columns[pos];
        if (col.getName().equals(name)) {
            return col;
        }
        return null;
    }

    public boolean contains(String name) {
        return this.getLatestColumn(name) != null;
    }

    public boolean isEmpty() {
        return this.columns == null || this.columns.length == 0;
    }

    public NavigableMap<String, NavigableMap<Long, ColumnValue>> getColumnsMap() {
        if (this.columnsMap != null) {
            return this.columnsMap;
        }
        this.columnsMap = new TreeMap<String, NavigableMap<Long, ColumnValue>>();
        if (this.isEmpty()) {
            return this.columnsMap;
        }
        for (Column col : this.columns) {
            TreeMap<Long, ColumnValue> tsMap = (TreeMap<Long, ColumnValue>)this.columnsMap.get(col.getName());
            if (tsMap == null) {
                tsMap = new TreeMap<Long, ColumnValue>(new Comparator<Long>(){

                    @Override
                    public int compare(Long l1, Long l2) {
                        return l2.compareTo(l1);
                    }
                });
                this.columnsMap.put(col.getName(), tsMap);
            }
            tsMap.put(col.getTimestamp(), col.getValue());
        }
        return this.columnsMap;
    }

    @Override
    public int compareTo(IRow o) {
        return this.primaryKey.compareTo(o.getPrimaryKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[PrimaryKey:]");
        sb.append(this.primaryKey);
        sb.append("\n[Columns:]");
        for (Column column : this.getColumns()) {
            sb.append("(");
            sb.append(column);
            sb.append(")");
        }
        return sb.toString();
    }
}

