/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RowQueryCriteria;
import java.util.ArrayList;
import java.util.List;

public class MultiRowQueryCriteria
extends RowQueryCriteria {
    private List<PrimaryKey> rowKeys = new ArrayList<PrimaryKey>();
    private List<byte[]> tokens = new ArrayList<byte[]>();

    public MultiRowQueryCriteria(String tableName) {
        super(tableName);
    }

    public MultiRowQueryCriteria addRow(PrimaryKey primaryKey) {
        Preconditions.checkArgument(primaryKey != null && !primaryKey.isEmpty(), "The primary key added should not be null.");
        this.rowKeys.add(primaryKey);
        this.tokens.add(new byte[0]);
        return this;
    }

    public MultiRowQueryCriteria addRow(PrimaryKey primaryKey, byte[] token) {
        Preconditions.checkArgument(primaryKey != null && !primaryKey.isEmpty(), "The primary key added should not be null.");
        this.rowKeys.add(primaryKey);
        this.tokens.add(token);
        return this;
    }

    public List<PrimaryKey> getRowKeys() {
        return this.rowKeys;
    }

    public void setRowKeys(List<PrimaryKey> primaryKeys) {
        Preconditions.checkArgument(primaryKeys != null && !primaryKeys.isEmpty(), "The rows to get should not be null or empty.");
        this.clear();
        this.rowKeys.addAll(primaryKeys);
        for (int i = 0; i < primaryKeys.size(); ++i) {
            this.tokens.add(new byte[0]);
        }
    }

    public List<byte[]> getTokens() {
        return this.tokens;
    }

    public PrimaryKey get(int index) {
        Preconditions.checkArgument(index >= 0, "The index should not be negative.");
        if (this.rowKeys == null || this.rowKeys.isEmpty()) {
            return null;
        }
        if (index >= this.rowKeys.size()) {
            return null;
        }
        return this.rowKeys.get(index);
    }

    public void clear() {
        this.rowKeys.clear();
    }

    public int size() {
        return this.rowKeys.size();
    }

    public boolean isEmpty() {
        return this.rowKeys.isEmpty();
    }

    public MultiRowQueryCriteria cloneWithoutRowKeys() {
        MultiRowQueryCriteria newCriteria = new MultiRowQueryCriteria(this.getTableName());
        this.copyTo(newCriteria);
        return newCriteria;
    }
}

