/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.ResponseContentWithMeta;
import com.alicloud.openservices.tablestore.core.protocol.OTSProtocolParser;
import com.alicloud.openservices.tablestore.core.protocol.OtsInternalApi;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferCodedInputStream;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferConversion;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferInputStream;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferRow;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.BatchWriteRowResponse;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeResponse;
import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.CreateTableResponse;
import com.alicloud.openservices.tablestore.model.DeleteRowResponse;
import com.alicloud.openservices.tablestore.model.DeleteTableResponse;
import com.alicloud.openservices.tablestore.model.DescribeStreamResponse;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.GetShardIteratorResponse;
import com.alicloud.openservices.tablestore.model.GetStreamRecordResponse;
import com.alicloud.openservices.tablestore.model.ListStreamResponse;
import com.alicloud.openservices.tablestore.model.ListTableResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.Split;
import com.alicloud.openservices.tablestore.model.Stream;
import com.alicloud.openservices.tablestore.model.StreamRecord;
import com.alicloud.openservices.tablestore.model.StreamShard;
import com.alicloud.openservices.tablestore.model.UpdateRowResponse;
import com.alicloud.openservices.tablestore.model.UpdateTableResponse;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ResponseFactory {
    public static CreateTableResponse createCreateTableResponse(ResponseContentWithMeta response, OtsInternalApi.CreateTableResponse createTableResponse) {
        return new CreateTableResponse(response.getMeta());
    }

    public static ListTableResponse createListTableResponse(ResponseContentWithMeta response, OtsInternalApi.ListTableResponse listTableResponse) {
        ListTableResponse result = new ListTableResponse(response.getMeta());
        result.setTableNames(listTableResponse.getTableNamesList());
        return result;
    }

    public static DescribeTableResponse createDescribeTableResponse(ResponseContentWithMeta response, OtsInternalApi.DescribeTableResponse describeTableResponse) {
        try {
            DescribeTableResponse result = new DescribeTableResponse(response.getMeta());
            result.setTableMeta(OTSProtocolParser.parseTableMeta(describeTableResponse.getTableMeta()));
            result.setReservedThroughputDetails(OTSProtocolParser.parseReservedThroughputDetails(describeTableResponse.getReservedThroughputDetails()));
            result.setTableOptions(OTSProtocolParser.parseTableOptions(describeTableResponse.getTableOptions()));
            if (describeTableResponse.hasStreamDetails()) {
                result.setStreamDetails(OTSProtocolParser.parseStreamDetails(describeTableResponse.getStreamDetails()));
            }
            ArrayList<PrimaryKey> shards = new ArrayList<PrimaryKey>();
            for (int i = 0; i < describeTableResponse.getShardSplitsCount(); ++i) {
                ByteString bytes = describeTableResponse.getShardSplits(i);
                PlainBufferCodedInputStream coded = new PlainBufferCodedInputStream(new PlainBufferInputStream(bytes.asReadOnlyByteBuffer()));
                List<PlainBufferRow> rows = coded.readRowsWithHeader();
                if (rows.size() != 1) {
                    throw new IOException("Expect only returns one row. Row count: " + rows.size());
                }
                Row row = PlainBufferConversion.toRow(rows.get(0));
                shards.add(row.getPrimaryKey());
            }
            result.setShardSplits(shards);
            return result;
        }
        catch (Exception e) {
            throw new ClientException("Failed to parse describe table response.", e);
        }
    }

    public static DeleteTableResponse createDeleteTableResponse(ResponseContentWithMeta response, OtsInternalApi.DeleteTableResponse deleteTableResponse) {
        return new DeleteTableResponse(response.getMeta());
    }

    public static UpdateTableResponse createUpdateTableResponse(ResponseContentWithMeta response, OtsInternalApi.UpdateTableResponse updateTableResponse) {
        UpdateTableResponse result = new UpdateTableResponse(response.getMeta());
        result.setReservedThroughputDetails(OTSProtocolParser.parseReservedThroughputDetails(updateTableResponse.getReservedThroughputDetails()));
        result.setTableOptions(OTSProtocolParser.parseTableOptions(updateTableResponse.getTableOptions()));
        if (updateTableResponse.hasStreamDetails()) {
            result.setStreamDetails(OTSProtocolParser.parseStreamDetails(updateTableResponse.getStreamDetails()));
        }
        return result;
    }

    public static GetRowResponse createGetRowResponse(ResponseContentWithMeta response, OtsInternalApi.GetRowResponse getRowResponse) {
        ConsumedCapacity consumedCapacity = new ConsumedCapacity(OTSProtocolParser.parseCapacityUnit(getRowResponse.getConsumed().getCapacityUnit()));
        Row row = null;
        if (!getRowResponse.getRow().isEmpty()) {
            try {
                PlainBufferCodedInputStream inputStream = new PlainBufferCodedInputStream(new PlainBufferInputStream(getRowResponse.getRow().asReadOnlyByteBuffer()));
                List<PlainBufferRow> rows = inputStream.readRowsWithHeader();
                if (rows.size() != 1) {
                    throw new IOException("Expect only returns one row. Row count: " + rows.size());
                }
                row = PlainBufferConversion.toRow(rows.get(0));
            }
            catch (Exception e) {
                throw new ClientException("Failed to parse row", e);
            }
        }
        GetRowResponse result = new GetRowResponse(response.getMeta(), row, consumedCapacity);
        if (getRowResponse.hasNextToken()) {
            result.setNextToken(getRowResponse.getNextToken().toByteArray());
        }
        return result;
    }

    public static PutRowResponse createPutRowResponse(ResponseContentWithMeta response, OtsInternalApi.PutRowResponse putRowResponse) {
        ConsumedCapacity consumedCapacity = new ConsumedCapacity(OTSProtocolParser.parseCapacityUnit(putRowResponse.getConsumed().getCapacityUnit()));
        Row row = null;
        if (!putRowResponse.getRow().isEmpty()) {
            try {
                PlainBufferCodedInputStream inputStream = new PlainBufferCodedInputStream(new PlainBufferInputStream(putRowResponse.getRow().asReadOnlyByteBuffer()));
                List<PlainBufferRow> rows = inputStream.readRowsWithHeader();
                if (rows.size() != 1) {
                    throw new IOException("Expect only returns one row. Row count: " + rows.size());
                }
                row = PlainBufferConversion.toRow(rows.get(0));
            }
            catch (Exception e) {
                throw new ClientException("Failed to parse row", e);
            }
        }
        PutRowResponse result = new PutRowResponse(response.getMeta(), row, consumedCapacity);
        return result;
    }

    public static UpdateRowResponse createUpdateRowResponse(ResponseContentWithMeta response, OtsInternalApi.UpdateRowResponse updateRowResponse) {
        ConsumedCapacity consumedCapacity = new ConsumedCapacity(OTSProtocolParser.parseCapacityUnit(updateRowResponse.getConsumed().getCapacityUnit()));
        Row row = null;
        if (!updateRowResponse.getRow().isEmpty()) {
            try {
                PlainBufferCodedInputStream inputStream = new PlainBufferCodedInputStream(new PlainBufferInputStream(updateRowResponse.getRow().asReadOnlyByteBuffer()));
                List<PlainBufferRow> rows = inputStream.readRowsWithHeader();
                if (rows.size() != 1) {
                    throw new IOException("Expect only returns one row. Row count: " + rows.size());
                }
                row = PlainBufferConversion.toRow(rows.get(0));
            }
            catch (Exception e) {
                throw new ClientException("Failed to parse row", e);
            }
        }
        UpdateRowResponse result = new UpdateRowResponse(response.getMeta(), row, consumedCapacity);
        return result;
    }

    public static DeleteRowResponse createDeleteRowResponse(ResponseContentWithMeta response, OtsInternalApi.DeleteRowResponse deleteRowResponse) {
        ConsumedCapacity consumedCapacity = new ConsumedCapacity(OTSProtocolParser.parseCapacityUnit(deleteRowResponse.getConsumed().getCapacityUnit()));
        Row row = null;
        if (!deleteRowResponse.getRow().isEmpty()) {
            try {
                PlainBufferCodedInputStream inputStream = new PlainBufferCodedInputStream(new PlainBufferInputStream(deleteRowResponse.getRow().asReadOnlyByteBuffer()));
                List<PlainBufferRow> rows = inputStream.readRowsWithHeader();
                if (rows.size() != 1) {
                    throw new IOException("Expect only returns one row. Row count: " + rows.size());
                }
                row = PlainBufferConversion.toRow(rows.get(0));
            }
            catch (Exception e) {
                throw new ClientException("Failed to parse row", e);
            }
        }
        DeleteRowResponse result = new DeleteRowResponse(response.getMeta(), row, consumedCapacity);
        return result;
    }

    public static GetRangeResponse createGetRangeResponse(ResponseContentWithMeta response, OtsInternalApi.GetRangeResponse getRangeResponse) {
        try {
            ConsumedCapacity consumedCapacity = new ConsumedCapacity(OTSProtocolParser.parseCapacityUnit(getRangeResponse.getConsumed().getCapacityUnit()));
            GetRangeResponse result = new GetRangeResponse(response.getMeta(), consumedCapacity);
            if (!getRangeResponse.hasNextStartPrimaryKey()) {
                result.setNextStartPrimaryKey(null);
            } else {
                PlainBufferCodedInputStream inputStream = new PlainBufferCodedInputStream(new PlainBufferInputStream(getRangeResponse.getNextStartPrimaryKey().asReadOnlyByteBuffer()));
                List<PlainBufferRow> rows = inputStream.readRowsWithHeader();
                if (rows.size() != 1) {
                    throw new IOException("Expect only returns one row. Row count: " + rows.size());
                }
                PlainBufferRow row = rows.get(0);
                if (row.hasDeleteMarker() || row.hasCells()) {
                    throw new IOException("The next primary key should only have primary key: " + row);
                }
                result.setNextStartPrimaryKey(PlainBufferConversion.toPrimaryKey(row.getPrimaryKey()));
            }
            if (!getRangeResponse.getRows().isEmpty()) {
                ArrayList<Row> rows = new ArrayList<Row>();
                PlainBufferCodedInputStream inputStream = new PlainBufferCodedInputStream(new PlainBufferInputStream(getRangeResponse.getRows().asReadOnlyByteBuffer()));
                List<PlainBufferRow> pbRows = inputStream.readRowsWithHeader();
                for (PlainBufferRow pbRow : pbRows) {
                    rows.add(PlainBufferConversion.toRow(pbRow));
                }
                result.setRows(rows);
            } else {
                result.setRows(new ArrayList<Row>());
            }
            if (getRangeResponse.hasNextToken()) {
                result.setNextToken(getRangeResponse.getNextToken().toByteArray());
            }
            return result;
        }
        catch (Exception e) {
            throw new ClientException("Failed to parse get range response.", e);
        }
    }

    public static ComputeSplitsBySizeResponse createComputeSplitsBySizeResponse(ResponseContentWithMeta response, OtsInternalApi.ComputeSplitPointsBySizeResponse computeSplitPointsBySizeResponse) {
        ComputeSplitsBySizeResponse result = new ComputeSplitsBySizeResponse(response.getMeta());
        ConsumedCapacity consumedCapacity = new ConsumedCapacity(OTSProtocolParser.parseCapacityUnit(computeSplitPointsBySizeResponse.getConsumed().getCapacityUnit()));
        result.setConsumedCapacity(consumedCapacity);
        List<OtsInternalApi.PrimaryKeySchema> schemaList = computeSplitPointsBySizeResponse.getSchemaList();
        for (OtsInternalApi.PrimaryKeySchema pks : schemaList) {
            if (pks.hasOption()) {
                result.addPrimaryKeySchema(pks.getName(), OTSProtocolParser.toPrimaryKeyType(pks.getType()), OTSProtocolParser.toPrimaryKeyOption(pks.getOption()));
                continue;
            }
            result.addPrimaryKeySchema(pks.getName(), OTSProtocolParser.toPrimaryKeyType(pks.getType()));
        }
        ArrayList<PrimaryKeyColumn> infStartColumns = new ArrayList<PrimaryKeyColumn>();
        ArrayList<PrimaryKeyColumn> infEndColumns = new ArrayList<PrimaryKeyColumn>();
        for (PrimaryKeySchema pks : result.getPrimaryKeySchema()) {
            infEndColumns.add(new PrimaryKeyColumn(pks.getName(), PrimaryKeyValue.INF_MAX));
            infStartColumns.add(new PrimaryKeyColumn(pks.getName(), PrimaryKeyValue.INF_MIN));
        }
        PrimaryKey infStart = new PrimaryKey(infStartColumns);
        PrimaryKey infEnd = new PrimaryKey(infEndColumns);
        PrimaryKey lastStartPoint = infStart;
        for (int iter = 0; iter < computeSplitPointsBySizeResponse.getSplitPointsCount(); ++iter) {
            Split split = new Split();
            split.setLowerBound(lastStartPoint);
            Row row = null;
            try {
                ByteString bss = computeSplitPointsBySizeResponse.getSplitPoints(iter);
                PlainBufferCodedInputStream inputStream = new PlainBufferCodedInputStream(new PlainBufferInputStream(bss.asReadOnlyByteBuffer()));
                List<PlainBufferRow> rows = inputStream.readRowsWithHeader();
                if (rows.size() <= 0) {
                    throw new ClientException("The parsed response rows' length is zero.");
                }
                row = PlainBufferConversion.toRow(rows.get(0));
            }
            catch (Exception e) {
                throw new ClientException("Failed to parse row data.", e);
            }
            PrimaryKey primaryKeys = row.getPrimaryKey();
            ArrayList<PrimaryKeyColumn> pkcl = new ArrayList<PrimaryKeyColumn>();
            for (PrimaryKeyColumn pkcc : primaryKeys.getPrimaryKeyColumns()) {
                pkcl.add(pkcc);
            }
            for (int loc = pkcl.size(); loc < result.getPrimaryKeySchema().size(); ++loc) {
                pkcl.add(new PrimaryKeyColumn(result.getPrimaryKeySchema().get(loc).getName(), PrimaryKeyValue.INF_MIN));
            }
            primaryKeys = new PrimaryKey(pkcl);
            split.setUpperBound(primaryKeys);
            lastStartPoint = primaryKeys;
            result.addSplit(split);
        }
        Split split = new Split();
        split.setLowerBound(lastStartPoint);
        split.setUpperBound(infEnd);
        result.addSplit(split);
        int splitPointIter = 0;
        for (OtsInternalApi.ComputeSplitPointsBySizeResponse.SplitLocation sl : computeSplitPointsBySizeResponse.getLocationsList()) {
            for (long sli = 0L; sli < sl.getRepeat(); ++sli) {
                if (splitPointIter >= result.getSplits().size()) {
                    throw new ClientException("The location list's length is not correct. Location list size: " + splitPointIter + ". Split list size: " + result.getSplits().size());
                }
                result.getSplits().get(splitPointIter).setLocation(sl.getLocation());
                ++splitPointIter;
            }
        }
        if (splitPointIter != result.getSplits().size()) {
            throw new ClientException("The location list's length is not correct. Location list size: " + splitPointIter + ". Split list size: " + result.getSplits().size());
        }
        return result;
    }

    public static BatchGetRowResponse createBatchGetRowResponse(ResponseContentWithMeta response, OtsInternalApi.BatchGetRowResponse batchGetRowResponse) {
        BatchGetRowResponse result = new BatchGetRowResponse(response.getMeta());
        for (OtsInternalApi.TableInBatchGetRowResponse table : batchGetRowResponse.getTablesList()) {
            String tableName = table.getTableName();
            List<OtsInternalApi.RowInBatchGetRowResponse> rowList = table.getRowsList();
            for (int i = 0; i < rowList.size(); ++i) {
                result.addResult(OTSProtocolParser.parseBatchGetRowStatus(tableName, rowList.get(i), i));
            }
        }
        return result;
    }

    public static BatchWriteRowResponse createBatchWriteRowResponse(ResponseContentWithMeta response, OtsInternalApi.BatchWriteRowResponse batchWriteRowResponse) {
        BatchWriteRowResponse result = new BatchWriteRowResponse(response.getMeta());
        for (OtsInternalApi.TableInBatchWriteRowResponse table : batchWriteRowResponse.getTablesList()) {
            String tableName = table.getTableName();
            List<OtsInternalApi.RowInBatchWriteRowResponse> statuses = table.getRowsList();
            for (int i = 0; i < statuses.size(); ++i) {
                result.addRowResult(OTSProtocolParser.parseBatchWriteRowStatus(tableName, statuses.get(i), i));
            }
        }
        return result;
    }

    public static ListStreamResponse createListStreamResponse(ResponseContentWithMeta response, OtsInternalApi.ListStreamResponse listStreamResponse) {
        ListStreamResponse result = new ListStreamResponse(response.getMeta());
        ArrayList<Stream> streams = new ArrayList<Stream>();
        for (OtsInternalApi.Stream stream : listStreamResponse.getStreamsList()) {
            streams.add(OTSProtocolParser.parseStream(stream));
        }
        result.setStreams(streams);
        return result;
    }

    public static DescribeStreamResponse createDescribeStreamResponse(ResponseContentWithMeta response, OtsInternalApi.DescribeStreamResponse describeStreamResponse) {
        DescribeStreamResponse result = new DescribeStreamResponse(response.getMeta());
        result.setStreamId(describeStreamResponse.getStreamId());
        result.setExpirationTime(describeStreamResponse.getExpirationTime());
        result.setTableName(describeStreamResponse.getTableName());
        result.setCreationTime(describeStreamResponse.getCreationTime());
        result.setStatus(OTSProtocolParser.parseStreamStatus(describeStreamResponse.getStreamStatus()));
        ArrayList<StreamShard> shards = new ArrayList<StreamShard>();
        for (OtsInternalApi.StreamShard shard : describeStreamResponse.getShardsList()) {
            shards.add(OTSProtocolParser.parseStreamShard(shard));
        }
        result.setShards(shards);
        if (describeStreamResponse.hasNextShardId()) {
            result.setNextShardId(describeStreamResponse.getNextShardId());
        }
        return result;
    }

    public static GetShardIteratorResponse createGetShardIteratorResponse(ResponseContentWithMeta response, OtsInternalApi.GetShardIteratorResponse getShardIteratorResponse) {
        GetShardIteratorResponse result = new GetShardIteratorResponse(response.getMeta());
        result.setShardIterator(getShardIteratorResponse.getShardIterator());
        return result;
    }

    public static GetStreamRecordResponse createGetStreamRecordResponse(ResponseContentWithMeta response, OtsInternalApi.GetStreamRecordResponse getStreamRecordResponse) {
        GetStreamRecordResponse result = new GetStreamRecordResponse(response.getMeta());
        if (getStreamRecordResponse.hasNextShardIterator()) {
            result.setNextShardIterator(getStreamRecordResponse.getNextShardIterator());
        }
        ArrayList<StreamRecord> records = new ArrayList<StreamRecord>();
        for (OtsInternalApi.GetStreamRecordResponse.StreamRecord respRecord : getStreamRecordResponse.getStreamRecordsList()) {
            try {
                PlainBufferCodedInputStream inputStream = new PlainBufferCodedInputStream(new PlainBufferInputStream(respRecord.getRecord().asReadOnlyByteBuffer()));
                List<PlainBufferRow> rows = inputStream.readRowsWithHeader();
                if (rows.size() != 1) {
                    throw new IOException("Expect only returns one row. Row count: " + rows.size());
                }
                PlainBufferRow row = rows.get(0);
                records.add(PlainBufferConversion.toStreamRecord(row, respRecord.getActionType()));
            }
            catch (Exception e) {
                throw new ClientException("Failed to parse row", e);
            }
        }
        result.setRecords(records);
        return result;
    }
}

