/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.protocol.OtsFilter;
import com.alicloud.openservices.tablestore.core.protocol.OtsInternalApi;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferBuilder;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.CapacityUnit;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeRequest;
import com.alicloud.openservices.tablestore.model.Condition;
import com.alicloud.openservices.tablestore.model.CreateTableRequest;
import com.alicloud.openservices.tablestore.model.DeleteTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeStreamRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.Direction;
import com.alicloud.openservices.tablestore.model.GetShardIteratorRequest;
import com.alicloud.openservices.tablestore.model.GetStreamRecordRequest;
import com.alicloud.openservices.tablestore.model.ListStreamRequest;
import com.alicloud.openservices.tablestore.model.MultiRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.PartitionRange;
import com.alicloud.openservices.tablestore.model.PrimaryKeyOption;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.ReservedThroughput;
import com.alicloud.openservices.tablestore.model.ReturnType;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowExistenceExpectation;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.StreamSpecification;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.model.TableOptions;
import com.alicloud.openservices.tablestore.model.TimeRange;
import com.alicloud.openservices.tablestore.model.UpdateTableRequest;
import com.alicloud.openservices.tablestore.model.condition.ColumnCondition;
import com.alicloud.openservices.tablestore.model.condition.ColumnConditionType;
import com.alicloud.openservices.tablestore.model.filter.ColumnPaginationFilter;
import com.alicloud.openservices.tablestore.model.filter.CompositeColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.Filter;
import com.alicloud.openservices.tablestore.model.filter.FilterType;
import com.alicloud.openservices.tablestore.model.filter.SingleColumnValueFilter;
import com.alicloud.openservices.tablestore.model.internal.BloomFilterType;
import com.alicloud.openservices.tablestore.model.internal.CreateTableRequestEx;
import com.alicloud.openservices.tablestore.model.internal.TableOptionsEx;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class OTSProtocolBuilder {
    public static OtsInternalApi.PrimaryKeyType toPBPrimaryKeyType(PrimaryKeyType type) {
        switch (type) {
            case INTEGER: {
                return OtsInternalApi.PrimaryKeyType.INTEGER;
            }
            case STRING: {
                return OtsInternalApi.PrimaryKeyType.STRING;
            }
            case BINARY: {
                return OtsInternalApi.PrimaryKeyType.BINARY;
            }
        }
        throw new IllegalArgumentException("Unknown primary key type: " + (Object)((Object)type));
    }

    public static OtsInternalApi.PrimaryKeyOption toPBPrimaryKeyOption(PrimaryKeyOption option) {
        switch (option) {
            case AUTO_INCREMENT: {
                return OtsInternalApi.PrimaryKeyOption.AUTO_INCREMENT;
            }
        }
        throw new IllegalArgumentException("Unknown primary key option: " + (Object)((Object)option));
    }

    public static OtsInternalApi.TableMeta buildTableMeta(TableMeta tableMeta) {
        OtsInternalApi.TableMeta.Builder builder = OtsInternalApi.TableMeta.newBuilder();
        builder.setTableName(tableMeta.getTableName());
        for (PrimaryKeySchema pk : tableMeta.getPrimaryKeyList()) {
            builder.addPrimaryKey(OTSProtocolBuilder.buildPrimaryKeySchema(pk));
        }
        return builder.build();
    }

    private static OtsInternalApi.PrimaryKeySchema buildPrimaryKeySchema(PrimaryKeySchema pk) {
        OtsInternalApi.PrimaryKeySchema.Builder builder = OtsInternalApi.PrimaryKeySchema.newBuilder();
        builder.setName(pk.getName());
        builder.setType(OTSProtocolBuilder.toPBPrimaryKeyType(pk.getType()));
        if (pk.hasOption()) {
            builder.setOption(OTSProtocolBuilder.toPBPrimaryKeyOption(pk.getOption()));
        }
        return builder.build();
    }

    public static OtsInternalApi.GetRowRequest buildGetRowRequest(SingleRowQueryCriteria criteria) {
        OtsInternalApi.GetRowRequest.Builder builder = OtsInternalApi.GetRowRequest.newBuilder();
        builder.setTableName(criteria.getTableName());
        try {
            builder.setPrimaryKey(ByteString.copyFrom((byte[])PlainBufferBuilder.buildPrimaryKeyWithHeader(criteria.getPrimaryKey())));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize primary key failed.", e);
        }
        for (String column : criteria.getColumnsToGet()) {
            builder.addColumnsToGet(column);
        }
        boolean onlyOneVersionInTimeRange = false;
        if (criteria.hasSetTimeRange()) {
            builder.setTimeRange(OTSProtocolBuilder.buildTimeRange(criteria.getTimeRange()));
            onlyOneVersionInTimeRange = criteria.getTimeRange().containsOnlyOneVersion();
        }
        if (criteria.hasSetMaxVersions() && !onlyOneVersionInTimeRange) {
            builder.setMaxVersions(criteria.getMaxVersions());
        }
        if (criteria.hasSetCacheBlock()) {
            builder.setCacheBlocks(criteria.getCacheBlocks());
        }
        if (criteria.hasSetFilter()) {
            builder.setFilter(OTSProtocolBuilder.buildFilter(criteria.getFilter()));
        }
        if (criteria.hasSetStartColumn()) {
            builder.setStartColumn(criteria.getStartColumn());
        }
        if (criteria.hasSetEndColumn()) {
            builder.setEndColumn(criteria.getEndColumn());
        }
        if (criteria.hasSetToken()) {
            builder.setToken(ByteString.copyFrom((byte[])criteria.getToken()));
        }
        return builder.build();
    }

    private static OtsInternalApi.TimeRange buildTimeRange(TimeRange timeRange) {
        OtsInternalApi.TimeRange.Builder builder = OtsInternalApi.TimeRange.newBuilder();
        if (timeRange.containsOnlyOneVersion()) {
            builder.setSpecificTime(timeRange.getStart());
        } else {
            builder.setStartTime(timeRange.getStart());
            builder.setEndTime(timeRange.getEnd());
        }
        return builder.build();
    }

    public static OtsInternalApi.CreateTableRequest buildCreateTableRequest(CreateTableRequest createTableRequest) {
        OtsInternalApi.CreateTableRequest.Builder builder = OtsInternalApi.CreateTableRequest.newBuilder();
        builder.setTableMeta(OTSProtocolBuilder.buildTableMeta(createTableRequest.getTableMeta()));
        builder.setReservedThroughput(OTSProtocolBuilder.buildReservedThroughput(createTableRequest.getReservedThroughput()));
        TableOptions tableOptions = createTableRequest.getTableOptions();
        if (!tableOptions.hasSetMaxVersions() || !tableOptions.hasSetTimeToLive()) {
            throw new IllegalArgumentException("The maxVersions and timeToLive must be set while creating table.");
        }
        builder.setTableOptions(OTSProtocolBuilder.buildTableOptions(tableOptions));
        StreamSpecification streamSpec = createTableRequest.getStreamSpecification();
        if (streamSpec != null) {
            builder.setStreamSpec(OTSProtocolBuilder.buildStreamSpecification(streamSpec));
        }
        if (createTableRequest instanceof CreateTableRequestEx && ((CreateTableRequestEx)createTableRequest).getPartitionRangeList() != null) {
            for (PartitionRange range : ((CreateTableRequestEx)createTableRequest).getPartitionRangeList()) {
                builder.addPartitions(OTSProtocolBuilder.buildPartitionRange(range));
            }
        }
        return builder.build();
    }

    private static OtsInternalApi.PartitionRange buildPartitionRange(PartitionRange range) {
        OtsInternalApi.PartitionRange.Builder builder = OtsInternalApi.PartitionRange.newBuilder();
        try {
            builder.setBegin(ByteString.copyFrom((byte[])PlainBufferBuilder.buildPrimaryKeyValueWithoutLengthPrefix(range.getBegin())));
            builder.setEnd(ByteString.copyFrom((byte[])PlainBufferBuilder.buildPrimaryKeyValueWithoutLengthPrefix(range.getEnd())));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize partition range failed.", e);
        }
        return builder.build();
    }

    private static OtsInternalApi.TableOptions buildTableOptions(TableOptions x) {
        OtsInternalApi.TableOptions.Builder builder = OtsInternalApi.TableOptions.newBuilder();
        if (x instanceof TableOptionsEx && ((TableOptionsEx)x).hasSetBloomFilterType()) {
            builder.setBloomFilterType(OTSProtocolBuilder.toBloomFilterType(((TableOptionsEx)x).getBloomFilterType()));
        }
        if (x.hasSetMaxVersions()) {
            builder.setMaxVersions(x.getMaxVersions());
        }
        if (x.hasSetTimeToLive()) {
            builder.setTimeToLive(x.getTimeToLive());
        }
        if (x.hasSetMaxTimeDeviation()) {
            builder.setDeviationCellVersionInSec(x.getMaxTimeDeviation());
        }
        if (x instanceof TableOptionsEx && ((TableOptionsEx)x).hasSetBlockSize()) {
            builder.setBlockSize(((TableOptionsEx)x).getBlockSize());
        }
        return builder.build();
    }

    private static OtsInternalApi.BloomFilterType toBloomFilterType(BloomFilterType bloomFilterType) {
        switch (bloomFilterType) {
            case NONE: {
                return OtsInternalApi.BloomFilterType.NONE;
            }
            case CELL: {
                return OtsInternalApi.BloomFilterType.CELL;
            }
            case ROW: {
                return OtsInternalApi.BloomFilterType.ROW;
            }
        }
        throw new IllegalArgumentException("Unknown bloom filter type: " + (Object)((Object)bloomFilterType));
    }

    private static OtsInternalApi.ReservedThroughput buildReservedThroughput(ReservedThroughput reservedThroughput) {
        OtsInternalApi.ReservedThroughput.Builder rtBuilder = OtsInternalApi.ReservedThroughput.newBuilder();
        CapacityUnit capacityUnit = reservedThroughput.getCapacityUnit();
        OtsInternalApi.CapacityUnit.Builder builder = OtsInternalApi.CapacityUnit.newBuilder();
        if (capacityUnit.hasSetReadCapacityUnit()) {
            builder.setRead(capacityUnit.getReadCapacityUnit());
        }
        if (capacityUnit.hasSetWriteCapacityUnit()) {
            builder.setWrite(capacityUnit.getWriteCapacityUnit());
        }
        rtBuilder.setCapacityUnit(builder.build());
        return rtBuilder.build();
    }

    public static OtsInternalApi.DeleteTableRequest buildDeleteTableRequest(DeleteTableRequest req) {
        OtsInternalApi.DeleteTableRequest.Builder builder = OtsInternalApi.DeleteTableRequest.newBuilder();
        builder.setTableName(req.getTableName());
        return builder.build();
    }

    public static OtsInternalApi.RowExistenceExpectation toPBRowExistenceExpectation(RowExistenceExpectation rowExistenceExpectation) {
        switch (rowExistenceExpectation) {
            case EXPECT_EXIST: {
                return OtsInternalApi.RowExistenceExpectation.EXPECT_EXIST;
            }
            case EXPECT_NOT_EXIST: {
                return OtsInternalApi.RowExistenceExpectation.EXPECT_NOT_EXIST;
            }
            case IGNORE: {
                return OtsInternalApi.RowExistenceExpectation.IGNORE;
            }
        }
        throw new IllegalArgumentException("Invalid row existence expectation: " + (Object)((Object)rowExistenceExpectation));
    }

    public static OtsInternalApi.Condition buildCondition(Condition cond) {
        OtsInternalApi.Condition.Builder builder = OtsInternalApi.Condition.newBuilder();
        builder.setRowExistence(OTSProtocolBuilder.toPBRowExistenceExpectation(cond.getRowExistenceExpectation()));
        if (cond.getColumnCondition() != null) {
            builder.setColumnCondition(OTSProtocolBuilder.buildFilter(cond.getColumnCondition()));
        }
        return builder.build();
    }

    public static OtsInternalApi.ReturnContent buildReturnContent(ReturnType returnType) {
        OtsInternalApi.ReturnContent.Builder builder = OtsInternalApi.ReturnContent.newBuilder();
        builder.setReturnType(OTSProtocolBuilder.toPBReturnType(returnType));
        return builder.build();
    }

    private static OtsInternalApi.ReturnType toPBReturnType(ReturnType returnType) {
        switch (returnType) {
            case RT_NONE: {
                return OtsInternalApi.ReturnType.RT_NONE;
            }
            case RT_PK: {
                return OtsInternalApi.ReturnType.RT_PK;
            }
        }
        throw new IllegalArgumentException("Invalid return type: " + (Object)((Object)returnType));
    }

    public static OtsInternalApi.DeleteRowRequest buildDeleteRowRequest(RowDeleteChange rowChange) {
        OtsInternalApi.DeleteRowRequest.Builder builder = OtsInternalApi.DeleteRowRequest.newBuilder();
        builder.setTableName(rowChange.getTableName());
        try {
            builder.setPrimaryKey(ByteString.copyFrom((byte[])PlainBufferBuilder.buildRowDeleteChangeWithHeader(rowChange)));
            builder.setCondition(OTSProtocolBuilder.buildCondition(rowChange.getCondition()));
            builder.setReturnContent(OTSProtocolBuilder.buildReturnContent(rowChange.getReturnType()));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize row delete change failed.", e);
        }
        return builder.build();
    }

    public static OtsInternalApi.PutRowRequest buildPutRowRequest(RowPutChange rowChange) {
        OtsInternalApi.PutRowRequest.Builder builder = OtsInternalApi.PutRowRequest.newBuilder();
        builder.setTableName(rowChange.getTableName());
        try {
            builder.setRow(ByteString.copyFrom((byte[])PlainBufferBuilder.buildRowPutChangeWithHeader(rowChange)));
            builder.setCondition(OTSProtocolBuilder.buildCondition(rowChange.getCondition()));
            builder.setReturnContent(OTSProtocolBuilder.buildReturnContent(rowChange.getReturnType()));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize row put change failed.", e);
        }
        return builder.build();
    }

    public static OtsInternalApi.ListTableRequest buildListTableRequest() {
        OtsInternalApi.ListTableRequest.Builder builder = OtsInternalApi.ListTableRequest.newBuilder();
        return builder.build();
    }

    public static OtsInternalApi.DescribeTableRequest buildDescribeTableRequest(DescribeTableRequest req) {
        OtsInternalApi.DescribeTableRequest.Builder builder = OtsInternalApi.DescribeTableRequest.newBuilder();
        builder.setTableName(req.getTableName());
        return builder.build();
    }

    public static OtsInternalApi.UpdateRowRequest buildUpdateRowRequest(RowUpdateChange rowChange) {
        OtsInternalApi.UpdateRowRequest.Builder builder = OtsInternalApi.UpdateRowRequest.newBuilder();
        builder.setTableName(rowChange.getTableName());
        try {
            builder.setRowChange(ByteString.copyFrom((byte[])PlainBufferBuilder.buildRowUpdateChangeWithHeader(rowChange)));
            builder.setCondition(OTSProtocolBuilder.buildCondition(rowChange.getCondition()));
            builder.setReturnContent(OTSProtocolBuilder.buildReturnContent(rowChange.getReturnType()));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize row update change failed.", e);
        }
        return builder.build();
    }

    public static OtsInternalApi.Direction toPBDirection(Direction direction) {
        switch (direction) {
            case BACKWARD: {
                return OtsInternalApi.Direction.BACKWARD;
            }
            case FORWARD: {
                return OtsInternalApi.Direction.FORWARD;
            }
        }
        throw new IllegalArgumentException("Invalid direction type: " + (Object)((Object)direction));
    }

    public static OtsInternalApi.ComputeSplitPointsBySizeRequest buildComputeSplitsBySizeRequest(ComputeSplitsBySizeRequest req) {
        OtsInternalApi.ComputeSplitPointsBySizeRequest.Builder builder = OtsInternalApi.ComputeSplitPointsBySizeRequest.newBuilder();
        builder.setTableName(req.getTableName());
        builder.setSplitSize(req.getSplitSizeIn100MB());
        return builder.build();
    }

    public static OtsInternalApi.GetRangeRequest buildGetRangeRequest(RangeRowQueryCriteria criteria) {
        OtsInternalApi.GetRangeRequest.Builder builder = OtsInternalApi.GetRangeRequest.newBuilder();
        builder.setTableName(criteria.getTableName());
        builder.setDirection(OTSProtocolBuilder.toPBDirection(criteria.getDirection()));
        for (String column : criteria.getColumnsToGet()) {
            builder.addColumnsToGet(column);
        }
        boolean onlyOneVersionInTimeRange = false;
        if (criteria.hasSetTimeRange()) {
            builder.setTimeRange(OTSProtocolBuilder.buildTimeRange(criteria.getTimeRange()));
            onlyOneVersionInTimeRange = criteria.getTimeRange().containsOnlyOneVersion();
        }
        if (criteria.hasSetMaxVersions() && !onlyOneVersionInTimeRange) {
            builder.setMaxVersions(criteria.getMaxVersions());
        }
        if (criteria.getLimit() > 0) {
            builder.setLimit(criteria.getLimit());
        }
        try {
            builder.setInclusiveStartPrimaryKey(ByteString.copyFrom((byte[])PlainBufferBuilder.buildPrimaryKeyWithHeader(criteria.getInclusiveStartPrimaryKey())));
            builder.setExclusiveEndPrimaryKey(ByteString.copyFrom((byte[])PlainBufferBuilder.buildPrimaryKeyWithHeader(criteria.getExclusiveEndPrimaryKey())));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize primary key failed.", e);
        }
        if (criteria.hasSetCacheBlock()) {
            builder.setCacheBlocks(criteria.getCacheBlocks());
        }
        if (criteria.hasSetFilter()) {
            builder.setFilter(OTSProtocolBuilder.buildFilter(criteria.getFilter()));
        }
        if (criteria.hasSetStartColumn()) {
            builder.setStartColumn(criteria.getStartColumn());
        }
        if (criteria.hasSetEndColumn()) {
            builder.setEndColumn(criteria.getEndColumn());
        }
        if (criteria.hasSetToken()) {
            builder.setToken(ByteString.copyFrom((byte[])criteria.getToken()));
        }
        return builder.build();
    }

    public static OtsInternalApi.BatchGetRowRequest buildBatchGetRowRequest(Map<String, MultiRowQueryCriteria> criteriasGroupByTable) {
        OtsInternalApi.BatchGetRowRequest.Builder builder = OtsInternalApi.BatchGetRowRequest.newBuilder();
        for (Map.Entry<String, MultiRowQueryCriteria> entry : criteriasGroupByTable.entrySet()) {
            String tableName = entry.getKey();
            MultiRowQueryCriteria criteria = entry.getValue();
            OtsInternalApi.TableInBatchGetRowRequest.Builder tableBuilder = OtsInternalApi.TableInBatchGetRowRequest.newBuilder();
            tableBuilder.setTableName(tableName);
            if (criteria.getRowKeys().size() != criteria.getTokens().size()) {
                throw new ClientException("The number of primaryKeys and tokens must be the same.");
            }
            for (int i = 0; i < criteria.getRowKeys().size(); ++i) {
                try {
                    tableBuilder.addPrimaryKey(ByteString.copyFrom((byte[])PlainBufferBuilder.buildPrimaryKeyWithHeader(criteria.get(i))));
                    tableBuilder.addToken(ByteString.copyFrom((byte[])criteria.getTokens().get(i)));
                    continue;
                }
                catch (IOException e) {
                    throw new ClientException("Bug: serialize primary key failed.", e);
                }
            }
            for (String column : criteria.getColumnsToGet()) {
                tableBuilder.addColumnsToGet(column);
            }
            boolean onlyOneVersionInTimeRange = false;
            if (criteria.hasSetTimeRange()) {
                tableBuilder.setTimeRange(OTSProtocolBuilder.buildTimeRange(criteria.getTimeRange()));
                onlyOneVersionInTimeRange = criteria.getTimeRange().containsOnlyOneVersion();
            }
            if (criteria.hasSetMaxVersions() && !onlyOneVersionInTimeRange) {
                tableBuilder.setMaxVersions(criteria.getMaxVersions());
            }
            if (criteria.hasSetCacheBlock()) {
                tableBuilder.setCacheBlocks(criteria.getCacheBlocks());
            }
            if (criteria.hasSetFilter()) {
                tableBuilder.setFilter(OTSProtocolBuilder.buildFilter(criteria.getFilter()));
            }
            if (criteria.hasSetStartColumn()) {
                tableBuilder.setStartColumn(criteria.getStartColumn());
            }
            if (criteria.hasSetEndColumn()) {
                tableBuilder.setEndColumn(criteria.getEndColumn());
            }
            builder.addTables(tableBuilder.build());
        }
        return builder.build();
    }

    public static OtsInternalApi.BatchWriteRowRequest buildBatchWriteRowRequest(BatchWriteRowRequest request) {
        OtsInternalApi.BatchWriteRowRequest.Builder builder = OtsInternalApi.BatchWriteRowRequest.newBuilder();
        for (String tableName : request.getRowChange().keySet()) {
            OtsInternalApi.TableInBatchWriteRowRequest.Builder tableBuilder = OtsInternalApi.TableInBatchWriteRowRequest.newBuilder();
            tableBuilder.setTableName(tableName);
            List<RowChange> rowChanges = request.getRowChange().get(tableName);
            if (rowChanges != null && !rowChanges.isEmpty()) {
                for (RowChange rowChange : rowChanges) {
                    try {
                        OtsInternalApi.RowInBatchWriteRowRequest.Builder rowBuilder = OtsInternalApi.RowInBatchWriteRowRequest.newBuilder();
                        if (rowChange instanceof RowPutChange) {
                            rowBuilder.setType(OtsInternalApi.OperationType.PUT);
                            rowBuilder.setRowChange(ByteString.copyFrom((byte[])PlainBufferBuilder.buildRowPutChangeWithHeader((RowPutChange)rowChange)));
                        } else if (rowChange instanceof RowUpdateChange) {
                            rowBuilder.setType(OtsInternalApi.OperationType.UPDATE);
                            rowBuilder.setRowChange(ByteString.copyFrom((byte[])PlainBufferBuilder.buildRowUpdateChangeWithHeader((RowUpdateChange)rowChange)));
                        } else if (rowChange instanceof RowDeleteChange) {
                            rowBuilder.setType(OtsInternalApi.OperationType.DELETE);
                            rowBuilder.setRowChange(ByteString.copyFrom((byte[])PlainBufferBuilder.buildRowDeleteChangeWithHeader((RowDeleteChange)rowChange)));
                        } else {
                            throw new ClientException("Unknown type of rowChange.");
                        }
                        rowBuilder.setCondition(OTSProtocolBuilder.buildCondition(rowChange.getCondition()));
                        rowBuilder.setReturnContent(OTSProtocolBuilder.buildReturnContent(rowChange.getReturnType()));
                        tableBuilder.addRows(rowBuilder.build());
                    }
                    catch (IOException e) {
                        throw new ClientException("Bug: serialize row put change failed.", e);
                    }
                }
            }
            builder.addTables(tableBuilder.build());
        }
        return builder.build();
    }

    public static OtsInternalApi.UpdateTableRequest buildUpdateTableRequest(UpdateTableRequest updateTableRequest) {
        OtsInternalApi.UpdateTableRequest.Builder builder = OtsInternalApi.UpdateTableRequest.newBuilder();
        builder.setTableName(updateTableRequest.getTableName());
        if (updateTableRequest.getReservedThroughputForUpdate() != null) {
            builder.setReservedThroughput(OTSProtocolBuilder.buildReservedThroughput(updateTableRequest.getReservedThroughputForUpdate()));
        }
        if (updateTableRequest.getTableOptionsForUpdate() != null) {
            builder.setTableOptions(OTSProtocolBuilder.buildTableOptions(updateTableRequest.getTableOptionsForUpdate()));
        }
        if (updateTableRequest.getStreamSpecification() != null) {
            builder.setStreamSpec(OTSProtocolBuilder.buildStreamSpecification(updateTableRequest.getStreamSpecification()));
        }
        return builder.build();
    }

    private static OtsInternalApi.StreamSpecification buildStreamSpecification(StreamSpecification streamSpecification) {
        OtsInternalApi.StreamSpecification.Builder builder = OtsInternalApi.StreamSpecification.newBuilder();
        builder.setEnableStream(streamSpecification.isEnableStream());
        if (streamSpecification.getExpirationTime() > 0) {
            builder.setExpirationTime(streamSpecification.getExpirationTime());
        }
        return builder.build();
    }

    public static OtsFilter.LogicalOperator toLogicalOperator(CompositeColumnValueFilter.LogicOperator type) {
        switch (type) {
            case NOT: {
                return OtsFilter.LogicalOperator.LO_NOT;
            }
            case AND: {
                return OtsFilter.LogicalOperator.LO_AND;
            }
            case OR: {
                return OtsFilter.LogicalOperator.LO_OR;
            }
        }
        throw new IllegalArgumentException("Unknown logic operation type: " + (Object)((Object)type));
    }

    public static OtsFilter.Filter toFilter(ColumnCondition f) {
        OtsFilter.Filter.Builder builder = OtsFilter.Filter.newBuilder();
        builder.setType(OTSProtocolBuilder.toFilterType(f.getConditionType()));
        builder.setFilter(f.serialize());
        return builder.build();
    }

    public static OtsFilter.Filter toFilter(Filter f) {
        OtsFilter.Filter.Builder builder = OtsFilter.Filter.newBuilder();
        builder.setType(OTSProtocolBuilder.toFilterType(f.getFilterType()));
        builder.setFilter(f.serialize());
        return builder.build();
    }

    public static OtsFilter.FilterType toFilterType(ColumnConditionType type) {
        switch (type) {
            case COMPOSITE_COLUMN_VALUE_CONDITION: {
                return OtsFilter.FilterType.FT_COMPOSITE_COLUMN_VALUE;
            }
            case SINGLE_COLUMN_VALUE_CONDITION: {
                return OtsFilter.FilterType.FT_SINGLE_COLUMN_VALUE;
            }
        }
        throw new IllegalArgumentException("Unknown filter type: " + (Object)((Object)type));
    }

    public static OtsFilter.FilterType toFilterType(FilterType type) {
        switch (type) {
            case COMPOSITE_COLUMN_VALUE_FILTER: {
                return OtsFilter.FilterType.FT_COMPOSITE_COLUMN_VALUE;
            }
            case SINGLE_COLUMN_VALUE_FILTER: {
                return OtsFilter.FilterType.FT_SINGLE_COLUMN_VALUE;
            }
            case COLUMN_PAGINATION_FILTER: {
                return OtsFilter.FilterType.FT_COLUMN_PAGINATION;
            }
        }
        throw new IllegalArgumentException("Unknown filter type: " + (Object)((Object)type));
    }

    public static ByteString buildFilter(ColumnCondition filter) {
        return OTSProtocolBuilder.toFilter(filter).toByteString();
    }

    public static ByteString buildFilter(Filter filter) {
        return OTSProtocolBuilder.toFilter(filter).toByteString();
    }

    public static ByteString buildCompositeColumnValueFilter(CompositeColumnValueFilter filter) {
        OtsFilter.CompositeColumnValueFilter.Builder builder = OtsFilter.CompositeColumnValueFilter.newBuilder();
        builder.setCombinator(OTSProtocolBuilder.toLogicalOperator(filter.getOperationType()));
        for (Filter filter2 : filter.getSubFilters()) {
            builder.addSubFilters(OTSProtocolBuilder.toFilter(filter2));
        }
        return builder.build().toByteString();
    }

    public static ByteString buildSingleColumnValueFilter(SingleColumnValueFilter filter) {
        OtsFilter.SingleColumnValueFilter.Builder builder = OtsFilter.SingleColumnValueFilter.newBuilder();
        builder.setColumnName(filter.getColumnName());
        builder.setComparator(OTSProtocolBuilder.toComparatorType(filter.getOperator()));
        try {
            builder.setColumnValue(ByteString.copyFrom((byte[])PlainBufferBuilder.buildColumnValueWithoutLengthPrefix(filter.getColumnValue())));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize column value failed.", e);
        }
        builder.setFilterIfMissing(!filter.isPassIfMissing());
        builder.setLatestVersionOnly(filter.isLatestVersionsOnly());
        return builder.build().toByteString();
    }

    private static OtsFilter.ComparatorType toComparatorType(SingleColumnValueFilter.CompareOperator operator) {
        switch (operator) {
            case EQUAL: {
                return OtsFilter.ComparatorType.CT_EQUAL;
            }
            case NOT_EQUAL: {
                return OtsFilter.ComparatorType.CT_NOT_EQUAL;
            }
            case GREATER_THAN: {
                return OtsFilter.ComparatorType.CT_GREATER_THAN;
            }
            case GREATER_EQUAL: {
                return OtsFilter.ComparatorType.CT_GREATER_EQUAL;
            }
            case LESS_THAN: {
                return OtsFilter.ComparatorType.CT_LESS_THAN;
            }
            case LESS_EQUAL: {
                return OtsFilter.ComparatorType.CT_LESS_EQUAL;
            }
        }
        throw new IllegalArgumentException("Unknown compare operator: " + (Object)((Object)operator));
    }

    public static ByteString buildColumnPaginationFilter(ColumnPaginationFilter filter) {
        OtsFilter.ColumnPaginationFilter.Builder builder = OtsFilter.ColumnPaginationFilter.newBuilder();
        builder.setLimit(filter.getLimit());
        builder.setOffset(filter.getOffset());
        return builder.build().toByteString();
    }

    public static Message buildListStreamRequest(ListStreamRequest request) {
        OtsInternalApi.ListStreamRequest.Builder builder = OtsInternalApi.ListStreamRequest.newBuilder();
        if (request.getTableName() != null) {
            builder.setTableName(request.getTableName());
        }
        return builder.build();
    }

    public static OtsInternalApi.DescribeStreamRequest buildDescribeStreamRequest(DescribeStreamRequest request) {
        OtsInternalApi.DescribeStreamRequest.Builder builder = OtsInternalApi.DescribeStreamRequest.newBuilder();
        builder.setStreamId(request.getStreamId());
        if (request.getInclusiveStartShardId() != null) {
            builder.setInclusiveStartShardId(request.getInclusiveStartShardId());
        }
        if (request.getShardLimit() > 0) {
            builder.setShardLimit(request.getShardLimit());
        }
        return builder.build();
    }

    public static OtsInternalApi.GetShardIteratorRequest buildGetShardIteratorRequest(GetShardIteratorRequest request) {
        OtsInternalApi.GetShardIteratorRequest.Builder builder = OtsInternalApi.GetShardIteratorRequest.newBuilder();
        builder.setStreamId(request.getStreamId());
        builder.setShardId(request.getShardId());
        return builder.build();
    }

    public static OtsInternalApi.GetStreamRecordRequest buildGetStreamRecordRequest(GetStreamRecordRequest request) {
        OtsInternalApi.GetStreamRecordRequest.Builder builder = OtsInternalApi.GetStreamRecordRequest.newBuilder();
        builder.setShardIterator(request.getShardIterator());
        if (request.getLimit() > 0) {
            builder.setLimit(request.getLimit());
        }
        return builder.build();
    }
}

