/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model.condition;

import com.aliyun.openservices.ots.model.ColumnValue;
import com.aliyun.openservices.ots.model.condition.ColumnCondition;
import com.aliyun.openservices.ots.model.condition.ColumnConditionBuilder;
import com.aliyun.openservices.ots.model.condition.ColumnConditionType;
import com.google.protobuf.ByteString;

public class RelationalCondition
implements ColumnCondition {
    private CompareOperator operator;
    private String columnName;
    private ColumnValue columnValue;
    private boolean passIfMissing = true;

    public RelationalCondition(String columnName, CompareOperator operator, ColumnValue columnValue) {
        this.setColumnName(columnName);
        this.setOperator(operator);
        this.setColumnValue(columnValue);
    }

    public CompareOperator getOperator() {
        return this.operator;
    }

    public RelationalCondition setOperator(CompareOperator operator) {
        this.operator = operator;
        return this;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public RelationalCondition setColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    public ColumnValue getColumnValue() {
        return this.columnValue;
    }

    public RelationalCondition setColumnValue(ColumnValue columnValue) {
        this.columnValue = columnValue;
        return this;
    }

    public boolean isPassIfMissing() {
        return this.passIfMissing;
    }

    public RelationalCondition setPassIfMissing(boolean passIfMissing) {
        this.passIfMissing = passIfMissing;
        return this;
    }

    @Override
    public ColumnConditionType getType() {
        return ColumnConditionType.RELATIONAL_CONDITION;
    }

    @Override
    public ByteString serialize() {
        return ColumnConditionBuilder.buildRelationalCondition(this);
    }

    public static enum CompareOperator {
        EQUAL,
        NOT_EQUAL,
        GREATER_THAN,
        GREATER_EQUAL,
        LESS_THAN,
        LESS_EQUAL;

    }
}

