/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model.condition;

import com.aliyun.openservices.ots.model.condition.ColumnCondition;
import com.aliyun.openservices.ots.model.condition.ColumnConditionBuilder;
import com.aliyun.openservices.ots.model.condition.ColumnConditionType;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;

public class CompositeCondition
implements ColumnCondition {
    private LogicOperator type;
    private List<ColumnCondition> subConditions;

    public CompositeCondition(LogicOperator loType) {
        this.type = loType;
        this.subConditions = new ArrayList<ColumnCondition>();
    }

    public CompositeCondition addCondition(ColumnCondition condition) {
        this.subConditions.add(condition);
        return this;
    }

    public void clear() {
        this.subConditions.clear();
    }

    public LogicOperator getOperationType() {
        return this.type;
    }

    public List<ColumnCondition> getSubConditions() {
        return this.subConditions;
    }

    @Override
    public ColumnConditionType getType() {
        return ColumnConditionType.COMPOSITE_CONDITION;
    }

    @Override
    public ByteString serialize() {
        return ColumnConditionBuilder.buildCompositeCondition(this);
    }

    public static enum LogicOperator {
        NOT,
        AND,
        OR;

    }
}

