/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.writer;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.OTSAsync;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.internal.OTSCallback;
import com.aliyun.openservices.ots.model.BatchWriteRowRequest;
import com.aliyun.openservices.ots.model.BatchWriteRowResult;
import com.aliyun.openservices.ots.model.ConsumedCapacity;
import com.aliyun.openservices.ots.model.DeleteRowRequest;
import com.aliyun.openservices.ots.model.DeleteRowResult;
import com.aliyun.openservices.ots.model.Error;
import com.aliyun.openservices.ots.model.OTSContext;
import com.aliyun.openservices.ots.model.PutRowRequest;
import com.aliyun.openservices.ots.model.PutRowResult;
import com.aliyun.openservices.ots.model.RowChange;
import com.aliyun.openservices.ots.model.RowDeleteChange;
import com.aliyun.openservices.ots.model.RowPutChange;
import com.aliyun.openservices.ots.model.RowUpdateChange;
import com.aliyun.openservices.ots.model.UpdateRowRequest;
import com.aliyun.openservices.ots.model.UpdateRowResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlushCallback<Req, Res>
implements OTSCallback<Req, Res> {
    private Logger logger = LoggerFactory.getLogger(FlushCallback.class);
    private OTSAsync ots;
    private AtomicInteger count;
    private Semaphore semaphore;
    private long startTime;
    private OTSCallback<RowChange, ConsumedCapacity> callback;
    private Executor executor;

    public FlushCallback(OTSAsync ots, AtomicInteger count, Semaphore semaphore, OTSCallback<RowChange, ConsumedCapacity> callback, Executor executor) {
        this.ots = ots;
        this.count = count;
        this.semaphore = semaphore;
        this.startTime = System.currentTimeMillis();
        this.callback = callback;
        this.executor = executor;
    }

    private void triggerSucceedCallback(final RowChange rowChange, final ConsumedCapacity consumedCapacity) {
        if (this.callback == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                FlushCallback.this.callback.onCompleted(new OTSContext<RowChange, ConsumedCapacity>(rowChange, consumedCapacity));
            }
        });
    }

    private void triggerFailedCallback(final RowChange rowChange, final Exception exp) {
        if (this.callback == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (exp instanceof OTSException) {
                    FlushCallback.this.callback.onFailed(new OTSContext<RowChange, Object>(rowChange, null), (OTSException)exp);
                } else {
                    FlushCallback.this.callback.onFailed(new OTSContext<RowChange, Object>(rowChange, null), (ClientException)exp);
                }
            }
        });
    }

    private void triggerFailedCallback(final List<RowChange> rowChanges, final Exception exp) {
        if (this.callback == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (RowChange rowChange : rowChanges) {
                    if (exp instanceof OTSException) {
                        FlushCallback.this.callback.onFailed(new OTSContext<RowChange, Object>(rowChange, null), (OTSException)exp);
                        continue;
                    }
                    FlushCallback.this.callback.onFailed(new OTSContext<RowChange, Object>(rowChange, null), (ClientException)exp);
                }
            }
        });
    }

    private void requestComplete() {
        int remain = this.count.decrementAndGet();
        if (remain == 0) {
            this.semaphore.release();
            this.logger.debug("Release semaphore.");
        }
        long endTime = System.currentTimeMillis();
        this.logger.debug("BatchWriteRow latency: {}", (Object)(endTime - this.startTime));
    }

    public void onCompleted(BatchWriteRowRequest originRequest, BatchWriteRowResult result) {
        Error error;
        ArrayList<BatchWriteRowResult.RowStatus> succeed = new ArrayList<BatchWriteRowResult.RowStatus>();
        ArrayList<BatchWriteRowResult.RowStatus> failed = new ArrayList<BatchWriteRowResult.RowStatus>();
        result.getResultOfPut(succeed, failed);
        for (BatchWriteRowResult.RowStatus status : succeed) {
            this.triggerSucceedCallback(originRequest.getRowPutChange(status.getTableName(), status.getIndex()), status.getConsumedCapacity());
        }
        for (BatchWriteRowResult.RowStatus status : failed) {
            error = status.getError();
            this.triggerFailedCallback(originRequest.getRowPutChange(status.getTableName(), status.getIndex()), (Exception)new OTSException(error.getMessage(), error.getCode(), result.getRequestID()));
        }
        succeed.clear();
        failed.clear();
        result.getResultOfUpdate(succeed, failed);
        for (BatchWriteRowResult.RowStatus status : succeed) {
            this.triggerSucceedCallback(originRequest.getRowUpdateChange(status.getTableName(), status.getIndex()), status.getConsumedCapacity());
        }
        for (BatchWriteRowResult.RowStatus status : failed) {
            error = status.getError();
            this.triggerFailedCallback(originRequest.getRowUpdateChange(status.getTableName(), status.getIndex()), (Exception)new OTSException(error.getMessage(), error.getCode(), result.getRequestID()));
        }
        succeed.clear();
        failed.clear();
        result.getResultOfDelete(succeed, failed);
        for (BatchWriteRowResult.RowStatus status : succeed) {
            this.triggerSucceedCallback(originRequest.getRowDeleteChange(status.getTableName(), status.getIndex()), status.getConsumedCapacity());
        }
        for (BatchWriteRowResult.RowStatus status : failed) {
            error = status.getError();
            this.triggerFailedCallback(originRequest.getRowDeleteChange(status.getTableName(), status.getIndex()), (Exception)new OTSException(error.getMessage(), error.getCode(), result.getRequestID()));
        }
    }

    @Override
    public void onCompleted(OTSContext<Req, Res> otsContext) {
        Req request = otsContext.getOTSRequest();
        Res response = otsContext.getOTSResult();
        this.logger.debug("OnComplete: {}", (Object)request.getClass().getName());
        if (request instanceof BatchWriteRowRequest) {
            this.onCompleted((BatchWriteRowRequest)request, (BatchWriteRowResult)response);
        } else if (request instanceof PutRowRequest) {
            PutRowRequest pr = (PutRowRequest)request;
            this.triggerSucceedCallback(pr.getRowChange(), ((PutRowResult)response).getConsumedCapacity());
        } else if (request instanceof UpdateRowRequest) {
            UpdateRowRequest ur = (UpdateRowRequest)request;
            this.triggerSucceedCallback(ur.getRowChange(), ((UpdateRowResult)response).getConsumedCapacity());
        } else if (request instanceof DeleteRowRequest) {
            DeleteRowRequest dr = (DeleteRowRequest)request;
            this.triggerSucceedCallback(dr.getRowChange(), ((DeleteRowResult)response).getConsumedCapacity());
        }
        this.requestComplete();
    }

    @Override
    public void onFailed(OTSContext<Req, Res> otsContext, OTSException ex) {
        Req request = otsContext.getOTSRequest();
        this.logger.debug("OnFailed on OTSException: {}, {}", (Object)request.getClass().getName(), (Object)ex);
        if (request instanceof BatchWriteRowRequest) {
            this.retryBatchWrite((BatchWriteRowRequest)request);
        } else if (request instanceof PutRowRequest) {
            PutRowRequest pr = (PutRowRequest)request;
            this.triggerFailedCallback(pr.getRowChange(), (Exception)ex);
        } else if (request instanceof UpdateRowRequest) {
            UpdateRowRequest ur = (UpdateRowRequest)request;
            this.triggerFailedCallback(ur.getRowChange(), (Exception)ex);
        } else if (request instanceof DeleteRowRequest) {
            DeleteRowRequest dr = (DeleteRowRequest)request;
            this.triggerFailedCallback(dr.getRowChange(), (Exception)ex);
        }
        this.requestComplete();
    }

    private void retryBatchWrite(BatchWriteRowRequest request) {
        for (Map.Entry<String, List<RowPutChange>> entry : request.getRowPutChange().entrySet()) {
            this.count.addAndGet(entry.getValue().size());
            for (RowPutChange rowPutChange : entry.getValue()) {
                PutRowRequest pr = new PutRowRequest();
                pr.setRowChange(rowPutChange);
                this.ots.putRow(pr, new FlushCallback<PutRowRequest, PutRowResult>(this.ots, this.count, this.semaphore, this.callback, this.executor));
            }
        }
        for (Map.Entry<String, List<RowChange>> entry : request.getRowUpdateChange().entrySet()) {
            this.count.addAndGet(entry.getValue().size());
            for (RowUpdateChange rowUpdateChange : entry.getValue()) {
                UpdateRowRequest ur = new UpdateRowRequest();
                ur.setRowChange(rowUpdateChange);
                this.ots.updateRow(ur, new FlushCallback<UpdateRowRequest, UpdateRowResult>(this.ots, this.count, this.semaphore, this.callback, this.executor));
            }
        }
        for (Map.Entry<String, List<RowChange>> entry : request.getRowDeleteChange().entrySet()) {
            this.count.addAndGet(entry.getValue().size());
            for (RowDeleteChange rowDeleteChange : entry.getValue()) {
                DeleteRowRequest dr = new DeleteRowRequest();
                dr.setRowChange(rowDeleteChange);
                this.ots.deleteRow(dr, new FlushCallback<DeleteRowRequest, DeleteRowResult>(this.ots, this.count, this.semaphore, this.callback, this.executor));
            }
        }
    }

    @Override
    public void onFailed(OTSContext<Req, Res> otsContext, ClientException ex) {
        Req request = otsContext.getOTSRequest();
        this.logger.debug("OnFailed on ClientException: {}, {}", (Object)request.getClass().getName(), (Object)ex);
        ArrayList<RowChange> failedRows = new ArrayList<RowChange>();
        if (request instanceof BatchWriteRowRequest) {
            BatchWriteRowRequest bwr = (BatchWriteRowRequest)request;
            for (Map.Entry<String, List<RowPutChange>> entry : bwr.getRowPutChange().entrySet()) {
                for (RowPutChange rowPutChange : entry.getValue()) {
                    failedRows.add(rowPutChange);
                }
            }
            for (Map.Entry<String, List<RowChange>> entry : bwr.getRowUpdateChange().entrySet()) {
                for (RowUpdateChange rowUpdateChange : entry.getValue()) {
                    failedRows.add(rowUpdateChange);
                }
            }
            for (Map.Entry<String, List<RowChange>> entry : bwr.getRowDeleteChange().entrySet()) {
                for (RowDeleteChange rowDeleteChange : entry.getValue()) {
                    failedRows.add(rowDeleteChange);
                }
            }
        } else if (request instanceof PutRowRequest) {
            PutRowRequest pr = (PutRowRequest)request;
            failedRows.add(pr.getRowChange());
        } else if (request instanceof UpdateRowRequest) {
            UpdateRowRequest ur = (UpdateRowRequest)request;
            failedRows.add(ur.getRowChange());
        } else if (request instanceof DeleteRowRequest) {
            DeleteRowRequest dr = (DeleteRowRequest)request;
            failedRows.add(dr.getRowChange());
        }
        this.triggerFailedCallback(failedRows, (Exception)ex);
        this.requestComplete();
    }
}

