/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.OTSServiceConfiguration;
import com.aliyun.openservices.ots.auth.ServiceCredentials;
import com.aliyun.openservices.ots.comm.OTSUri;
import com.aliyun.openservices.ots.comm.ServiceClient;
import com.aliyun.openservices.ots.internal.CreateTableAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.DeleteTableAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.DescribeTableAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.ListTableAsyncResponseConsumer;
import com.aliyun.openservices.ots.internal.OTSExecutionContext;
import com.aliyun.openservices.ots.internal.OTSOperation;
import com.aliyun.openservices.ots.internal.OTSResultParserFactory;
import com.aliyun.openservices.ots.internal.UpdateTableAsyncResponseConsumer;
import com.aliyun.openservices.ots.log.LogUtil;
import com.aliyun.openservices.ots.model.CreateTableRequest;
import com.aliyun.openservices.ots.model.CreateTableResult;
import com.aliyun.openservices.ots.model.DeleteTableRequest;
import com.aliyun.openservices.ots.model.DeleteTableResult;
import com.aliyun.openservices.ots.model.DescribeTableRequest;
import com.aliyun.openservices.ots.model.DescribeTableResult;
import com.aliyun.openservices.ots.model.ListTableRequest;
import com.aliyun.openservices.ots.model.ListTableResult;
import com.aliyun.openservices.ots.model.OTSProtocolHelper;
import com.aliyun.openservices.ots.model.UpdateTableRequest;
import com.aliyun.openservices.ots.model.UpdateTableResult;
import com.aliyun.openservices.ots.protocol.OtsProtocol2;
import com.google.protobuf.Message;

public class OTSAsyncTableOperation
extends OTSOperation {
    private OTSUri URI_CREATE_TABLE;
    private OTSUri URI_LIST_TABLE;
    private OTSUri URI_DELETE_TABLE;
    private OTSUri URI_DESCRIBE_TABLE;
    private OTSUri URI_UPDATE_TABLE;

    public OTSAsyncTableOperation(String endpoint, String instanceName, ServiceClient client, ServiceCredentials credentials, OTSServiceConfiguration serviceConfig) {
        super(instanceName, client, credentials, serviceConfig);
        this.URI_CREATE_TABLE = new OTSUri(endpoint, "CreateTable");
        this.URI_LIST_TABLE = new OTSUri(endpoint, "ListTable");
        this.URI_DELETE_TABLE = new OTSUri(endpoint, "DeleteTable");
        this.URI_DESCRIBE_TABLE = new OTSUri(endpoint, "DescribeTable");
        this.URI_UPDATE_TABLE = new OTSUri(endpoint, "UpdateTable");
    }

    public void createTable(OTSExecutionContext<CreateTableRequest, CreateTableResult> executionContext) {
        LogUtil.logBeforeExecution(executionContext);
        this.asyncInvokePost(this.URI_CREATE_TABLE, null, (Message)OTSProtocolHelper.buildCreateTableRequest(executionContext.getRequest()), executionContext.getTraceLogger(), new CreateTableAsyncResponseConsumer(OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.CreateTableResponse.getDefaultInstance(), executionContext.getTraceLogger().getTraceId()), executionContext.getTraceLogger()), executionContext.getAsyncClientCallback());
    }

    public void listTable(OTSExecutionContext<ListTableRequest, ListTableResult> executionContext) {
        LogUtil.logBeforeExecution(executionContext);
        this.asyncInvokePost(this.URI_LIST_TABLE, null, (Message)OTSProtocolHelper.buildListTableRequest(), executionContext.getTraceLogger(), new ListTableAsyncResponseConsumer(OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.ListTableResponse.getDefaultInstance(), executionContext.getTraceLogger().getTraceId()), executionContext.getTraceLogger()), executionContext.getAsyncClientCallback());
    }

    public void deleteTable(OTSExecutionContext<DeleteTableRequest, DeleteTableResult> executionContext) {
        LogUtil.logBeforeExecution(executionContext);
        this.asyncInvokePost(this.URI_DELETE_TABLE, null, (Message)OTSProtocolHelper.buildDeleteTableRequest(executionContext.getRequest().getTableName()), executionContext.getTraceLogger(), new DeleteTableAsyncResponseConsumer(OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.DeleteTableResponse.getDefaultInstance(), executionContext.getTraceLogger().getTraceId()), executionContext.getTraceLogger()), executionContext.getAsyncClientCallback());
    }

    public void describeTable(OTSExecutionContext<DescribeTableRequest, DescribeTableResult> executionContext) {
        LogUtil.logBeforeExecution(executionContext);
        this.asyncInvokePost(this.URI_DESCRIBE_TABLE, null, (Message)OTSProtocolHelper.buildDescribeTableRequest(executionContext.getRequest().getTableName()), executionContext.getTraceLogger(), new DescribeTableAsyncResponseConsumer(OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.DescribeTableResponse.getDefaultInstance(), executionContext.getTraceLogger().getTraceId()), executionContext.getTraceLogger()), executionContext.getAsyncClientCallback());
    }

    public void updateTable(OTSExecutionContext<UpdateTableRequest, UpdateTableResult> executionContext) {
        LogUtil.logBeforeExecution(executionContext);
        this.asyncInvokePost(this.URI_UPDATE_TABLE, null, (Message)OTSProtocolHelper.buildUpdateTableRequest(executionContext.getRequest()), executionContext.getTraceLogger(), new UpdateTableAsyncResponseConsumer(OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol2.UpdateTableResponse.getDefaultInstance(), executionContext.getTraceLogger().getTraceId()), executionContext.getTraceLogger()), executionContext.getAsyncClientCallback());
    }
}

