/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageAccessor;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ONSUtil {
    private static final Set<String> RESERVED_KEY_SET_RMQ = new HashSet<String>();
    private static final Set<String> RESERVED_KEY_SET_ONS = new HashSet<String>();

    public static com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message msgConvert(Message message) {
        Properties userProperties;
        Properties systemProperties;
        com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message msgRMQ = new com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message();
        if (message == null) {
            throw new ONSClientException("'message' is null");
        }
        if (message.getTopic() != null) {
            msgRMQ.setTopic(message.getTopic());
        }
        if (message.getKey() != null) {
            msgRMQ.setKeys(message.getKey());
        }
        if (message.getTag() != null) {
            msgRMQ.setTags(message.getTag());
        }
        if (message.getStartDeliverTime() > 0L) {
            msgRMQ.putUserProperty("__STARTDELIVERTIME", String.valueOf(message.getStartDeliverTime()));
        }
        if (message.getBody() != null) {
            msgRMQ.setBody(message.getBody());
        }
        if (message.getShardingKey() != null && !message.getShardingKey().isEmpty()) {
            msgRMQ.putUserProperty("__SHARDINGKEY", message.getShardingKey());
        }
        if ((systemProperties = MessageAccessor.getSystemProperties(message)) != null) {
            for (Map.Entry<Object, Object> next : systemProperties.entrySet()) {
                if (RESERVED_KEY_SET_ONS.contains(next.getKey().toString())) continue;
                com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor.putProperty(msgRMQ, next.getKey().toString(), next.getValue().toString());
            }
        }
        if ((userProperties = message.getUserProperties()) != null) {
            for (Map.Entry<Object, Object> next : userProperties.entrySet()) {
                if (RESERVED_KEY_SET_RMQ.contains(next.getKey().toString())) continue;
                com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor.putProperty(msgRMQ, next.getKey().toString(), next.getValue().toString());
            }
        }
        return msgRMQ;
    }

    public static Message msgConvert(com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message msgRMQ) {
        Message message = new Message();
        if (msgRMQ.getTopic() != null) {
            message.setTopic(msgRMQ.getTopic());
        }
        if (msgRMQ.getKeys() != null) {
            message.setKey(msgRMQ.getKeys());
        }
        if (msgRMQ.getTags() != null) {
            message.setTag(msgRMQ.getTags());
        }
        if (msgRMQ.getBody() != null) {
            message.setBody(msgRMQ.getBody());
        }
        if (((MessageExt)msgRMQ).getBrokerName() != null) {
            String partition = ((MessageExt)msgRMQ).getBrokerName() + "#" + ((MessageExt)msgRMQ).getQueueId();
            MessageAccessor.putSystemProperties(message, "__PARTITION", partition);
        }
        MessageAccessor.putSystemProperties(message, "__CONSUMEOFFSET", String.valueOf(((MessageExt)msgRMQ).getQueueOffset()));
        message.setReconsumeTimes(((MessageExt)msgRMQ).getReconsumeTimes());
        message.setBornTimestamp(((MessageExt)msgRMQ).getBornTimestamp());
        message.setBornHost(String.valueOf(((MessageExt)msgRMQ).getBornHost()));
        Map<String, String> properties = msgRMQ.getProperties();
        if (properties != null) {
            for (Map.Entry<String, String> next : properties.entrySet()) {
                if (RESERVED_KEY_SET_RMQ.contains(next.getKey()) || RESERVED_KEY_SET_ONS.contains(next.getKey())) {
                    MessageAccessor.putSystemProperties(message, next.getKey(), next.getValue());
                    continue;
                }
                message.putUserProperties(next.getKey(), next.getValue());
            }
        }
        return message;
    }

    public static Properties extractProperties(Properties properties) {
        Properties newPro = new Properties();
        Properties inner = null;
        try {
            Field field = Properties.class.getDeclaredField("defaults");
            field.setAccessible(true);
            inner = (Properties)field.get(properties);
        }
        catch (Exception field) {
            // empty catch block
        }
        if (inner != null) {
            for (Map.Entry<Object, Object> entry : inner.entrySet()) {
                newPro.setProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            newPro.setProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return newPro;
    }

    static {
        RESERVED_KEY_SET_RMQ.add("KEYS");
        RESERVED_KEY_SET_RMQ.add("TAGS");
        RESERVED_KEY_SET_RMQ.add("WAIT");
        RESERVED_KEY_SET_RMQ.add("DELAY");
        RESERVED_KEY_SET_RMQ.add("RETRY_TOPIC");
        RESERVED_KEY_SET_RMQ.add("REAL_TOPIC");
        RESERVED_KEY_SET_RMQ.add("REAL_QID");
        RESERVED_KEY_SET_RMQ.add("TRAN_MSG");
        RESERVED_KEY_SET_RMQ.add("PGROUP");
        RESERVED_KEY_SET_RMQ.add("MIN_OFFSET");
        RESERVED_KEY_SET_RMQ.add("MAX_OFFSET");
        RESERVED_KEY_SET_ONS.add("__TAG");
        RESERVED_KEY_SET_ONS.add("__KEY");
        RESERVED_KEY_SET_ONS.add("__MSGID");
        RESERVED_KEY_SET_ONS.add("__RECONSUMETIMES");
        RESERVED_KEY_SET_ONS.add("__STARTDELIVERTIME");
        RESERVED_KEY_SET_ONS.add("__BORNHOST");
        RESERVED_KEY_SET_ONS.add("__BORNTIMESTAMP");
        RESERVED_KEY_SET_ONS.add("__SHARDINGKEY");
    }
}

