/*
 * Copyright 2015 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package com.aliyun.openservices.shade.io.netty.channel.unix;

/**
 * Different modes of reading from a {@link DomainSocketChannel}.
 */
public enum DomainSocketReadMode {

    /**
     * Read (@link ByteBuf)s from the {@link DomainSocketChannel}.
     */
    BYTES,

    /**
     * Read (@link FileDscriptor)s from the {@link DomainSocketChannel}.
     */
    FILE_DESCRIPTORS
}
