/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.ChannelEventListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.InvokeCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RemotingClient;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.Pair;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingSendRequestException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyClientConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyDecoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyEncoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyEvent;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyEventType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingAbstract;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRequestProcessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.io.netty.bootstrap.Bootstrap;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelDuplexHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelInitializer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.channel.SimpleChannelInboundHandler;
import com.aliyun.openservices.shade.io.netty.channel.nio.NioEventLoopGroup;
import com.aliyun.openservices.shade.io.netty.channel.socket.SocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.NioSocketChannel;
import com.aliyun.openservices.shade.io.netty.handler.timeout.IdleState;
import com.aliyun.openservices.shade.io.netty.handler.timeout.IdleStateEvent;
import com.aliyun.openservices.shade.io.netty.handler.timeout.IdleStateHandler;
import com.aliyun.openservices.shade.io.netty.util.concurrent.DefaultEventExecutorGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRemotingClient
extends NettyRemotingAbstract
implements RemotingClient {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqRemoting");
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private final NettyClientConfig nettyClientConfig;
    private final Bootstrap bootstrap = new Bootstrap();
    private final EventLoopGroup eventLoopGroupWorker;
    private final Lock lockChannelTables = new ReentrantLock();
    private final ConcurrentHashMap<String, ChannelWrapper> channelTables = new ConcurrentHashMap();
    private final Timer timer = new Timer("ClientHouseKeepingService", true);
    private final AtomicReference<List<String>> namesrvAddrList = new AtomicReference();
    private final AtomicReference<String> namesrvAddrChoosed = new AtomicReference();
    private final AtomicInteger namesrvIndex = new AtomicInteger(NettyRemotingClient.initValueIndex());
    private final Lock lockNamesrvChannel = new ReentrantLock();
    private final ExecutorService publicExecutor;
    private final ChannelEventListener channelEventListener;
    private DefaultEventExecutorGroup defaultEventExecutorGroup;
    private RPCHook rpcHook;

    public NettyRemotingClient(NettyClientConfig nettyClientConfig) {
        this(nettyClientConfig, null);
    }

    public NettyRemotingClient(NettyClientConfig nettyClientConfig, ChannelEventListener channelEventListener) {
        super(nettyClientConfig.getClientOnewaySemaphoreValue(), nettyClientConfig.getClientAsyncSemaphoreValue());
        this.nettyClientConfig = nettyClientConfig;
        this.channelEventListener = channelEventListener;
        int publicThreadNums = nettyClientConfig.getClientCallbackExecutorThreads();
        if (publicThreadNums <= 0) {
            publicThreadNums = 4;
        }
        this.publicExecutor = Executors.newFixedThreadPool(publicThreadNums, new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyClientPublicExecutor_" + this.threadIndex.incrementAndGet());
            }
        });
        this.eventLoopGroupWorker = new NioEventLoopGroup(1, new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.format("NettyClientSelector_%d", this.threadIndex.incrementAndGet()));
            }
        });
    }

    private static int initValueIndex() {
        Random r = new Random();
        return Math.abs(r.nextInt() % 999) % 999;
    }

    @Override
    public void start() {
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyClientConfig.getClientWorkerThreads(), new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyClientWorkerThread_" + this.threadIndex.incrementAndGet());
            }
        });
        Bootstrap handler = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroupWorker)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_KEEPALIVE, false)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.nettyClientConfig.getConnectTimeoutMillis())).option(ChannelOption.SO_SNDBUF, this.nettyClientConfig.getClientSocketSndBufSize())).option(ChannelOption.SO_RCVBUF, this.nettyClientConfig.getClientSocketRcvBufSize())).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast((EventExecutorGroup)NettyRemotingClient.this.defaultEventExecutorGroup, new NettyEncoder(), new NettyDecoder(), new IdleStateHandler(0, 0, NettyRemotingClient.this.nettyClientConfig.getClientChannelMaxIdleTimeSeconds()), new NettyConnectManageHandler(), new NettyClientHandler());
            }
        });
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    NettyRemotingClient.this.scanResponseTable();
                }
                catch (Exception e) {
                    log.error("scanResponseTable exception", (Throwable)e);
                }
            }
        }, 3000L, 1000L);
        if (this.channelEventListener != null) {
            this.nettyEventExecuter.start();
        }
    }

    @Override
    public void shutdown() {
        try {
            this.timer.cancel();
            for (ChannelWrapper cw : this.channelTables.values()) {
                this.closeChannel(null, cw.getChannel());
            }
            this.channelTables.clear();
            this.eventLoopGroupWorker.shutdownGracefully();
            if (this.nettyEventExecuter != null) {
                this.nettyEventExecuter.shutdown();
            }
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.error("NettyRemotingClient shutdown exception, ", (Throwable)e);
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
            }
            catch (Exception e) {
                log.error("NettyRemotingServer shutdown exception, ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(String addr, Channel channel) {
        block13: {
            if (null == channel) {
                return;
            }
            String addrRemote = null == addr ? RemotingHelper.parseChannelRemoteAddr(channel) : addr;
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = this.channelTables.get(addrRemote);
                        log.info("closeChannel: begin close the channel[{}] Found: {}", (Object)addrRemote, (Object)(prevCW != null ? 1 : 0));
                        if (null == prevCW) {
                            log.info("closeChannel: the channel[{}] has been removed from the channel table before", (Object)addrRemote);
                            removeItemFromTable = false;
                        } else if (prevCW.getChannel() != channel) {
                            log.info("closeChannel: the channel[{}] has been closed before, and has been created again, nothing to do.", (Object)addrRemote);
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            this.channelTables.remove(addrRemote);
                            log.info("closeChannel: the channel[{}] was removed from channel table", (Object)addrRemote);
                        }
                        RemotingUtil.closeChannel(channel);
                        break block13;
                    }
                    catch (Exception e) {
                        log.error("closeChannel: close the channel exception", (Throwable)e);
                        break block13;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                log.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
            }
            catch (InterruptedException e) {
                log.error("closeChannel exception", (Throwable)e);
            }
        }
    }

    @Override
    public void registerRPCHook(RPCHook rpcHook) {
        this.rpcHook = rpcHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(Channel channel) {
        block12: {
            if (null == channel) {
                return;
            }
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = null;
                        String addrRemote = null;
                        for (Map.Entry<String, ChannelWrapper> entry : this.channelTables.entrySet()) {
                            String key = entry.getKey();
                            ChannelWrapper prev = entry.getValue();
                            if (prev.getChannel() == null || prev.getChannel() != channel) continue;
                            prevCW = prev;
                            addrRemote = key;
                            break;
                        }
                        if (null == prevCW) {
                            log.info("eventCloseChannel: the channel[{}] has been removed from the channel table before", addrRemote);
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            this.channelTables.remove(addrRemote);
                            log.info("closeChannel: the channel[{}] was removed from channel table", addrRemote);
                            RemotingUtil.closeChannel(channel);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        log.error("closeChannel: close the channel exception", (Throwable)e);
                        break block12;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                log.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
            }
            catch (InterruptedException e) {
                log.error("closeChannel exception", (Throwable)e);
            }
        }
    }

    @Override
    public void updateNameServerAddressList(List<String> addrs) {
        List<String> old = this.namesrvAddrList.get();
        boolean update = false;
        if (!addrs.isEmpty()) {
            if (null == old) {
                update = true;
            } else if (addrs.size() != old.size()) {
                update = true;
            } else {
                for (int i = 0; i < addrs.size() && !update; ++i) {
                    if (old.contains(addrs.get(i))) continue;
                    update = true;
                }
            }
            if (update) {
                Collections.shuffle(addrs);
                this.namesrvAddrList.set(addrs);
            }
        }
    }

    @Override
    public RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isActive()) {
            try {
                if (this.rpcHook != null) {
                    this.rpcHook.doBeforeRequest(addr, request);
                }
                RemotingCommand response = this.invokeSyncImpl(channel, request, timeoutMillis);
                if (this.rpcHook != null) {
                    this.rpcHook.doAfterResponse(RemotingHelper.parseChannelRemoteAddr(channel), request, response);
                }
                return response;
            }
            catch (RemotingSendRequestException e) {
                log.warn("invokeSync: send request exception, so close the channel[{}]", (Object)addr);
                this.closeChannel(addr, channel);
                throw e;
            }
            catch (RemotingTimeoutException e) {
                if (this.nettyClientConfig.isClientCloseSocketIfTimeout()) {
                    this.closeChannel(addr, channel);
                    log.warn("invokeSync: close socket because of timeout, {}ms, {}", (Object)timeoutMillis, (Object)addr);
                }
                log.warn("invokeSync: wait response timeout exception, the channel[{}]", (Object)addr);
                throw e;
            }
        }
        this.closeChannel(addr, channel);
        throw new RemotingConnectException(addr);
    }

    private Channel getAndCreateChannel(String addr) throws InterruptedException {
        if (null == addr) {
            return this.getAndCreateNameserverChannel();
        }
        ChannelWrapper cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.getChannel();
        }
        return this.createChannel(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Channel getAndCreateNameserverChannel() throws InterruptedException {
        ChannelWrapper cw;
        String addr = this.namesrvAddrChoosed.get();
        if (addr != null && (cw = this.channelTables.get(addr)) != null && cw.isOK()) {
            return cw.getChannel();
        }
        List<String> addrList = this.namesrvAddrList.get();
        if (this.lockNamesrvChannel.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            try {
                ChannelWrapper cw2;
                addr = this.namesrvAddrChoosed.get();
                if (addr != null && (cw2 = this.channelTables.get(addr)) != null && cw2.isOK()) {
                    Channel channel = cw2.getChannel();
                    return channel;
                }
                if (addrList == null || addrList.isEmpty()) return null;
                for (int i = 0; i < addrList.size(); ++i) {
                    int index = this.namesrvIndex.incrementAndGet();
                    index = Math.abs(index);
                    String newAddr = addrList.get(index %= addrList.size());
                    this.namesrvAddrChoosed.set(newAddr);
                    Channel channelNew = this.createChannel(newAddr);
                    if (channelNew == null) continue;
                    Channel channel = channelNew;
                    return channel;
                }
                return null;
            }
            catch (Exception e) {
                log.error("getAndCreateNameserverChannel: create name server channel exception", (Throwable)e);
                return null;
            }
            finally {
                this.lockNamesrvChannel.unlock();
            }
        } else {
            log.warn("getAndCreateNameserverChannel: try to lock name server, but timeout, {}ms", (Object)3000L);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Channel createChannel(String addr) throws InterruptedException {
        cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return ChannelWrapper.access$300(cw);
        }
        if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            try {
                createNewConnection = false;
                cw = this.channelTables.get(addr);
                if (cw != null) {
                    if (cw.isOK()) {
                        var4_6 = ChannelWrapper.access$300(cw);
                        return var4_6;
                    }
                    if (!cw.getChannelFuture().isDone()) {
                        createNewConnection = false;
                    } else {
                        this.channelTables.remove(addr);
                        createNewConnection = true;
                    }
                } else {
                    createNewConnection = true;
                }
                if (!createNewConnection) ** GOTO lbl34
                channelFuture = this.bootstrap.connect(RemotingHelper.string2SocketAddress(addr));
                NettyRemotingClient.log.info("createChannel: begin to connect remote host[{}] asynchronously", (Object)addr);
                cw = new ChannelWrapper(channelFuture);
                this.channelTables.put(addr, cw);
            }
            catch (Exception e) {
                NettyRemotingClient.log.error("createChannel: create channel exception", (Throwable)e);
            }
            finally {
                this.lockChannelTables.unlock();
            }
        } else {
            NettyRemotingClient.log.warn("createChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
        }
lbl34:
        // 4 sources

        if (cw != null) {
            channelFuture = cw.getChannelFuture();
            if (channelFuture.awaitUninterruptibly(this.nettyClientConfig.getConnectTimeoutMillis())) {
                if (cw.isOK()) {
                    NettyRemotingClient.log.info("createChannel: connect remote host[{}] success, {}", (Object)addr, (Object)channelFuture.toString());
                    return ChannelWrapper.access$300(cw);
                }
                NettyRemotingClient.log.warn("createChannel: connect remote host[" + addr + "] failed, " + channelFuture.toString(), channelFuture.cause());
            } else {
                NettyRemotingClient.log.warn("createChannel: connect remote host[{}] timeout {}ms, {}", new Object[]{addr, this.nettyClientConfig.getConnectTimeoutMillis(), channelFuture.toString()});
            }
        }
        return null;
    }

    @Override
    public void invokeAsync(String addr, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isActive()) {
            try {
                if (this.rpcHook != null) {
                    this.rpcHook.doBeforeRequest(addr, request);
                }
                this.invokeAsyncImpl(channel, request, timeoutMillis, invokeCallback);
            }
            catch (RemotingSendRequestException e) {
                log.warn("invokeAsync: send request exception, so close the channel[{}]", (Object)addr);
                this.closeChannel(addr, channel);
                throw e;
            }
        } else {
            this.closeChannel(addr, channel);
            throw new RemotingConnectException(addr);
        }
    }

    @Override
    public void invokeOneway(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isActive()) {
            try {
                if (this.rpcHook != null) {
                    this.rpcHook.doBeforeRequest(addr, request);
                }
                this.invokeOnewayImpl(channel, request, timeoutMillis);
            }
            catch (RemotingSendRequestException e) {
                log.warn("invokeOneway: send request exception, so close the channel[{}]", (Object)addr);
                this.closeChannel(addr, channel);
                throw e;
            }
        } else {
            this.closeChannel(addr, channel);
            throw new RemotingConnectException(addr);
        }
    }

    @Override
    public void registerProcessor(int requestCode, NettyRequestProcessor processor, ExecutorService executor) {
        ExecutorService executorThis = executor;
        if (null == executor) {
            executorThis = this.publicExecutor;
        }
        Pair<NettyRequestProcessor, ExecutorService> pair = new Pair<NettyRequestProcessor, ExecutorService>(processor, executorThis);
        this.processorTable.put(requestCode, pair);
    }

    @Override
    public boolean isChannelWriteable(String addr) {
        ChannelWrapper cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.isWriteable();
        }
        return true;
    }

    @Override
    public List<String> getNameServerAddressList() {
        return this.namesrvAddrList.get();
    }

    @Override
    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    @Override
    public RPCHook getRPCHook() {
        return this.rpcHook;
    }

    @Override
    public ExecutorService getCallbackExecutor() {
        return this.publicExecutor;
    }

    class NettyConnectManageHandler
    extends ChannelDuplexHandler {
        NettyConnectManageHandler() {
        }

        @Override
        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            String local = localAddress == null ? "UNKNOWN" : localAddress.toString();
            String remote = remoteAddress == null ? "UNKNOWN" : remoteAddress.toString();
            log.info("NETTY CLIENT PIPELINE: CONNECT  {} => {}", (Object)local, (Object)remote);
            super.connect(ctx, remoteAddress, localAddress, promise);
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CONNECT, remote, ctx.channel()));
            }
        }

        @Override
        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("NETTY CLIENT PIPELINE: DISCONNECT {}", (Object)remoteAddress);
            NettyRemotingClient.this.closeChannel(ctx.channel());
            super.disconnect(ctx, promise);
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress.toString(), ctx.channel()));
            }
        }

        @Override
        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("NETTY CLIENT PIPELINE: CLOSE {}", (Object)remoteAddress);
            NettyRemotingClient.this.closeChannel(ctx.channel());
            super.close(ctx, promise);
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress.toString(), ctx.channel()));
            }
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            IdleStateEvent event;
            if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                log.warn("NETTY CLIENT PIPELINE: IDLE exception [{}]", (Object)remoteAddress);
                NettyRemotingClient.this.closeChannel(ctx.channel());
                if (NettyRemotingClient.this.channelEventListener != null) {
                    NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.IDLE, remoteAddress.toString(), ctx.channel()));
                }
            }
            ctx.fireUserEventTriggered(evt);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.warn("NETTY CLIENT PIPELINE: exceptionCaught {}", (Object)remoteAddress);
            log.warn("NETTY CLIENT PIPELINE: exceptionCaught exception.", cause);
            NettyRemotingClient.this.closeChannel(ctx.channel());
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.EXCEPTION, remoteAddress.toString(), ctx.channel()));
            }
        }
    }

    class NettyClientHandler
    extends SimpleChannelInboundHandler<RemotingCommand> {
        NettyClientHandler() {
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, RemotingCommand msg) throws Exception {
            NettyRemotingClient.this.processMessageReceived(ctx, msg);
        }
    }

    static class ChannelWrapper {
        private final ChannelFuture channelFuture;

        public ChannelWrapper(ChannelFuture channelFuture) {
            this.channelFuture = channelFuture;
        }

        public boolean isOK() {
            return this.channelFuture.channel() != null && this.channelFuture.channel().isActive();
        }

        public boolean isWriteable() {
            return this.channelFuture.channel().isWritable();
        }

        private Channel getChannel() {
            return this.channelFuture.channel();
        }

        public ChannelFuture getChannelFuture() {
            return this.channelFuture;
        }
    }
}

