/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.authority.SessionCredentials;
import com.aliyun.openservices.ons.api.impl.rocketmq.FAQ;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.ons.api.impl.util.NameAddrUtils;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.namesrv.TopAddressing;
import java.util.Properties;
import org.slf4j.Logger;

public abstract class ONSClientAbstract {
    protected static final String WSADDR_INTERNAL = System.getProperty("com.aliyun.openservices.ons.addr.internal", "http://onsaddr-internal.aliyun.com:8080/rocketmq/nsaddr4client-internal");
    protected static final String WSADDR_INTERNET = System.getProperty("com.aliyun.openservices.ons.addr.internet", "http://onsaddr-internet.aliyun.com/rocketmq/nsaddr4client-internet");
    protected static final long WSADDR_INTERNAL_TIMEOUTMILLS = Long.parseLong(System.getProperty("com.aliyun.openservices.ons.addr.internal.timeoutmills", "3000"));
    protected static final long WSADDR_INTERNET_TIMEOUTMILLS = Long.parseLong(System.getProperty("com.aliyun.openservices.ons.addr.internet.timeoutmills", "5000"));
    private static final Logger log = ClientLoggerUtil.getClientLogger();
    protected final Properties properties;
    protected final SessionCredentials sessionCredentials = new SessionCredentials();
    protected String nameServerAddr = NameAddrUtils.getNameAdd();

    public ONSClientAbstract(Properties properties) {
        String addr;
        this.properties = properties;
        this.sessionCredentials.updateContent(properties);
        if (null == this.sessionCredentials.getAccessKey() || "".equals(this.sessionCredentials.getAccessKey())) {
            throw new ONSClientException("please set access key");
        }
        if (null == this.sessionCredentials.getSecretKey() || "".equals(this.sessionCredentials.getSecretKey())) {
            throw new ONSClientException("please set secret key");
        }
        if (null == this.sessionCredentials.getOnsChannel()) {
            throw new ONSClientException("please set ons channel");
        }
        String property = this.properties.getProperty("NAMESRV_ADDR");
        if (property != null) {
            this.nameServerAddr = property;
            return;
        }
        if (null == this.nameServerAddr && null != (addr = this.fetchNameServerAddr())) {
            this.nameServerAddr = addr;
        }
        if (null == this.nameServerAddr) {
            throw new ONSClientException(FAQ.errorMessage("Can not find name server, May be your network problem.", "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&namesrv_not_exist"));
        }
    }

    protected String fetchNameServerAddr() {
        String property = this.properties.getProperty("ONSAddr");
        if (property != null) {
            TopAddressing top = new TopAddressing(property);
            return top.fetchNSAddr();
        }
        TopAddressing top = new TopAddressing(WSADDR_INTERNAL);
        String nsAddrs = top.fetchNSAddr(false, WSADDR_INTERNAL_TIMEOUTMILLS);
        if (nsAddrs != null) {
            log.info("connected to internal server, {} success, {}", (Object)WSADDR_INTERNAL, (Object)nsAddrs);
            return nsAddrs;
        }
        top = new TopAddressing(WSADDR_INTERNET);
        nsAddrs = top.fetchNSAddr(false, WSADDR_INTERNET_TIMEOUTMILLS);
        if (nsAddrs != null) {
            log.info("connected to internet server, {} success, {}", (Object)WSADDR_INTERNET, (Object)nsAddrs);
            return nsAddrs;
        }
        return null;
    }

    protected String buildIntanceName() {
        return Integer.toString(UtilAll.getPid()) + "#" + this.nameServerAddr.hashCode() + "#" + this.sessionCredentials.getAccessKey().hashCode() + "#" + System.nanoTime();
    }

    public String getNameServerAddr() {
        return this.nameServerAddr;
    }

    protected void checkONSProducerServiceState(DefaultMQProducerImpl producer) {
        switch (producer.getServiceState()) {
            case CREATE_JUST: {
                throw new ONSClientException(FAQ.errorMessage(String.format("You do not have start the producer[" + UtilAll.getPid() + "], %s", new Object[]{producer.getServiceState()}), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&service_not_ok"));
            }
            case SHUTDOWN_ALREADY: {
                throw new ONSClientException(FAQ.errorMessage(String.format("Your producer has been shut down, %s", new Object[]{producer.getServiceState()}), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&service_not_ok"));
            }
            case START_FAILED: {
                throw new ONSClientException(FAQ.errorMessage(String.format("When you start your service throws an exception, %s", new Object[]{producer.getServiceState()}), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&service_not_ok"));
            }
            case RUNNING: {
                break;
            }
        }
    }
}

