/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sls.android.utdid;

import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.aliyun.sls.android.utils.PermissionHelper;
import java.security.MessageDigest;

class Generator {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    Generator() {
    }

    public static String getImei(Context context) {
        if (!PermissionHelper.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
            return "";
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (Build.VERSION.SDK_INT >= 29) {
            try {
                return tm.getImei();
            }
            catch (Throwable e) {
                return "";
            }
        }
        return tm.getDeviceId();
    }

    public static String getImsi(Context context) {
        if (!PermissionHelper.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
            return "";
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        try {
            return tm.getSubscriberId();
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static String md5(String code) {
        try {
            byte[] bytes = MessageDigest.getInstance("MD5").digest(code.getBytes("UTF-8"));
            return Generator.bytes2Hex(bytes);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String bytes2Hex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

