/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sls.android.producer;

import android.content.Context;
import com.aliyun.sls.android.producer.Log;
import com.aliyun.sls.android.producer.LogProducerCallback;
import com.aliyun.sls.android.producer.LogProducerConfig;
import com.aliyun.sls.android.producer.LogProducerException;
import com.aliyun.sls.android.producer.LogProducerResult;
import com.aliyun.sls.android.producer.utils.TimeUtils;
import com.aliyun.sls.android.scheme.Scheme;
import java.util.Map;

public class LogProducerClient {
    private final LogProducerConfig config;
    private final long producer;
    private final long client;
    @Deprecated
    private IAddLogInterceptor addLogInterceptor;

    public LogProducerClient(LogProducerConfig logProducerConfig) throws LogProducerException {
        this(logProducerConfig, null);
    }

    public LogProducerClient(LogProducerConfig logProducerConfig, LogProducerCallback callback) throws LogProducerException {
        this.config = logProducerConfig;
        this.producer = LogProducerClient.create_log_producer(logProducerConfig.getConfig(), callback);
        if (this.producer == 0L) {
            throw new LogProducerException("Can not create log producer");
        }
        this.client = LogProducerClient.get_log_producer_client(this.producer);
        if (this.client == 0L) {
            throw new LogProducerException("Can not create log producer client");
        }
        TimeUtils.startUpdateServerTime(logProducerConfig.getContext(), logProducerConfig.getEndpoint(), logProducerConfig.getProject());
    }

    public LogProducerResult addLog(Log log) {
        return this.addLog(log, 0);
    }

    public LogProducerResult addLog(Log log, int flush) {
        if (this.client == 0L || log == null) {
            return LogProducerResult.LOG_PRODUCER_INVALID;
        }
        if (this.config.isEnableTrack()) {
            Context context = this.config.getContext();
            if (null != context) {
                Scheme scheme = Scheme.createDefaultScheme(this.config.getContext());
                for (Map.Entry<String, String> entry : scheme.toMap().entrySet()) {
                    log.putContent(entry.getKey(), entry.getValue());
                }
            }
        } else if (null != this.addLogInterceptor) {
            this.addLogInterceptor.onBeforeLogAdded(log);
        }
        Map<String, String> contents = log.getContent();
        int pairCount = contents.size();
        String[] keyArray = new String[pairCount];
        String[] valueArray = new String[pairCount];
        int i = 0;
        for (Map.Entry<String, String> entry : contents.entrySet()) {
            String key = entry.getKey();
            keyArray[i] = key = key == null ? "" : key;
            String value = entry.getValue();
            valueArray[i] = value = value == null ? "" : value;
            ++i;
        }
        long logTime = log.getLogTime();
        int res = LogProducerClient.log_producer_client_add_log_with_len(this.client, logTime, pairCount, keyArray, valueArray, flush);
        return LogProducerResult.fromInt(res);
    }

    @Deprecated
    public void setAddLogInterceptor(IAddLogInterceptor addLogInterceptor) {
        this.addLogInterceptor = addLogInterceptor;
    }

    public LogProducerResult addLogRaw(byte[][] keys, byte[][] values) {
        if (this.client == 0L || null == keys || null == values) {
            return LogProducerResult.LOG_PRODUCER_INVALID;
        }
        long logTime = new Log().getLogTime();
        int res = LogProducerClient.log_producer_client_add_log_with_len_time_int32(this.client, logTime, keys.length, keys, values);
        return LogProducerResult.fromInt(res);
    }

    public void destroyLogProducer() {
        LogProducerClient.destroy_log_producer(this.producer);
    }

    private static native long create_log_producer(long var0, LogProducerCallback var2);

    private static native long get_log_producer_client(long var0);

    private static native int log_producer_client_add_log_with_len(long var0, long var2, int var4, String[] var5, String[] var6, int var7);

    private static native int log_producer_client_add_log_with_len_time_int32(long var0, long var2, int var4, byte[][] var5, byte[][] var6);

    private static native void destroy_log_producer(long var0);

    public static interface IAddLogInterceptor {
        public void onBeforeLogAdded(Log var1);
    }
}

