/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.ProtobufRecordStreamWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class StreamRecordPack {
    private ByteArrayOutputStream byteArrayOutputStream;
    private ProtobufRecordStreamWriter protobufRecordStreamWriter;
    private CompressOption compressOption;
    private TableSchema recordSchema;
    private long recordCount;
    private int blockThreshold = 0x200000;
    private boolean packSealed = false;

    public StreamRecordPack(TableSchema recordSchema) {
        this.recordSchema = recordSchema;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.recordCount = 0L;
        this.compressOption = new CompressOption();
    }

    public boolean append(Record r) throws IOException {
        if (this.protobufRecordStreamWriter == null) {
            this.protobufRecordStreamWriter = new ProtobufRecordStreamWriter(this.recordSchema, this.byteArrayOutputStream, this.compressOption);
        }
        if (this.protobufRecordStreamWriter.getTotalBytes() >= (long)this.blockThreshold || this.packSealed) {
            return false;
        }
        this.protobufRecordStreamWriter.write(r);
        ++this.recordCount;
        return true;
    }

    public void clear() throws IOException {
        if (this.protobufRecordStreamWriter != null) {
            this.protobufRecordStreamWriter.close();
        }
        this.protobufRecordStreamWriter = null;
        this.byteArrayOutputStream.reset();
        this.recordCount = 0L;
        this.packSealed = false;
    }

    byte[] getByteArray() throws IOException {
        this.packSealed = true;
        if (this.protobufRecordStreamWriter != null) {
            this.protobufRecordStreamWriter.close();
            this.protobufRecordStreamWriter = null;
        }
        return this.byteArrayOutputStream.toByteArray();
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    CompressOption getCompressOption() {
        return this.compressOption;
    }
}

