/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordPack;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.tunnel.InvalidColumnTypeException;
import com.aliyun.odps.tunnel.io.Checksum;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.ProtobufOutputStream;
import com.aliyun.odps.tunnel.io.ProtobufRecordPack;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.xerial.snappy.SnappyFramedOutputStream;

class ProtobufRecordStreamWriter
implements RecordWriter {
    private Column[] columns;
    private ProtobufOutputStream out;
    private long count;
    private Checksum crc = new Checksum();
    private Checksum crccrc = new Checksum();
    private Deflater def;

    public ProtobufRecordStreamWriter(TableSchema schema, OutputStream out) throws IOException {
        this(schema, out, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProtobufRecordStreamWriter(TableSchema schema, OutputStream out, CompressOption option) throws IOException {
        this.columns = schema.getColumns().toArray(new Column[0]);
        if (option != null) {
            if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) {
                this.def = new Deflater();
                this.def.setLevel(option.level);
                this.def.setStrategy(option.strategy);
                this.out = new ProtobufOutputStream(new DeflaterOutputStream(out, this.def));
                return;
            } else if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_SNAPPY)) {
                this.out = new ProtobufOutputStream((OutputStream)new SnappyFramedOutputStream(out));
                return;
            } else {
                if (!option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_RAW)) throw new IOException("invalid compression option.");
                this.out = new ProtobufOutputStream(out);
            }
            return;
        } else {
            this.out = new ProtobufOutputStream(out);
        }
    }

    @Override
    public void write(Record r) throws IOException {
        int columnCount;
        int recordValues = r.getColumnCount();
        if (recordValues > (columnCount = this.columns.length)) {
            throw new IOException("record values more than schema.");
        }
        block8: for (int i = 0; i < columnCount && i < recordValues; ++i) {
            Object v = r.get(i);
            if (v == null) continue;
            int pbIdx = i + 1;
            this.crc.update(pbIdx);
            OdpsType type = this.columns[i].getType();
            switch (type) {
                case BOOLEAN: {
                    boolean value = (Boolean)v;
                    this.crc.update(value);
                    this.out.writeBoolean(pbIdx, value);
                    continue block8;
                }
                case DATETIME: {
                    Date value = (Date)v;
                    Long longValue = DateUtils.date2ms(value);
                    this.crc.update(longValue);
                    this.out.writeLong(pbIdx, longValue);
                    continue block8;
                }
                case STRING: {
                    byte[] bytes = null;
                    if (v instanceof String) {
                        String value = (String)v;
                        bytes = value.getBytes("UTF-8");
                    } else {
                        bytes = (byte[])v;
                    }
                    this.crc.update(bytes, 0, bytes.length);
                    this.out.writeRawBytes(pbIdx, bytes);
                    continue block8;
                }
                case DOUBLE: {
                    double value = (Double)v;
                    this.crc.update(value);
                    this.out.writeDouble(pbIdx, value);
                    continue block8;
                }
                case BIGINT: {
                    long value = (Long)v;
                    this.crc.update(value);
                    this.out.writeLong(pbIdx, value);
                    continue block8;
                }
                case DECIMAL: {
                    String value = ((BigDecimal)v).toPlainString();
                    byte[] bytes = value.getBytes("UTF-8");
                    this.crc.update(bytes, 0, bytes.length);
                    this.out.writeRawBytes(pbIdx, bytes);
                    continue block8;
                }
                default: {
                    throw new IOException(new InvalidColumnTypeException("Invalid data type: " + type));
                }
            }
        }
        int checksum = (int)this.crc.getValue();
        this.out.writeUInt32(33553408, checksum);
        this.crc.reset();
        this.crccrc.update(checksum);
        ++this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.out.writeLong(0x1FFFFFE, this.count);
            this.out.writeUInt32(0x1FFFFFF, (int)this.crccrc.getValue());
            this.out.close();
        }
        finally {
            if (this.def != null) {
                this.def.end();
            }
        }
    }

    public long getTotalBytes() {
        return this.out.getTotalBytes();
    }

    public void write(RecordPack pack) throws IOException {
        if (pack instanceof ProtobufRecordPack) {
            ProtobufRecordPack pbPack = (ProtobufRecordPack)pack;
            pbPack.getProtobufStream().writeTo(this.out);
            this.count += pbPack.getSize();
            this.setCheckSum(pbPack.getCheckSum());
        } else {
            Record record;
            RecordReader reader = pack.getRecordReader();
            while ((record = reader.read()) != null) {
                this.write(record);
            }
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public Checksum getCheckSum() {
        return this.crccrc;
    }

    void setCheckSum(Checksum checkSum) {
        this.crccrc = checkSum;
    }
}

