/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.Column;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.tunnel.io.Checksum;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.ProtobufInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.zip.InflaterInputStream;
import org.xerial.snappy.SnappyFramedInputStream;

class ProtobufRecordStreamReader
implements RecordReader {
    private ProtobufInputStream in;
    private Column[] columns;
    private long count;
    private Checksum crc = new Checksum();
    private Checksum crccrc = new Checksum();

    public ProtobufRecordStreamReader(TableSchema schema, InputStream in, CompressOption option) throws IOException {
        this(schema, null, in, option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProtobufRecordStreamReader(TableSchema schema, List<Column> columns, InputStream in, CompressOption option) throws IOException {
        if (columns == null) {
            this.columns = schema.getColumns().toArray(new Column[0]);
        } else {
            Column[] tmpColumns = new Column[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                tmpColumns[i] = schema.getColumn(columns.get(i).getName());
            }
            this.columns = tmpColumns;
        }
        BufferedInputStream bin = new BufferedInputStream(in);
        if (option != null) {
            if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) {
                this.in = new ProtobufInputStream(new InflaterInputStream(bin));
                return;
            } else if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_SNAPPY)) {
                this.in = new ProtobufInputStream((InputStream)new SnappyFramedInputStream((InputStream)bin));
                return;
            } else {
                if (!option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_RAW)) throw new IOException("invalid compression option.");
                this.in = new ProtobufInputStream(bin);
            }
            return;
        } else {
            this.in = new ProtobufInputStream(bin);
        }
    }

    @Override
    public Record read() throws IOException {
        int checkSum;
        ArrayRecord record;
        block17: {
            int i;
            record = new ArrayRecord(this.columns);
            block8: while (true) {
                checkSum = 0;
                i = this.in.readFieldNumber();
                if (i == 33553408) {
                    checkSum = (int)this.crc.getValue();
                    if (this.in.readUInt32() != checkSum) {
                        throw new IOException("Checksum invalid.");
                    }
                    break block17;
                }
                if (i == 0x1FFFFFE) {
                    if (this.count != this.in.readLong()) {
                        throw new IOException("count does not match.");
                    }
                    if (0x1FFFFFF != this.in.readFieldNumber()) {
                        throw new IOException("Invalid stream.");
                    }
                    if ((int)this.crccrc.getValue() != this.in.readUInt32()) {
                        throw new IOException("Checksum invalid.");
                    }
                    if (this.in.read() >= 0) {
                        throw new IOException("Expect at the end of stream, but not.");
                    }
                    return null;
                }
                if (i > this.columns.length) {
                    throw new IOException("Invalid protobuf tag. Perhaps the datastream from server is crushed.");
                }
                this.crc.update(i);
                switch (this.columns[i - 1].getType()) {
                    case DOUBLE: {
                        double v = this.in.readDouble();
                        this.crc.update(v);
                        record.setDouble(i - 1, Double.valueOf(v));
                        continue block8;
                    }
                    case BOOLEAN: {
                        boolean v = this.in.readBoolean();
                        this.crc.update(v);
                        record.setBoolean(i - 1, Boolean.valueOf(v));
                        continue block8;
                    }
                    case BIGINT: {
                        long v = this.in.readLong();
                        this.crc.update(v);
                        record.setBigint(i - 1, Long.valueOf(v));
                        continue block8;
                    }
                    case STRING: {
                        byte[] bytes = this.in.readRawBytes();
                        this.crc.update(bytes, 0, bytes.length);
                        record.setString(i - 1, bytes);
                        continue block8;
                    }
                    case DATETIME: {
                        long v = this.in.readLong();
                        this.crc.update(v);
                        record.setDatetime(i - 1, DateUtils.ms2date(v));
                        continue block8;
                    }
                    case DECIMAL: {
                        byte[] bytes = this.in.readRawBytes();
                        this.crc.update(bytes, 0, bytes.length);
                        BigDecimal decimal = new BigDecimal(new String(bytes, "UTF-8"));
                        record.setDecimal(i - 1, decimal);
                        continue block8;
                    }
                }
                break;
            }
            throw new IOException("Unsupported type " + this.columns[i - 1].getType());
        }
        this.crc.reset();
        this.crccrc.update(checkSum);
        ++this.count;
        return record;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public long getTotalBytes() {
        return this.in.getTotalBytes();
    }
}

