/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordPack;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.tunnel.io.Checksum;
import com.aliyun.odps.tunnel.io.ProtobufRecordStreamWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ProtobufRecordPack
extends RecordPack {
    private ProtobufRecordStreamWriter writer;
    private ByteArrayOutputStream byteos;
    private long count = 0L;
    private TableSchema schema;

    public ProtobufRecordPack(TableSchema schema) throws IOException {
        this(schema, new Checksum());
    }

    public ProtobufRecordPack(TableSchema schema, Checksum checkSum) throws IOException {
        this(schema, checkSum, 0);
    }

    public ProtobufRecordPack(TableSchema schema, Checksum checkSum, int capacity) throws IOException {
        this.byteos = capacity == 0 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(capacity);
        this.schema = schema;
        this.writer = new ProtobufRecordStreamWriter(schema, this.byteos);
        if (checkSum != null) {
            this.writer.setCheckSum(checkSum);
        }
    }

    @Override
    public void append(Record a) throws IOException {
        this.writer.write(a);
        ++this.count;
    }

    @Override
    public RecordReader getRecordReader() throws IOException {
        throw new UnsupportedOperationException("PBPack does not supported Read.");
    }

    ByteArrayOutputStream getProtobufStream() throws IOException {
        this.writer.flush();
        return this.byteos;
    }

    public long getTotalBytes() throws IOException {
        return this.getProtobufStream().size();
    }

    public Checksum getCheckSum() {
        return this.writer.getCheckSum();
    }

    public void reset() throws IOException {
        if (this.byteos != null) {
            this.byteos.reset();
        }
        this.count = 0L;
        this.writer = new ProtobufRecordStreamWriter(this.schema, this.byteos);
    }

    public void reset(Checksum checksum) throws IOException {
        if (this.byteos != null) {
            this.byteos.reset();
        }
        this.count = 0L;
        this.writer = new ProtobufRecordStreamWriter(this.schema, this.byteos);
        if (checksum != null) {
            this.writer.setCheckSum(checksum);
        }
    }

    long getSize() {
        return this.count;
    }
}

