/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.tunnel.io.WireFormat;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class ProtobufOutputStream
extends FilterOutputStream {
    private byte[] buf = new byte[8192];
    private int count;
    private long totalBytes = 0L;

    public ProtobufOutputStream(OutputStream out) {
        super(out);
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.totalBytes += (long)this.count;
            this.count = 0;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBuffer();
            this.out.write(b, off, len);
            this.totalBytes += (long)len;
            return;
        }
        if (len > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public void writeTag(int fieldNumber, int wireType) throws IOException {
        this.writeRawVarint32(WireFormat.makeTag(fieldNumber, wireType));
    }

    public void writeBoolean(int id, boolean v) throws IOException {
        this.writeTag(id, 0);
        this.writeBoolNoTag(v);
    }

    public void writeInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeInt32NoTag(value);
    }

    public void writeSInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeSInt32NoTag(value);
    }

    public void writeUInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeUInt32NoTag(value);
    }

    public void writeLong(int id, long v) throws IOException {
        this.writeTag(id, 0);
        this.writeSInt64NoTag(v);
    }

    public void writeDouble(int id, double v) throws IOException {
        this.writeTag(id, 1);
        this.writeDoubleNoTag(v);
    }

    public void writeRawBytes(int fieldNumber, byte[] value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeRawBytesNoTag(value);
    }

    public void writeString(int fieldNumber, String value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeStringNoTag(value);
    }

    private void writeRawVarint32(int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.write(value);
                return;
            }
            this.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    private void writeRawVarint64(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.write((int)value);
                return;
            }
            this.write((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    private void writeBoolNoTag(boolean value) throws IOException {
        this.write(value ? 1 : 0);
    }

    private void writeSInt64NoTag(long value) throws IOException {
        this.writeRawVarint64(ProtobufOutputStream.encodeZigZag64(value));
    }

    private void writeInt32NoTag(int value) throws IOException {
        if (value >= 0) {
            this.writeRawVarint32(value);
        } else {
            this.writeRawVarint64(value);
        }
    }

    private void writeUInt32NoTag(int value) throws IOException {
        this.writeRawVarint32(value);
    }

    private void writeSInt32NoTag(int value) throws IOException {
        this.writeRawVarint32(ProtobufOutputStream.encodeZigZag32(value));
    }

    private void writeRawLittleEndian64(long value) throws IOException {
        this.write((int)value & 0xFF);
        this.write((int)(value >> 8) & 0xFF);
        this.write((int)(value >> 16) & 0xFF);
        this.write((int)(value >> 24) & 0xFF);
        this.write((int)(value >> 32) & 0xFF);
        this.write((int)(value >> 40) & 0xFF);
        this.write((int)(value >> 48) & 0xFF);
        this.write((int)(value >> 56) & 0xFF);
    }

    private void writeDoubleNoTag(double value) throws IOException {
        this.writeRawLittleEndian64(Double.doubleToRawLongBits(value));
    }

    private void writeRawBytesNoTag(byte[] value) throws IOException {
        this.writeRawVarint32(value.length);
        this.write(value);
    }

    private void writeStringNoTag(String value) throws IOException {
        byte[] bytes = value.getBytes("UTF-8");
        this.writeRawVarint32(bytes.length);
        this.write(bytes);
    }

    private static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    private static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }
}

