/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.tunnel.io.WireFormat;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class ProtobufInputStream
extends FilterInputStream {
    private long totalBytes;

    public ProtobufInputStream(InputStream in) {
        super(in);
    }

    public int readFieldNumber() throws IOException {
        return WireFormat.getTagFieldNumber(this.readTag());
    }

    private int readTag() throws IOException {
        int tag = 0;
        tag = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber(tag) == 0) {
            throw new IOException("Invalid protobuf tag.");
        }
        return tag;
    }

    public boolean readBoolean() throws IOException {
        return this.readRawVarint32() != 0;
    }

    public int readSInt32() throws IOException {
        return ProtobufInputStream.decodeZigZag32(this.readRawVarint32());
    }

    public int readUInt32() throws IOException {
        return this.readRawVarint32();
    }

    public long readLong() throws IOException {
        return ProtobufInputStream.decodeZigZag64(this.readRawVarint64());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public byte[] readRawBytes() throws IOException {
        int size = this.readRawVarint32();
        byte[] bytes = new byte[size];
        for (int len = 0; len < size; len += this.read(bytes, len, size - len)) {
        }
        return bytes;
    }

    public String readString() throws IOException {
        return new String(this.readRawBytes(), "UTF-8");
    }

    private int readRawVarint32() throws IOException {
        byte tmp = (byte)this.read();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = (byte)this.read();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = (byte)this.read();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = (byte)this.read();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = (byte)this.read();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        throw new IOException("MalformedVarint");
                    }
                }
            }
        }
        return result;
    }

    private long readRawVarint64() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = (byte)this.read();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("Protobuf malformed.");
    }

    private long readRawLittleEndian64() throws IOException {
        int b1 = this.read();
        int b2 = this.read();
        int b3 = this.read();
        int b4 = this.read();
        int b5 = this.read();
        int b6 = this.read();
        int b7 = this.read();
        int b8 = this.read();
        return (long)b1 & 0xFFL | ((long)b2 & 0xFFL) << 8 | ((long)b3 & 0xFFL) << 16 | ((long)b4 & 0xFFL) << 24 | ((long)b5 & 0xFFL) << 32 | ((long)b6 & 0xFFL) << 40 | ((long)b7 & 0xFFL) << 48 | ((long)b8 & 0xFFL) << 56;
    }

    private static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    private static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (-1 == b) {
            return b;
        }
        ++this.totalBytes;
        return b;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (-1 == (len = super.read(buf, off, len))) {
            return len;
        }
        this.totalBytes += (long)len;
        return len;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }
}

