/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.DefaultTransport;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.JacksonParser;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.UploadSession$AjcClosure1;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.TunnelRecordWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

@Deprecated
public class UploadSession {
    private String id;
    private TableSchema schema = new TableSchema();
    private String projectName;
    private String tableName;
    private String partitionSpec;
    private List<Long> blocks = new ArrayList<Long>();
    private Status status = Status.UNKNOWN;
    private Configuration conf;
    private RestClient tunnelServiceClient;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    UploadSession(Configuration conf, String projectName, String tableName, String partitionSpec) throws TunnelException {
        this.conf = conf;
        this.projectName = projectName;
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
        this.tunnelServiceClient = new RestClient(new DefaultTransport());
        this.tunnelServiceClient.setAccount(conf.getAccount());
        this.tunnelServiceClient.setEndpoint(conf.getEndpoint(projectName).toString());
        this.tunnelServiceClient.setUserAgent(conf.getUserAgent());
        this.tunnelServiceClient.setReadTimeout(conf.getSocketTimeout());
        this.tunnelServiceClient.setConnectTimeout(conf.getSocketConnectTimeout());
        this.initiate();
    }

    UploadSession(Configuration conf, String projectName, String tableName, String partitionSpec, String uploadId) throws TunnelException {
        this.conf = conf;
        this.projectName = projectName;
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
        this.id = uploadId;
        this.tunnelServiceClient = new RestClient(new DefaultTransport());
        this.tunnelServiceClient.setAccount(conf.getAccount());
        this.tunnelServiceClient.setEndpoint(conf.getEndpoint(projectName).toString());
        this.tunnelServiceClient.setUserAgent(conf.getUserAgent());
        this.tunnelServiceClient.setReadTimeout(conf.getSocketTimeout());
        this.tunnelServiceClient.setConnectTimeout(conf.getSocketConnectTimeout());
        this.reload();
    }

    private void initiate() throws TunnelException {
        block14: {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("uploads", null);
            if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                params.put("partition", this.partitionSpec);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Length", String.valueOf(0));
            Connection conn = null;
            try {
                conn = this.tunnelServiceClient.connect(this.getResource(), "POST", params, headers);
                Response resp = conn.getResponse();
                if (resp.isOK()) {
                    this.loadFromJson(conn.getInputStream());
                    break block14;
                }
                TunnelException e = new TunnelException(conn.getInputStream());
                e.setRequestId(resp.getHeader("x-odps-request-id"));
                throw e;
            }
            catch (IOException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public RecordWriter openRecordWriter(long blockId) throws TunnelException, IOException {
        return this.openRecordWriter(blockId, false);
    }

    public RecordWriter openRecordWriter(long blockId, boolean compress) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Transfer-Encoding", "chunked");
        headers.put("Content-Type", "application/octet-stream");
        headers.put("x-odps-tunnel-version", String.valueOf(3));
        if (compress) {
            if (this.conf.getCompressOption().algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) {
                headers.put("Content-Encoding", "deflate");
            } else {
                throw new TunnelException("invalid compression option.");
            }
        }
        params.put("uploadid", this.id);
        params.put("blockid", Long.toString(blockId));
        if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
            params.put("partition", this.partitionSpec);
        }
        TunnelRecordWriter writer = null;
        Connection conn = null;
        try {
            conn = this.tunnelServiceClient.connect(this.getResource(), "PUT", params, headers);
            CompressOption option = compress ? this.conf.getCompressOption() : null;
            writer = new TunnelRecordWriter(this.schema, conn, option);
        }
        catch (IOException e) {
            if (conn != null) {
                conn.disconnect();
            }
            throw new TunnelException(e.getMessage(), e.getCause());
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (OdpsException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        return writer;
    }

    private void reload() throws TunnelException {
        block14: {
            HashMap<String, String> params = new HashMap<String, String>();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Length", String.valueOf(0));
            params.put("uploadid", this.id);
            if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                params.put("partition", this.partitionSpec);
            }
            Connection conn = null;
            try {
                conn = this.tunnelServiceClient.connect(this.getResource(), "GET", params, headers);
                Response resp = conn.getResponse();
                if (resp.isOK()) {
                    this.loadFromJson(conn.getInputStream());
                    break block14;
                }
                TunnelException e = new TunnelException(conn.getInputStream());
                throw e;
            }
            catch (IOException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public void commit(Long[] blocks) throws TunnelException, IOException {
        if (blocks == null) {
            throw new IllegalArgumentException("Invalid argument: blocks.");
        }
        HashMap<Long, Boolean> clientBlockMap = new HashMap<Long, Boolean>();
        for (Long blockId : blocks) {
            clientBlockMap.put(blockId, true);
        }
        Long[] serverBlocks = this.getBlockList();
        HashMap<Long, Boolean> serverBlockMap = new HashMap<Long, Boolean>();
        for (Long blockId : serverBlocks) {
            serverBlockMap.put(blockId, true);
        }
        if (serverBlockMap.size() != clientBlockMap.size()) {
            throw new TunnelException("Blocks not match, server: " + serverBlockMap.size() + ", tunnelServiceClient: " + clientBlockMap.size());
        }
        for (Long blockId : blocks) {
            if (serverBlockMap.containsKey(blockId)) continue;
            throw new TunnelException("Block not exsits on server, block id is " + blockId);
        }
        this.completeUpload();
    }

    private void completeUpload() throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Length", String.valueOf(0));
        params.put("uploadid", this.id);
        if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
            params.put("partition", this.partitionSpec);
        }
        int count = 0;
        while (true) {
            ++count;
            Connection conn = null;
            try {
                conn = this.tunnelServiceClient.connect(this.getResource(), "POST", params, headers);
                Response resp = conn.getResponse();
                if (resp.isOK()) {
                    this.loadFromJson(conn.getInputStream());
                    break;
                }
                if (resp.getStatus() == 500 && count < 3) {
                    try {
                        Thread.sleep(2 * count * 1000);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new TunnelException(e.getMessage(), e);
                    }
                }
                try {
                    throw new TunnelException(conn.getInputStream());
                }
                catch (IOException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
            }
            finally {
                if (conn == null) continue;
                conn.disconnect();
                continue;
            }
            break;
        }
    }

    public String getId() {
        return this.id;
    }

    public TableSchema getSchema() {
        return this.schema;
    }

    public Status getStatus() throws TunnelException, IOException {
        this.reload();
        return this.status;
    }

    public Record newRecord() {
        return new ArrayRecord(this.getSchema().getColumns().toArray(new Column[0]));
    }

    public Long[] getBlockList() throws TunnelException, IOException {
        this.reload();
        return this.blocks.toArray(new Long[0]);
    }

    private String getResource() {
        return this.conf.getResource(this.projectName, this.tableName);
    }

    private void loadFromJson(InputStream is) throws TunnelException {
        try {
            ObjectMapper mapper = JacksonParser.getObjectMapper();
            JsonNode tree = mapper.readTree(is);
            JsonNode node = tree.get("UploadID");
            if (node != null && !node.isNull()) {
                this.id = node.asText();
            }
            if ((node = tree.get("Status")) != null && !node.isNull()) {
                this.status = Status.valueOf(node.asText().toUpperCase());
            }
            this.blocks.clear();
            node = tree.get("UploadedBlockList");
            if (node != null && !node.isNull() && node.isArray()) {
                Iterator it = node.getElements();
                while (it.hasNext()) {
                    this.blocks.add(((JsonNode)it.next()).get("BlockID").asLong());
                }
            }
            if ((node = tree.get("Schema")) != null && !node.isNull()) {
                this.schema = new TunnelTableSchema(node);
            }
        }
        catch (Exception e) {
            throw new TunnelException("Invalid json content.", e);
        }
    }

    static {
        UploadSession.ajc$preClinit();
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        OdpsDeprecatedLogger.aspectOf().around(new UploadSession$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
    }

    static /* synthetic */ void clinit$_aroundBody0(JoinPoint joinPoint) {
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UploadSession.java", UploadSession.class);
        ajc$tjp_0 = factory.makeSJP("staticinitialization", (Signature)factory.makeInitializerSig("8", "com.aliyun.odps.tunnel.UploadSession"), 0);
    }

    public static enum Status {
        UNKNOWN,
        NORMAL,
        CLOSING,
        CLOSED,
        CANCELED,
        EXPIRED,
        CRITICAL;

    }
}

