/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.JacksonParser;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.StreamClient$AjcClosure1;
import com.aliyun.odps.tunnel.StreamClient$AjcClosure3;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.io.PackReader;
import com.aliyun.odps.tunnel.io.ReplicatorStatus;
import com.aliyun.odps.tunnel.io.StreamReader;
import com.aliyun.odps.tunnel.io.StreamWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class StreamClient {
    private String projectName;
    private String tableName;
    private Configuration conf;
    private RestClient tunnelServiceClient;
    private HashMap<String, String> headers;
    private TableSchema schema = new TableSchema();
    private List<Long> shards = new ArrayList<Long>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public StreamClient(Configuration conf, String projectName, String tableName) throws TunnelException {
        this.conf = conf;
        this.projectName = projectName;
        this.tableName = tableName;
        this.headers = new HashMap();
        this.headers.put("Content-Length", String.valueOf(0));
        this.headers.put("x-odps-tunnel-stream-version", "1");
        this.initiate();
    }

    public void loadShard(int shardNumber) throws TunnelException {
        if (shardNumber < 0) {
            throw new TunnelException("invalid shard number");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(3));
        String path = this.getResource() + "/shards";
        Connection conn = null;
        try {
            params.put("shardnumber", Integer.toString(shardNumber));
            conn = this.tunnelServiceClient.connect(path, "POST", params, headers);
            Response resp = conn.getResponse();
            if (!resp.isOK()) {
                TunnelException ex = new TunnelException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
        }
        catch (IOException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (OdpsException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public HashMap<Long, ShardState> getShardStatus() throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> hdrs = new HashMap<String, String>(this.headers);
        try {
            String path = this.getResource() + "/shards";
            hdrs.put("x-odps-tunnel-version", String.valueOf(3));
            params.put("shardstatus", null);
            Connection conn = this.tunnelServiceClient.connect(path, "GET", params, hdrs);
            Response resp = conn.getResponse();
            if (!resp.isOK()) {
                TunnelException ex = new TunnelException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            return this.loadShardStatusFromJson(conn.getInputStream());
        }
        catch (Exception e) {
            throw new TunnelException(e.getMessage(), e);
        }
    }

    public ReplicatorStatus QueryReplicatorStatus(long shardId, PartitionSpec partitionSpec) throws TunnelException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(3));
        params.put("query", "replicator");
        if (partitionSpec != null && partitionSpec.toString().length() > 0) {
            params.put("partition", partitionSpec.toString().replaceAll("'", ""));
        }
        String path = this.getStreamResource(shardId);
        Connection conn = null;
        try {
            conn = this.tunnelServiceClient.connect(path, "GET", params, headers);
            Response resp = conn.getResponse();
            if (!resp.isOK()) {
                TunnelException ex = new TunnelException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            ReplicatorStatus replicatorStatus = new ReplicatorStatus(conn.getInputStream());
            return replicatorStatus;
        }
        catch (IOException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (OdpsException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public ReplicatorStatus QueryReplicatorStatus(long shardId) throws TunnelException {
        return this.QueryReplicatorStatus(shardId, null);
    }

    private void initiate() throws TunnelException {
        block13: {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("query", "meta");
            params.put("type", "stream");
            this.tunnelServiceClient = this.conf.newRestClient(this.projectName);
            Connection conn = null;
            try {
                conn = this.tunnelServiceClient.connect(this.getResource(), "GET", params, this.headers);
                Response resp = conn.getResponse();
                if (resp.isOK()) {
                    this.loadFromJson(conn.getInputStream());
                    break block13;
                }
                TunnelException e = new TunnelException(conn.getInputStream());
                e.setRequestId(resp.getHeader("x-odps-request-id"));
                throw e;
            }
            catch (IOException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
    }

    public TableSchema getStreamSchema() {
        return this.schema;
    }

    public List<Long> getShardList() {
        return this.shards;
    }

    @Deprecated
    public StreamWriter openStreamWriter(String shardId) throws TunnelException, IOException {
        String string = shardId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (StreamWriter)OdpsDeprecatedLogger.aspectOf().around(new StreamClient$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public StreamWriter openStreamWriter(long shardId) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("Content-Type", "application/octet-stream");
        headers.put("x-odps-tunnel-version", String.valueOf(3));
        return new StreamWriter(this.tunnelServiceClient, this.getStreamResource(shardId), params, headers);
    }

    public StreamReader openStreamReader(long shardId) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(3));
        return new StreamReader(this.tunnelServiceClient, this.schema, this.getStreamResource(shardId), params, headers);
    }

    public StreamReader openStreamReader(long shardId, String packId) throws TunnelException, IOException {
        if (packId == null) {
            throw new IllegalArgumentException("Invalid pack id.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(3));
        return new StreamReader(this.tunnelServiceClient, this.schema, this.getStreamResource(shardId), params, headers, packId);
    }

    public PackReader openPackReader(long shardId) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(3));
        return new PackReader(this.tunnelServiceClient, this.schema, this.getStreamResource(shardId), params, headers);
    }

    public PackReader openPackReader(long shardId, String packId) throws TunnelException, IOException {
        if (packId == null) {
            throw new IllegalArgumentException("Invalid pack id.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(3));
        return new PackReader(this.tunnelServiceClient, this.schema, this.getStreamResource(shardId), params, headers, packId);
    }

    private String getResource() {
        return this.conf.getResource(this.projectName, this.tableName);
    }

    private String getStreamResource(String shardId) {
        String string = shardId;
        String string2 = this.tableName;
        String string3 = this.projectName;
        Configuration configuration = this.conf;
        Object[] objectArray = new Object[]{string3, string2, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)configuration, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, configuration, string3, string2, string, joinPoint};
        return (String)OdpsDeprecatedLogger.aspectOf().around(new StreamClient$AjcClosure3(objectArray2).linkClosureAndJoinPoint(4112));
    }

    private String getStreamResource(long shardId) {
        return this.conf.getStreamUploadResource(this.projectName, this.tableName, shardId);
    }

    private void loadFromJson(InputStream is) throws TunnelException {
        block6: {
            try {
                ObjectMapper mapper = JacksonParser.getObjectMapper();
                JsonNode tree = mapper.readTree(is);
                JsonNode node = tree.get("Schema");
                if (node == null || node.isNull()) {
                    throw new TunnelException("get table schema fail");
                }
                this.schema = new TunnelTableSchema(node);
                node = tree.get("Shards");
                if (node != null && !node.isNull()) {
                    if (node.isArray()) {
                        Iterator it = node.getElements();
                        while (it.hasNext()) {
                            JsonNode shardId = (JsonNode)it.next();
                            this.shards.add(shardId.asLong());
                        }
                    }
                    break block6;
                }
                throw new TunnelException("get shard fail");
            }
            catch (Exception e) {
                throw new TunnelException("Invalid json content.", e);
            }
        }
    }

    private HashMap<Long, ShardState> loadShardStatusFromJson(InputStream is) throws TunnelException {
        try {
            HashMap<Long, ShardState> shardStatus = new HashMap<Long, ShardState>();
            ObjectMapper mapper = JacksonParser.getObjectMapper();
            JsonNode tree = mapper.readTree(is);
            JsonNode node = tree.get("ShardStatus");
            if (node != null && !node.isNull() && node.isArray()) {
                Iterator it = node.getElements();
                while (it.hasNext()) {
                    JsonNode status = (JsonNode)it.next();
                    ShardState state = ShardState.valueOf(status.get("State").asText().toUpperCase());
                    shardStatus.put(Long.parseLong(status.get("ShardId").asText()), state);
                }
            }
            return shardStatus;
        }
        catch (Exception e) {
            throw new TunnelException("Invalid json content.", e);
        }
    }

    static {
        StreamClient.ajc$preClinit();
    }

    static /* synthetic */ StreamWriter openStreamWriter_aroundBody0(StreamClient ajc$this, String shardId, JoinPoint joinPoint) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(ajc$this.headers);
        headers.put("Content-Type", "application/octet-stream");
        headers.put("x-odps-tunnel-version", String.valueOf(3));
        return new StreamWriter(ajc$this.tunnelServiceClient, ajc$this.getStreamResource(shardId), params, headers);
    }

    static /* synthetic */ String getStreamUploadResource_aroundBody2(StreamClient streamClient, Configuration configuration, String string, String string2, String string3, JoinPoint joinPoint) {
        return configuration.getStreamUploadResource(string, string2, string3);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("StreamClient.java", StreamClient.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openStreamWriter", "com.aliyun.odps.tunnel.StreamClient", "java.lang.String", "shardId", "com.aliyun.odps.tunnel.TunnelException:java.io.IOException", "com.aliyun.odps.tunnel.io.StreamWriter"), 261);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getStreamUploadResource", "com.aliyun.odps.tunnel.Configuration", "java.lang.String:java.lang.String:java.lang.String", "projectName:tableName:shardId", "", "java.lang.String"), 321);
    }

    public static enum ShardState {
        UNLOADED,
        LOADED,
        LOADING;

    }
}

