/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration$AjcClosure1;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelServerRouter;
import com.aliyun.odps.tunnel.io.CompressOption;
import java.net.URI;
import java.net.URISyntaxException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

class Configuration {
    public static int DEFAULT_CHUNK_SIZE;
    public static int DEFAULT_SOCKET_CONNECT_TIMEOUT;
    public static int DEFAULT_SOCKET_TIMEOUT;
    private Odps odps;
    private TunnelServerRouter router;
    private int chunkSize = DEFAULT_CHUNK_SIZE;
    private int socketConnectTimeout = DEFAULT_SOCKET_CONNECT_TIMEOUT;
    private int socketTimeout = DEFAULT_SOCKET_TIMEOUT;
    private CompressOption option = new CompressOption();
    private URI endpoint;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public Configuration(Odps odps) {
        this.odps = odps;
        this.router = new TunnelServerRouter(this.odps.getRestClient());
    }

    public Account getAccount() {
        return this.odps.getAccount();
    }

    public CompressOption getCompressOption() {
        return this.option;
    }

    public void setCompressOption(CompressOption option) {
        this.option = option;
    }

    public URI getEndpoint(String projectName) throws TunnelException {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        String odpsEndpoint = this.odps.getEndpoint();
        URI u = null;
        try {
            u = new URI(odpsEndpoint);
        }
        catch (URISyntaxException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        return this.router.getTunnelServer(projectName, u.getScheme());
    }

    public void setEndpoint(URI endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Missing endpoint.");
        }
        this.endpoint = endpoint;
    }

    public URI getURI(String projectName, String tableName) throws TunnelException {
        StringBuilder sb = new StringBuilder();
        String e = this.getEndpoint(projectName).toString();
        sb.append(e);
        if (!e.endsWith("/")) {
            sb.append("/");
        }
        sb.append("projects/");
        sb.append(projectName);
        sb.append("/tables/").append(tableName);
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException e1) {
            throw new RuntimeException(e1);
        }
    }

    public String getResource(String projectName, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("/projects/").append(projectName).append("/tables/").append(tableName);
        return sb.toString();
    }

    @Deprecated
    public String getStreamUploadResource(String projectName, String tableName, String shardId) {
        String string = projectName;
        String string2 = tableName;
        String string3 = shardId;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
        return (String)OdpsDeprecatedLogger.aspectOf().around(new Configuration$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public String getStreamUploadResource(String projectName, String tableName, long shardId) {
        StringBuilder sb = new StringBuilder();
        sb.append("/projects/").append(projectName).append("/tables/").append(tableName).append("/shards/").append(Long.toString(shardId));
        return sb.toString();
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getSocketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    public void setSocketConnectTimeout(int timeout) {
        this.socketConnectTimeout = timeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public String getUserAgent() {
        return this.odps.getUserAgent();
    }

    RestClient newRestClient(String projectName) throws TunnelException {
        RestClient odpsServiceClient = this.odps.clone().getRestClient();
        odpsServiceClient.setReadTimeout(this.getSocketTimeout());
        odpsServiceClient.setConnectTimeout(this.getSocketConnectTimeout());
        odpsServiceClient.setEndpoint(this.getEndpoint(projectName).toString());
        return odpsServiceClient;
    }

    static {
        Configuration.ajc$preClinit();
        DEFAULT_CHUNK_SIZE = 1496;
        DEFAULT_SOCKET_CONNECT_TIMEOUT = 180;
        DEFAULT_SOCKET_TIMEOUT = 300;
    }

    static /* synthetic */ String getStreamUploadResource_aroundBody0(Configuration ajc$this, String projectName, String tableName, String shardId, JoinPoint joinPoint) {
        StringBuilder sb = new StringBuilder();
        sb.append("/projects/").append(projectName).append("/tables/").append(tableName).append("/shards/").append(shardId);
        return sb.toString();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Configuration.java", Configuration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getStreamUploadResource", "com.aliyun.odps.tunnel.Configuration", "java.lang.String:java.lang.String:java.lang.String", "projectName:tableName:shardId", "", "java.lang.String"), 169);
    }
}

