/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.rest;

import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.DomainAccount;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Request;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.transport.Transport;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.commons.util.JacksonParser;
import com.aliyun.odps.commons.util.SvnRevisionUtils;
import com.aliyun.odps.rest.ErrorMessage;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class RestClient {
    public static final int DEFAULT_CONNECT_TIMEOUT = 50;
    public static final int DEFAULT_CONNECT_RETRYTIMES = 3;
    public static final int DEFAULT_READ_TIMEOUT = 120;
    public static final boolean DEFAULT_IGNORE_CERTS = false;
    private final Transport transport;
    private Account account;
    private String endpoint;
    private boolean ignoreCerts = false;
    private String defaultProject;
    private static final String USER_AGENT_PREFIX = "JavaSDK Revision:" + SvnRevisionUtils.getSvnRevision() + " Version:" + SvnRevisionUtils.getMavenVersion();
    private String userAgent;
    private RetryLogger logger = null;
    private static final String CHARSET = "UTF-8";
    int connectTimeout = 50;
    int readTimeout = 120;
    int retryTimes = 3;

    public RetryLogger getRetryLogger() {
        return this.logger;
    }

    public void setRetryLogger(RetryLogger logger) {
        this.logger = logger;
    }

    public RestClient(Transport transport) {
        this.transport = transport;
    }

    public <T> T request(Class<T> clazz, String resource, String method) throws OdpsException {
        return this.request(clazz, resource, method, null, null, null);
    }

    public <T> T request(Class<T> clazz, String resource, String method, Map<String, String> params) throws OdpsException {
        return this.request(clazz, resource, method, params, null, null);
    }

    public <T> T stringRequest(Class<T> clazz, String resource, String method, Map<String, String> params, Map<String, String> headers, String body) throws OdpsException {
        try {
            return this.request(clazz, resource, method, params, headers, body.getBytes(CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public <T> T request(Class<T> clazz, String resource, String method, Map<String, String> params, Map<String, String> headers, byte[] body) throws OdpsException {
        T r = null;
        Response resp = this.request(resource, method, params, headers, body);
        try {
            r = JAXBUtils.unmarshal(resp, clazz);
        }
        catch (JAXBException e) {
            throw new OdpsException("Can't bind xml to " + clazz.getName(), e);
        }
        return r;
    }

    public Response stringRequest(String resource, String method, Map<String, String> params, Map<String, String> headers, String body) throws OdpsException {
        try {
            return this.request(resource, method, params, headers, body.getBytes(CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public Response request(String resource, String method, Map<String, String> params, Map<String, String> headers, byte[] body) throws OdpsException {
        if (null == body) {
            return this.request(resource, method, params, headers, null, 0L);
        }
        return this.request(resource, method, params, headers, new ByteArrayInputStream(body), body.length);
    }

    public Response request(String resource, String method, Map<String, String> params, Map<String, String> headers, InputStream body, long bodyLen) throws OdpsException {
        int retryTimes = 0;
        if (method.equalsIgnoreCase(Request.Method.GET.toString()) || method.equalsIgnoreCase(Request.Method.HEAD.toString())) {
            retryTimes = this.getRetryTimes();
            if (body != null && body.markSupported()) {
                body.mark(0);
            }
        }
        long retryWaitTime = this.getConnectTimeout() + this.getReadTimeout();
        long retryCount = 0L;
        while (retryCount <= (long)retryTimes) {
            long sleepTime;
            long startTime = System.currentTimeMillis();
            try {
                Response resp = this.requestWithNoRetry(resource, method, params, headers, body, bodyLen);
                if (resp == null) {
                    throw new OdpsException("Response is null.");
                }
                if (resp.getStatus() / 100 == 4) {
                    retryTimes = 0;
                }
                this.handleErrorResponse(resp);
                this.uploadDeprecatedLog();
                if (this.account instanceof DomainAccount) {
                    DomainAccount domainAccount = (DomainAccount)this.account;
                    domainAccount.resetRefreshFlag();
                }
                return resp;
            }
            catch (OdpsException e) {
                DomainAccount domainAccount;
                if (this.account instanceof DomainAccount && (domainAccount = (DomainAccount)this.account).shouldRefreshToken(e)) {
                    domainAccount.refreshToken();
                    continue;
                }
                if ((long)retryTimes == retryCount) {
                    throw e;
                }
                this.resetBody(body);
                ++retryCount;
                if (this.logger != null) {
                    this.logger.onRetryLog(e, retryCount, retryWaitTime);
                }
                try {
                    long endTime = System.currentTimeMillis();
                    sleepTime = retryWaitTime * 1000L - (endTime - startTime);
                    if (sleepTime <= 0L) continue;
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e1) {}
            }
            catch (Error e) {
                if ((long)retryTimes == retryCount) {
                    throw e;
                }
                this.resetBody(body);
                ++retryCount;
                if (this.logger != null) {
                    this.logger.onRetryLog(e, retryCount, retryWaitTime);
                }
                try {
                    long endTime = System.currentTimeMillis();
                    sleepTime = retryWaitTime * 1000L - (endTime - startTime);
                    if (sleepTime <= 0L) continue;
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e1) {}
            }
        }
        throw new OdpsException("Failed in Connection Retry.");
    }

    private void uploadDeprecatedLog() {
        try {
            ConcurrentHashMap deprecatedMaps = OdpsDeprecatedLogger.getDeprecatedCalls();
            if (deprecatedMaps.isEmpty()) {
                return;
            }
            String deprecatedLogs = JacksonParser.getObjectMapper().writeValueAsString((Object)deprecatedMaps);
            OdpsDeprecatedLogger.getDeprecatedCalls().clear();
            String project = this.getDefaultProject();
            if (project == null) {
                return;
            }
            String resource = ResourceBuilder.buildProjectResource(project);
            resource = resource + "/logs";
            byte[] bytes = deprecatedLogs.getBytes(CHARSET);
            ByteArrayInputStream body = new ByteArrayInputStream(bytes);
            this.requestWithNoRetry(resource, "PUT", null, null, body, bytes.length);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void handleErrorResponse(Response resp) throws OdpsException {
        if (!resp.isOK()) {
            ErrorMessage error = null;
            try {
                error = JAXBUtils.unmarshal(resp, ErrorMessage.class);
            }
            catch (Exception e) {
                // empty catch block
            }
            OdpsException e = null;
            e = resp.getStatus() == 404 ? (error != null ? new NoSuchObjectException(error.getMessage(), new RestException(error)) : new NoSuchObjectException("No such object.")) : (error != null ? new OdpsException(error.getMessage(), new RestException(error)) : new OdpsException(String.valueOf(resp.getStatus())));
            throw e;
        }
    }

    private void resetBody(InputStream body) {
        if (body != null && body.markSupported()) {
            try {
                body.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected Response requestWithNoRetry(String resource, String method, Map<String, String> params, Map<String, String> headers, InputStream body, long bodyLen) throws OdpsException {
        Response resp = null;
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        try {
            if (body != null) {
                headers.put("Content-Length", String.valueOf(bodyLen));
                if (!headers.containsKey("Content-MD5") && bodyLen > 0L) {
                    String contentMd5 = Hex.encodeHexString((byte[])DigestUtils.md5((InputStream)body));
                    IOUtils.resetInputStream(body);
                    headers.put("Content-MD5", contentMd5);
                }
            }
            Request req = this.buildRequest(resource, method, params, headers);
            req.setBody(body);
            req.setBodyLength(bodyLen);
            resp = this.transport.request(req);
            return resp;
        }
        catch (SSLHandshakeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public Connection connect(String resource, String method, Map<String, String> params, Map<String, String> headers) throws OdpsException, IOException {
        Request req = this.buildRequest(resource, method, params, headers);
        return this.transport.connect(req);
    }

    public Response requestForRawResponse(String resource, String method, Map<String, String> params, Map<String, String> headers, InputStream body, int length) throws OdpsException, IOException {
        return this.requestWithNoRetry(resource, method, params, headers, body, length);
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getDefaultProject() {
        return this.defaultProject;
    }

    public void setDefaultProject(String defaultProject) {
        this.defaultProject = defaultProject;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Transport getTransport() {
        return this.transport;
    }

    private Request buildRequest(String resource, String method, Map<String, String> params, Map<String, String> headers) throws OdpsException {
        if (resource == null || !resource.startsWith("/")) {
            throw new OdpsException("Invalid resource: " + resource);
        }
        if (this.endpoint == null) {
            throw new OdpsException("Odps endpoint required.");
        }
        Request req = new Request(this);
        StringBuilder url = new StringBuilder();
        url.append(this.endpoint).append(resource);
        if (params == null) {
            params = new HashMap<String, String>();
        }
        if (!params.containsKey("curr_project") && this.defaultProject != null) {
            params.put("curr_project", this.defaultProject);
        }
        if (params.size() != 0) {
            req.setParameters(params);
            url.append('?');
            boolean first = true;
            for (Map.Entry<String, String> kv : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    url.append('&');
                }
                String key = kv.getKey();
                String value = kv.getValue();
                url.append(key);
                if (value == null || value.length() <= 0) continue;
                value = ResourceBuilder.encode(value);
                url.append('=').append(value);
            }
        }
        try {
            req.setURI(new URI(url.toString()));
            req.setMethod(Request.Method.valueOf(method));
            if (headers != null) {
                req.setHeaders(headers);
            }
            if (req.getHeaders().get("User-Agent") == null && this.userAgent != null) {
                req.setHeader("User-Agent", this.userAgent);
                req.setHeader("x-odps-user-agent", this.userAgent);
            }
            req.getHeaders().put("Date", DateUtils.formatRfc822Date(new Date()));
            this.account.getRequestSigner().sign(resource, req);
        }
        catch (URISyntaxException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        return req;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = (USER_AGENT_PREFIX + " " + userAgent).trim();
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public boolean isIgnoreCerts() {
        return this.ignoreCerts;
    }

    public void setIgnoreCerts(boolean ignoreCerts) {
        this.ignoreCerts = ignoreCerts;
    }

    public static abstract class RetryLogger {
        public abstract void onRetryLog(Throwable var1, long var2, long var4);
    }
}

