/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.transport;

import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.DefaultConnection;
import com.aliyun.odps.commons.transport.DefaultResponse;
import com.aliyun.odps.commons.transport.Request;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.transport.Transport;
import com.aliyun.odps.commons.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class DefaultTransport
implements Transport {
    private static Boolean sslInit = false;

    public DefaultTransport() {
        this.initSSL();
    }

    @Override
    public Connection connect(Request req) throws IOException {
        DefaultConnection conn = new DefaultConnection();
        conn.connect(req);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response request(Request req) throws IOException {
        Connection conn = this.connect(req);
        DefaultResponse resp = null;
        try {
            if (req.getBody() != null) {
                OutputStream out = conn.getOutputStream();
                IOUtils.copyLarge(req.getBody(), out);
                out.close();
            }
            resp = (DefaultResponse)conn.getResponse();
            if (Request.Method.HEAD != req.getMethod()) {
                InputStream in = conn.getInputStream();
                resp.setBody(IOUtils.readFully(in));
            }
        }
        finally {
            conn.disconnect();
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSSL() {
        if (sslInit.booleanValue()) {
            return;
        }
        Boolean bl = sslInit;
        synchronized (bl) {
            if (sslInit.booleanValue()) {
                return;
            }
            String sslCheckTrusted = System.getProperty("ssl.check.trusted");
            if (sslCheckTrusted == null || Boolean.valueOf(sslCheckTrusted).booleanValue()) {
                sslInit = true;
                return;
            }
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    }
                };
                sc.init(null, new TrustManager[]{tm}, null);
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
                sslInit = true;
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

