/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.account;

import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AuthorizationUtil;
import com.aliyun.odps.account.DomainAccount$AjcClosure1;
import com.aliyun.odps.account.DomainRequestSigner;
import com.aliyun.odps.account.RequestSigner;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class DomainAccount
implements Account {
    private String accessToken;
    private String refreshToken;
    private String username;
    private String password;
    private DomainRequestSigner signer;
    private boolean refreshFlag;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DomainAccount(String accessToken, String refreshToken) {
        this.refreshFlag = false;
        if (accessToken == null || accessToken.trim().length() == 0 || refreshToken == null || refreshToken.trim().length() == 0) {
            throw new IllegalArgumentException("Missing arguments: refreshToken,refreshToken");
        }
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.signer = new DomainRequestSigner(accessToken);
    }

    public static DomainAccount getAccountByUsername(String username, String password) throws OdpsException {
        String[] tokens = AuthorizationUtil.getDomainAccessAndRefreshToken(username, password);
        return new DomainAccount(tokens[0], tokens[1]);
    }

    @Deprecated
    public DomainAccount(String accessToken, String refreshToken, String username, String password) {
        DomainAccount ajc$this;
        String string = accessToken;
        String string2 = refreshToken;
        String string3 = username;
        String string4 = password;
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)ajc$this, (Object)ajc$this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{ajc$this, string, string2, string3, string4, joinPoint};
        OdpsDeprecatedLogger.aspectOf().around(new DomainAccount$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    public Account.AccountProvider getType() {
        return Account.AccountProvider.DOMAIN;
    }

    @Override
    public RequestSigner getRequestSigner() {
        return this.signer;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public boolean shouldRefreshToken(OdpsException e) {
        return "GetDomainUserCodeError".equals(e.getErrorCode());
    }

    public void refreshToken() throws OdpsException {
        if (this.refreshFlag) {
            throw new OdpsException("Get domain user code error while token already refreshed.");
        }
        this.refreshFlag = true;
        AuthorizationUtil.refreshDomainToken(this.accessToken, this.refreshToken);
    }

    public void resetRefreshFlag() {
        this.refreshFlag = false;
    }

    static {
        DomainAccount.ajc$preClinit();
    }

    static /* synthetic */ void init$_aroundBody0(DomainAccount ajc$this, String accessToken, String refreshToken, String username, String password, JoinPoint joinPoint) {
        ajc$this.refreshFlag = false;
        if (accessToken == null || accessToken.trim().length() == 0 || refreshToken == null || refreshToken.trim().length() == 0 || username == null || username.trim().length() == 0 || password == null || password.trim().length() == 0) {
            throw new IllegalArgumentException("Missing arguments: refreshToken,refreshToken,username,password");
        }
        ajc$this.accessToken = accessToken;
        ajc$this.refreshToken = refreshToken;
        ajc$this.username = username;
        ajc$this.password = password;
        ajc$this.signer = new DomainRequestSigner(accessToken);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DomainAccount.java", DomainAccount.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "com.aliyun.odps.account.DomainAccount", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "accessToken:refreshToken:username:password", ""), 120);
    }
}

