/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.account;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.commons.util.JacksonParser;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;

public class AuthorizationUtil {
    public static final String DEFAULT_TAOBAO_TOKEN_URL = "https://passport.alipay.com/oauth2/token";
    public static final String DEFAULT_CLIENT_ID = "f6aa5c6b5a008cb19a977738586a239b";
    public static final String DEFAULT_CLIENT_SECRET = "496d9a3eef3beaec1c0b75893d3338d0";
    public static final boolean DEFAULT_IGNORE_CERTS = false;
    static String TAOBAO_TOKEN_URL = "https://passport.alipay.com/oauth2/token";
    static String CLIENT_ID = "f6aa5c6b5a008cb19a977738586a239b";
    static String CLIENT_SECRET = "496d9a3eef3beaec1c0b75893d3338d0";
    static boolean IGNORE_CERTS = false;
    public static String ARK_URL = "https://login.alibaba-inc.com/arkserver";
    public static String APP_CODE = "1353306c5e82f1fb7ebc844d082a839b";

    public static String getAppCode() {
        return APP_CODE;
    }

    public static String getArkUrl() {
        return ARK_URL;
    }

    public static void setArkUrl(String arkUrl) {
        ARK_URL = arkUrl;
    }

    public static void setAppCode(String appCode) {
        APP_CODE = appCode;
    }

    public static String getTaobaoToken(String username, String password) throws OdpsException {
        JsonNode tree;
        if (username == null || username.trim().length() == 0 || password == null || password.trim().length() == 0) {
            throw new IllegalArgumentException("missing arguments: username,password");
        }
        String content = "client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET + "&username=" + username + "&password=" + password + "&grant_type=password&site=0";
        String result = null;
        String response = AuthorizationUtil.postRequest(TAOBAO_TOKEN_URL, content);
        try {
            tree = JacksonParser.parse(response);
        }
        catch (JsonProcessingException e) {
            throw new OdpsException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new OdpsException(e);
        }
        JsonNode node = tree.get("error_code");
        if (node != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Fail to get access_token: ");
            sb.append(node.asText());
            node = tree.get("error");
            sb.append("-");
            sb.append(node.asText());
            node = tree.get("error_description");
            sb.append("-");
            sb.append(node.asText());
            throw new OdpsException(sb.toString());
        }
        node = tree.get("access_token");
        if (node != null && !node.isNull()) {
            result = node.asText();
        }
        if (result == null || result.trim().length() == 0) {
            throw new OdpsException("Fail to get access_token, access_token is empty, please check your username and password");
        }
        return result;
    }

    public static String[] getDomainAccessAndRefreshToken(String username, String password) throws OdpsException {
        if (username == null || username.trim().length() == 0 || password == null || password.trim().length() == 0) {
            throw new IllegalArgumentException("missing arguments: username,password");
        }
        String token1 = AuthorizationUtil.getDomainToken(username, password);
        if (token1 == null || token1.trim().length() == 0) {
            throw new OdpsException("fail to get access_token please check your username and password");
        }
        String content = "authcode=" + token1 + "&clienttype=Client&appcode=" + APP_CODE + "&version=1.0";
        String[] result = null;
        try {
            boolean isSuccess;
            String response = AuthorizationUtil.postRequest(ARK_URL + "/GetAccessToken.ashx", content);
            JsonNode tree = JacksonParser.parse(response);
            JsonNode node = tree.get("IsSuccess");
            if (node != null && !node.isNull() && (isSuccess = node.asBoolean())) {
                result = new String[]{tree.get("AccessToken").asText(), tree.get("RefreshToken").asText()};
            }
        }
        catch (Exception ex) {
            throw new OdpsException("fail to get access_token please check your username and password: " + ex.getMessage());
        }
        if (result == null || result.length != 2 || result[0] == null || result[0].trim().length() == 0 || result[1] == null || result[1].trim().length() == 0) {
            throw new OdpsException("fail to get access_token please check your username and password");
        }
        return result;
    }

    private static String getDomainToken(String username, String password) throws OdpsException {
        if (username == null || username.trim().length() == 0 || password == null || password.trim().length() == 0) {
            throw new IllegalArgumentException("missing arguments: username,password");
        }
        String content = "appcode=" + APP_CODE + "&version=1.0&name=" + username + "&password=" + password + "&authtype=user";
        String result = null;
        try {
            boolean isSuccess;
            String response = AuthorizationUtil.postRequest(ARK_URL + "/Login.ashx", content);
            JsonNode tree = JacksonParser.parse(response);
            JsonNode node = tree.get("IsSuccess");
            if (node != null && !node.isNull() && (isSuccess = node.asBoolean())) {
                node = tree.get("ArkAuthCode");
                result = node.asText();
            }
        }
        catch (Exception ex) {
            throw new OdpsException("fail to get access_token please check your username and password: " + ex.getMessage());
        }
        if (result == null || result.trim().length() == 0) {
            throw new OdpsException("fail to get access_token please check your username and password");
        }
        return result;
    }

    public static void refreshDomainToken(String accessToken, String refreshToken) throws OdpsException {
        if (accessToken == null || accessToken.trim().length() == 0 || refreshToken == null || refreshToken.trim().length() == 0) {
            throw new IllegalArgumentException("missing arguments: accessToken,refreshToken");
        }
        String content = "accesstoken=" + accessToken + "&refreshtoken=" + refreshToken + "&version=1.0";
        try {
            boolean isSuccess;
            String response = AuthorizationUtil.postRequest(ARK_URL + "/RefreshAccessToken.ashx", content);
            JsonNode tree = JacksonParser.parse(response);
            JsonNode node = tree.get("IsSuccess");
            if (node != null && !node.isNull() && (isSuccess = node.asBoolean())) {
                return;
            }
        }
        catch (Exception ex) {
            throw new OdpsException("refresh domain access token failed: " + ex.getMessage());
        }
        throw new OdpsException("refresh domain access token failed");
    }

    private static String postRequest(String url, String content) throws OdpsException {
        HttpsURLConnection connection = null;
        OutputStream out = null;
        try {
            URL urlObject = new URL(url);
            connection = (HttpsURLConnection)urlObject.openConnection();
            if (IGNORE_CERTS) {
                AuthorizationUtil.ignoreHttpsCerts(connection);
            }
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setReadTimeout(5000);
            connection.setConnectTimeout(5000);
            connection.setRequestMethod("POST");
            out = connection.getOutputStream();
            out.write(content.getBytes());
            out.flush();
            String string = IOUtils.readStreamAsString(connection.getInputStream());
            return string;
        }
        catch (Exception ex) {
            throw new OdpsException(ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void ignoreHttpsCerts(HttpURLConnection conn) throws IOException {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }
            };
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(ctx.getSocketFactory());
                ((HttpsURLConnection)conn).setHostnameVerifier(hv);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

